/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.label;

import java.util.Date;
import java.util.HashMap;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.cs.server.conf.ContextServerConf;
import org.apache.linkis.instance.label.client.InstanceLabelClient;
import org.apache.linkis.protocol.label.InsLabelRefreshRequest;
import org.apache.linkis.protocol.label.InsLabelRemoveRequest;
import org.apache.linkis.publicservice.common.lock.entity.CommonLock;
import org.apache.linkis.publicservice.common.lock.service.CommonLockService;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CSInstanceLabelClient {
    private static final Logger logger = LoggerFactory.getLogger(CSInstanceLabelClient.class);
    @Autowired
    CommonLockService commonLockService;
    private String _LOCK = "_MASTER_PS_CS_LABEL_LOCK";
    CommonLock commonLock = new CommonLock();
    private boolean lock = false;

    @EventListener(classes={AvailabilityChangeEvent.class})
    public void init(AvailabilityChangeEvent<AvailabilityState> availabilityChangeEvent) {
        AvailabilityState state = availabilityChangeEvent.getState();
        logger.info("CSInstanceLabelClient app state {}", (Object)state);
        if (state instanceof ReadinessState && state == ReadinessState.ACCEPTING_TRAFFIC) {
            String confLabel;
            HashMap<String, String> labels = new HashMap<String, String>(1);
            this.commonLock.setLockObject(this._LOCK);
            this.commonLock.setCreateTime(new Date());
            this.commonLock.setUpdateTime(new Date());
            this.commonLock.setCreator(Utils.getJvmUser());
            this.commonLock.setLocker(Utils.getLocalHostname());
            this.commonLock.setUpdator(Utils.getJvmUser());
            this.lock = this.commonLockService.reentrantLock(this.commonLock, Long.valueOf(-1L));
            String suffix = ContextServerConf.CS_LABEL_SUFFIX;
            if (this.lock) {
                logger.info("The master ps-cs node get lock by {}", (Object)(this._LOCK + "-" + this.commonLock.getLocker()));
                confLabel = "cs_1_" + suffix;
            } else {
                confLabel = "cs_2_" + suffix;
            }
            logger.info("register label {} to ps-cs node.", (Object)confLabel);
            labels.put("route", confLabel);
            InsLabelRefreshRequest insLabelRefreshRequest = new InsLabelRefreshRequest();
            insLabelRefreshRequest.setLabels(labels);
            insLabelRefreshRequest.setServiceInstance(Sender.getThisServiceInstance());
            InstanceLabelClient.getInstance().refreshLabelsToInstance(insLabelRefreshRequest);
        }
    }

    @EventListener(classes={ContextClosedEvent.class})
    public void shutdown(ContextClosedEvent contextClosedEvent) {
        logger.info("To remove labels for instance");
        InsLabelRemoveRequest insLabelRemoveRequest = new InsLabelRemoveRequest();
        insLabelRemoveRequest.setServiceInstance(Sender.getThisServiceInstance());
        InstanceLabelClient.getInstance().removeLabelsFromInstance(insLabelRemoveRequest);
        logger.info("success to send clear label rpc request");
        if (this.lock) {
            this.commonLockService.unlock(this.commonLock);
            logger.info("The master ps-cs  node has released lock {}.", (Object)(this.commonLock.getLockObject() + "-" + this.commonLock.getLocker()));
        }
    }
}

