/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.execution;

import java.util.List;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.condition.Condition;
import org.apache.linkis.cs.contextcache.ContextCacheService;
import org.apache.linkis.cs.execution.ConditionExecution;
import org.apache.linkis.cs.execution.fetcher.ContextCacheFetcher;
import org.apache.linkis.cs.execution.matcher.ContextSearchMatcher;
import org.apache.linkis.cs.execution.ruler.ContextSearchRuler;
import org.apache.linkis.cs.optimize.ConditionOptimizer;
import org.apache.linkis.cs.optimize.OptimizedCondition;
import org.apache.linkis.cs.optimize.cost.ConditionCostCalculator;
import org.apache.linkis.cs.optimize.impl.CostBasedConditionOptimizer;

public abstract class AbstractConditionExecution
implements ConditionExecution {
    protected ContextSearchMatcher contextSearchMatcher;
    protected ContextSearchRuler contextSearchRuler;
    protected ContextCacheFetcher contextCacheFetcher;
    protected ContextCacheService contextCacheService;
    protected Condition condition;
    protected ContextID contextID;

    public AbstractConditionExecution(Condition condition, ContextCacheService contextCacheService, ContextID contextID) {
        this.condition = condition;
        this.contextCacheService = contextCacheService;
        this.contextID = contextID;
    }

    @Override
    public List<ContextKeyValue> execute() {
        ContextCacheFetcher fastFetcher;
        if (this.needOptimization()) {
            OptimizedCondition optimizedCondition = this.getConditionOptimizer().optimize(this.condition);
        }
        if ((fastFetcher = this.getFastFetcher()) != null) {
            return this.getContextSearchRuler().rule(fastFetcher.fetch(this.contextID));
        }
        return this.getContextCacheFetcher().fetch(this.contextID);
    }

    protected abstract boolean needOptimization();

    protected abstract ContextCacheFetcher getFastFetcher();

    @Override
    public ContextSearchMatcher getContextSearchMatcher() {
        return this.contextSearchMatcher;
    }

    @Override
    public ContextSearchRuler getContextSearchRuler() {
        return this.contextSearchRuler;
    }

    @Override
    public ContextCacheFetcher getContextCacheFetcher() {
        return this.contextCacheFetcher;
    }

    @Override
    public ContextCacheService getContextCacheService() {
        return this.contextCacheService;
    }

    @Override
    public void setContextCacheService(ContextCacheService contextCacheService) {
        this.contextCacheService = contextCacheService;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    public ConditionOptimizer getConditionOptimizer() {
        return new CostBasedConditionOptimizer(this.getConditionCostCalculator());
    }

    public ConditionCostCalculator getConditionCostCalculator() {
        return new ConditionCostCalculator();
    }
}

