/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.configuration.dao.DepartmentMapper;
import org.apache.linkis.configuration.dao.DepartmentTenantMapper;
import org.apache.linkis.configuration.dao.UserTenantMapper;
import org.apache.linkis.configuration.entity.DepartmentTenantVo;
import org.apache.linkis.configuration.entity.DepartmentVo;
import org.apache.linkis.configuration.entity.TenantVo;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.TenantConfigService;
import org.apache.linkis.configuration.util.ClientUtil;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantConfigServiceImpl
implements TenantConfigService {
    private static final Logger logger = LoggerFactory.getLogger(TenantConfigServiceImpl.class);
    @Autowired
    private UserTenantMapper userTenantMapper;
    @Autowired
    private DepartmentTenantMapper departmentTenantMapper;
    @Autowired
    private DepartmentMapper departmentMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryTenantList(String user, String creator, String tenantValue, Integer pageNow, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<TenantVo> tenantVos = null;
        if (Objects.isNull(pageNow)) {
            pageNow = 1;
        }
        if (Objects.isNull(pageSize)) {
            pageSize = 20;
        }
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            tenantVos = this.userTenantMapper.queryTenantList(user, creator, tenantValue);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(tenantVos);
        result.put("tenantList", tenantVos);
        result.put(JobRequestConstants.TOTAL_PAGE(), pageInfo.getTotal());
        return result;
    }

    @Override
    public void deleteTenant(Integer id) throws ConfigurationException {
        logger.info("deleteUserIP : id:{}", (Object)id);
        if (StringUtils.isBlank((String)id.toString())) {
            throw new ConfigurationException("id can't be empty ");
        }
        this.userTenantMapper.deleteTenant(id);
    }

    @Override
    public void updateTenant(TenantVo tenantVo) throws ConfigurationException {
        if (StringUtils.isBlank((String)tenantVo.getId())) {
            throw new ConfigurationException("id can't be empty ");
        }
        this.dataProcessing(tenantVo);
        tenantVo.setUpdateTime(new Date());
        logger.info("updateTenant : {}", (Object)tenantVo);
        this.userTenantMapper.updateTenant(tenantVo);
    }

    @Override
    public void createTenant(TenantVo tenantVo) throws ConfigurationException {
        this.dataProcessing(tenantVo);
        tenantVo.setCreateTime(new Date());
        tenantVo.setUpdateTime(new Date());
        logger.info("createTenant : {}", (Object)tenantVo);
        this.userTenantMapper.createTenant(tenantVo);
    }

    private void dataProcessing(TenantVo tenantVo) throws ConfigurationException {
        if ("N".equals(tenantVo.getIsValid())) {
            return;
        }
        AtomicReference<Boolean> tenantResult = new AtomicReference<Boolean>(false);
        Map<String, Object> ecmList = null;
        try {
            ecmList = ClientUtil.getEcmList();
            logger.info("Request ecm list  response  {}:", ecmList);
        }
        catch (IOException e) {
            logger.warn("failed to get ecmResource data", (Throwable)e);
        }
        Map data = MapUtils.getMap(ecmList, (Object)"data");
        List emNodeVoList = (List)data.get("EMs");
        emNodeVoList.forEach(ecmInfo -> {
            List labels = (List)ecmInfo.get("labels");
            labels.stream().filter(labelmap -> labelmap.containsKey("tenant")).forEach(map -> {
                String tenant = map.get("tenant").toString();
                if (tenant.equals(tenantVo.getTenantValue())) {
                    tenantResult.set(true);
                }
            });
        });
        if (!tenantResult.get().booleanValue()) {
            throw new ConfigurationException("The ECM with the corresponding label was not found");
        }
        if (!"*".equals(tenantVo.getCreator())) {
            String creator = tenantVo.getCreator();
            String[] tenantArray = tenantVo.getTenantValue().split("_");
            if (tenantArray.length > 1 && !creator.equals(tenantArray[0])) {
                throw new ConfigurationException("tenantValue should contain creator first");
            }
        }
    }

    @Override
    public Boolean isExist(String user, String creator) {
        boolean result = true;
        Map<String, Object> resultMap = this.queryTenantList(user, creator, null, 1, 20);
        Object tenantList = resultMap.getOrDefault(JobRequestConstants.TOTAL_PAGE(), 0);
        int total = Integer.parseInt(tenantList.toString());
        if (total == 0) {
            result = false;
        }
        return result;
    }

    @Override
    public TenantVo queryTenant(String user, String creator) {
        return this.userTenantMapper.queryTenant(user, creator);
    }

    @Override
    public void saveDepartmentTenant(DepartmentTenantVo departmentTenantVo) throws ConfigurationException {
        TenantVo tenantVo = new TenantVo();
        BeanUtils.copyProperties((Object)departmentTenantVo, (Object)tenantVo);
        this.dataProcessing(tenantVo);
        departmentTenantVo.setUpdateTime(new Date());
        if (StringUtils.isBlank((String)departmentTenantVo.getId())) {
            departmentTenantVo.setCreateTime(new Date());
            this.departmentTenantMapper.insertTenant(departmentTenantVo);
        } else {
            this.departmentTenantMapper.updateTenant(departmentTenantVo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryDepartmentTenant(String departmentId, String creator, String tenantValue, Integer pageNow, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<DepartmentTenantVo> tenantVos = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            tenantVos = this.departmentTenantMapper.queryTenantList(creator, departmentId, tenantValue);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(tenantVos);
        result.put("tenantList", tenantVos);
        result.put(JobRequestConstants.TOTAL_PAGE(), pageInfo.getTotal());
        return result;
    }

    @Override
    public void deleteDepartmentTenant(Integer id) {
        this.departmentTenantMapper.deleteTenant(id);
    }

    @Override
    public DepartmentTenantVo queryDepartTenant(String creator, String departmentId) {
        return this.departmentTenantMapper.queryTenant(creator, departmentId);
    }

    @Override
    public List<DepartmentVo> queryDepartmentList() {
        return new ArrayList<DepartmentVo>(this.departmentMapper.queryDepartmentList().stream().collect(Collectors.toMap(DepartmentVo::getOrgId, department -> department, (existing, replacement) -> existing)).values());
    }

    @Override
    public DepartmentVo getDepartmentByUser(String user) {
        return this.departmentMapper.getDepartmentByUser(user);
    }
}

