/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.configuration.dao.ConfigKeyLimitForUserMapper;
import org.apache.linkis.configuration.dao.ConfigMapper;
import org.apache.linkis.configuration.dao.LabelMapper;
import org.apache.linkis.configuration.dao.TemplateConfigKeyMapper;
import org.apache.linkis.configuration.entity.ConfigKey;
import org.apache.linkis.configuration.entity.ConfigKeyLimitForUser;
import org.apache.linkis.configuration.entity.ConfigKeyLimitVo;
import org.apache.linkis.configuration.entity.ConfigLabel;
import org.apache.linkis.configuration.entity.ConfigValue;
import org.apache.linkis.configuration.entity.TemplateConfigKey;
import org.apache.linkis.configuration.entity.TemplateConfigKeyVO;
import org.apache.linkis.configuration.enumeration.BoundaryTypeEnum;
import org.apache.linkis.configuration.exception.ConfigurationException;
import org.apache.linkis.configuration.service.ConfigKeyService;
import org.apache.linkis.configuration.service.ConfigurationService;
import org.apache.linkis.configuration.service.TemplateConfigKeyService;
import org.apache.linkis.configuration.util.LabelEntityParser;
import org.apache.linkis.configuration.validate.ValidatorManager;
import org.apache.linkis.governance.common.entity.TemplateConfKey;
import org.apache.linkis.governance.common.protocol.conf.TemplateConfRequest;
import org.apache.linkis.governance.common.protocol.conf.TemplateConfResponse;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TemplateConfigKeyServiceImpl
implements TemplateConfigKeyService {
    private static final Logger logger = LoggerFactory.getLogger(TemplateConfigKeyServiceImpl.class);
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private LabelMapper labelMapper;
    @Autowired
    private TemplateConfigKeyMapper templateConfigKeyMapper;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ConfigKeyService configKeyService;
    @Autowired
    private ValidatorManager validatorManager;
    @Autowired
    private ConfigKeyLimitForUserMapper configKeyLimitForUserMapper;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    @Override
    @Transactional
    public Boolean updateKeyMapping(String templateUid, String templateName, String engineType, String operator, List<ConfigKeyLimitVo> itemList, Boolean isFullMode) throws ConfigurationException {
        List<TemplateConfigKey> oldList;
        List<Long> needToRemoveList;
        List<String> keyList = itemList.stream().map(e -> e.getKey()).collect(Collectors.toList());
        List<ConfigKey> configKeyList = this.configMapper.selectKeyByEngineTypeAndKeyList(engineType, keyList);
        List keyIdList = configKeyList.stream().map(e -> e.getId()).collect(Collectors.toList());
        if (configKeyList.size() != itemList.size()) {
            List dbKeyList = configKeyList.stream().map(e -> e.getKey()).collect(Collectors.toList());
            String msg = MessageFormat.format("The num of configuration item data from the DB is inconsistent with input(\u4eceDB\u4e2d\u83b7\u53d6\u5230\u7684\u914d\u7f6e\u6570\u636e\u6761\u6570\u4e0d\u4e00\u81f4) :engineType:{0}, input keys:{1}, db keys:{2}", engineType, String.join((CharSequence)",", keyList), String.join((CharSequence)",", dbKeyList));
            throw new ConfigurationException(msg);
        }
        ArrayList<TemplateConfigKey> toUpdateOrInsertList = new ArrayList<TemplateConfigKey>();
        Map<String, ConfigKey> configKeyMap = configKeyList.stream().collect(Collectors.toMap(ConfigKey::getKey, item -> item));
        for (ConfigKeyLimitVo item2 : itemList) {
            String msg;
            String key = item2.getKey();
            ConfigKey temp = configKeyMap.get(item2.getKey());
            String validateType = temp.getValidateType();
            String validateRange = temp.getValidateRange();
            String configValue = item2.getConfigValue();
            String maxValue = item2.getMaxValue();
            if (StringUtils.isNotEmpty((CharSequence)configValue) && !this.validatorManager.getOrCreateValidator(validateType).validate(configValue, validateRange)) {
                msg = MessageFormat.format("Parameter configValue verification failed(\u53c2\u6570configValue\u6821\u9a8c\u5931\u8d25):key:{0}, ValidateType:{1}, ValidateRange:{2},ConfigValue:{3}", key, validateType, validateRange, configValue);
                throw new ConfigurationException(msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)maxValue) && BoundaryTypeEnum.WITH_BOTH.getId().equals(temp.getBoundaryType())) {
                if (!this.validatorManager.getOrCreateValidator(validateType).validate(maxValue, validateRange)) {
                    msg = MessageFormat.format("Parameter maxValue verification failed(\u53c2\u6570maxValue\u6821\u9a8c\u5931\u8d25):key:{0}, ValidateType:{1}, ValidateRange:{2}, maxValue:{3}", key, validateType, validateRange, maxValue);
                    throw new ConfigurationException(msg);
                }
                try {
                    Integer maxVal = Integer.valueOf(maxValue.replaceAll("[^0-9]", ""));
                    Integer configVal = Integer.valueOf(configValue.replaceAll("[^0-9]", ""));
                    if (configVal > maxVal) {
                        String msg2 = MessageFormat.format("Parameter key:{0},config value:{1} verification failed, exceeds the specified max value: {2}:(\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u8d85\u8fc7\u6307\u5b9a\u7684\u6700\u5927\u503c):", key, configVal, maxVal);
                        throw new ConfigurationException(msg2);
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof ConfigurationException) {
                        throw exception;
                    }
                    logger.warn("Failed to check special limit setting for key:" + key + ",config value:" + configValue);
                }
            }
            Long keyId = temp.getId();
            TemplateConfigKey templateConfigKey = new TemplateConfigKey();
            templateConfigKey.setTemplateName(templateName);
            templateConfigKey.setTemplateUuid(templateUid);
            templateConfigKey.setKeyId(keyId);
            templateConfigKey.setConfigValue(configValue);
            templateConfigKey.setMaxValue(maxValue);
            templateConfigKey.setCreateBy(operator);
            templateConfigKey.setUpdateBy(operator);
            toUpdateOrInsertList.add(templateConfigKey);
        }
        if (isFullMode.booleanValue() && (needToRemoveList = (oldList = this.templateConfigKeyMapper.selectListByTemplateUuid(templateUid)).stream().filter(item -> !keyIdList.contains(item.getKeyId())).map(e -> e.getKeyId()).collect(Collectors.toList())).size() > 0) {
            logger.info("Try to remove old data:[" + needToRemoveList + "] for templateUid:" + templateUid);
            this.templateConfigKeyMapper.deleteByTemplateUuidAndKeyIdList(templateUid, needToRemoveList);
        }
        if (toUpdateOrInsertList.size() == 0) {
            String msg = "No key data to update, Please check if the keys are correct";
            throw new ConfigurationException(msg);
        }
        this.templateConfigKeyMapper.batchInsertOrUpdateList(toUpdateOrInsertList);
        return true;
    }

    @Override
    public List<Object> queryKeyInfoList(List<String> uuidList) throws ConfigurationException {
        ArrayList<Object> result = new ArrayList<Object>();
        List<TemplateConfigKey> templateConfigKeyList = this.templateConfigKeyMapper.selectListByTemplateUuidList(uuidList);
        Map<String, List<TemplateConfigKey>> templateConfigKeyListGroupByUuid = templateConfigKeyList.stream().collect(Collectors.groupingBy(TemplateConfigKey::getTemplateUuid));
        List<Long> keyIdList = templateConfigKeyList.stream().map(e -> e.getKeyId()).distinct().collect(Collectors.toList());
        if (keyIdList.size() == 0) {
            String msg = "can not get any config key info from db, Please check if the keys are correct";
            throw new ConfigurationException(msg);
        }
        List<ConfigKey> configKeyList = this.configMapper.selectKeyByKeyIdList(keyIdList);
        Map<Long, ConfigKey> configKeyMap = configKeyList.stream().collect(Collectors.toMap(ConfigKey::getId, item -> item));
        for (String uuid : templateConfigKeyListGroupByUuid.keySet()) {
            String msg;
            HashMap<String, Object> item2 = new HashMap<String, Object>();
            ArrayList keys = new ArrayList();
            item2.put("templateUid", uuid);
            String engineType = "";
            List<String> engineTypeList = this.templateConfigKeyMapper.selectEngineTypeByTemplateUuid(uuid);
            if (engineTypeList.size() > 1) {
                msg = MessageFormat.format("template uuid:{0} associated with the engine type:{1} more than one! Please check if the keys are correct", uuid, StringUtils.join((Object[])engineTypeList.toArray(), (String)","));
                throw new ConfigurationException(msg);
            }
            if (engineTypeList.size() == 0) {
                msg = MessageFormat.format("template uuid:{0} can not associated with any engine type! Please check if the keys are correct", uuid);
                throw new ConfigurationException(msg);
            }
            engineType = engineTypeList.get(0);
            Map<Long, TemplateConfigKey> templateConfigKeyMap = templateConfigKeyListGroupByUuid.get(uuid).stream().collect(Collectors.toMap(TemplateConfigKey::getKeyId, elemt -> elemt));
            List<ConfigKey> ecKeyList = this.configKeyService.getConfigKeyList(engineType);
            for (ConfigKey configKey : ecKeyList) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("key", configKey.getKey());
                temp.put("name", configKey.getName());
                temp.put("description", configKey.getDescription());
                temp.put("engineType", configKey.getEngineType());
                temp.put("validateType", configKey.getValidateType());
                temp.put("validateRange", configKey.getValidateRange());
                temp.put("boundaryType", configKey.getBoundaryType());
                temp.put("defaultValue", configKey.getDefaultValue());
                temp.put("require", configKey.getTemplateRequired());
                temp.put("keyId", configKey.getId());
                Long keyId = configKey.getId();
                TemplateConfigKey templateConfigKey = templateConfigKeyMap.get(keyId);
                if (templateConfigKey == null) {
                    temp.put("configValue", null);
                    temp.put("maxValue", null);
                    temp.put("createBy", null);
                    temp.put("createTime", null);
                    temp.put("updateBy", null);
                    temp.put("updateTime", null);
                } else {
                    temp.put("configValue", templateConfigKey.getConfigValue());
                    temp.put("maxValue", templateConfigKey.getMaxValue());
                    temp.put("createBy", templateConfigKey.getCreateBy());
                    temp.put("createTime", templateConfigKey.getCreateTime());
                    temp.put("updateBy", templateConfigKey.getUpdateBy());
                    temp.put("updateTime", templateConfigKey.getUpdateTime());
                }
                keys.add(temp);
            }
            item2.put("itemList", keys);
            result.add(item2);
        }
        return result;
    }

    @Override
    public Map<String, Object> apply(String templateUid, String application, String engineType, String engineVersion, String operator, List<String> userList) throws ConfigurationException {
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        ArrayList<String> templateUuidList = new ArrayList<String>();
        templateUuidList.add(templateUid);
        List<TemplateConfigKey> templateConfigKeyList = this.templateConfigKeyMapper.selectListByTemplateUuidList(templateUuidList);
        if (templateConfigKeyList.size() == 0) {
            String msg = MessageFormat.format("The template configuration is empty. Please check the template associated configuration information in the database table(\u6a21\u677f\u5173\u8054\u7684\u914d\u7f6e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8868\u4e2d\u5173\u4e8e\u6a21\u677fid\uff1a{0} \u5173\u8054\u914d\u7f6e\u9879\u662f\u5426\u5b8c\u6574)", templateUid);
            throw new ConfigurationException(msg);
        }
        List<Long> keyIdList = templateConfigKeyList.stream().map(e -> e.getKeyId()).distinct().collect(Collectors.toList());
        if (keyIdList.size() == 0) {
            String msg = "can not get any config key info from db, Please check if the keys are correct";
            throw new ConfigurationException(msg);
        }
        List<ConfigKey> configKeyList = this.configMapper.selectKeyByKeyIdList(keyIdList);
        Set configKeyEngineTypeSet = configKeyList.stream().map(ConfigKey::getEngineType).collect(Collectors.toSet());
        if (configKeyEngineTypeSet == null || configKeyEngineTypeSet.size() == 0) {
            String msg = MessageFormat.format("Unable to get configuration parameter information associated with template id:{0}, please check whether the parameters are correct(\u65e0\u6cd5\u83b7\u53d6\u6a21\u677f:{0} \u5173\u8054\u7684\u914d\u7f6e\u53c2\u6570\u4fe1\u606f,\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e)", templateUid);
            throw new ConfigurationException(msg);
        }
        configKeyEngineTypeSet.add(Configuration.GLOBAL_CONF_SYMBOL());
        if (!configKeyEngineTypeSet.contains(engineType)) {
            String msg = MessageFormat.format("The engineType:{0} associated with the template:{1} does not match the input engineType:{2}, please check whether the parameters are correct(\u6a21\u677f\u5173\u8054\u7684\u5f15\u64ce\u7c7b\u578b\uff1a{0} \u548c\u4e0b\u53d1\u7684\u5f15\u64ce\u7c7b\u578b\uff1a{2} \u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e)", String.join((CharSequence)",", configKeyEngineTypeSet), templateUid, engineType);
            throw new ConfigurationException(msg);
        }
        for (String user : userList) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("user", user);
            try {
                CombinedLabel combinedLabel = this.configurationService.generateCombinedLabel(engineType, engineVersion, user, application);
                String conbinedLabelKey = combinedLabel.getLabelKey();
                String conbinedLabelStringValue = combinedLabel.getStringValue();
                ConfigLabel configLabel = this.labelMapper.getLabelByKeyValue(conbinedLabelKey, conbinedLabelStringValue);
                if (null == configLabel || configLabel.getId() < 0) {
                    configLabel = LabelEntityParser.parseToConfigLabel(combinedLabel);
                    this.labelMapper.insertLabel(configLabel);
                    logger.info("succeed to create label: {}", (Object)configLabel.getStringValue());
                }
                ArrayList<ConfigValue> configValues = new ArrayList<ConfigValue>();
                ArrayList<ConfigKeyLimitForUser> configKeyLimitForUsers = new ArrayList<ConfigKeyLimitForUser>();
                for (TemplateConfigKey templateConfigKey : templateConfigKeyList) {
                    Long keyId = templateConfigKey.getKeyId();
                    String uuid = templateConfigKey.getTemplateUuid();
                    String confVal = templateConfigKey.getConfigValue();
                    String maxVal = templateConfigKey.getMaxValue();
                    ConfigValue configValue = new ConfigValue();
                    configValue.setConfigKeyId(keyId);
                    configValue.setConfigValue(confVal);
                    configValue.setConfigLabelId(configLabel.getId());
                    configValues.add(configValue);
                    ConfigKeyLimitForUser configKeyLimitForUser = new ConfigKeyLimitForUser();
                    configKeyLimitForUser.setUserName(user);
                    configKeyLimitForUser.setCombinedLabelValue(configLabel.getStringValue());
                    configKeyLimitForUser.setKeyId(keyId);
                    configKeyLimitForUser.setConfigValue(confVal);
                    configKeyLimitForUser.setMaxValue(maxVal);
                    configKeyLimitForUser.setLatestUpdateTemplateUuid(uuid);
                    configKeyLimitForUser.setCreateBy(operator);
                    configKeyLimitForUser.setUpdateBy(operator);
                    configKeyLimitForUsers.add(configKeyLimitForUser);
                }
                if (configValues.size() == 0) {
                    res.put("msg", "can not get any right key form the db");
                    errorList.add(res);
                    continue;
                }
                DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
                TransactionStatus status = this.platformTransactionManager.getTransaction((TransactionDefinition)transactionDefinition);
                try {
                    this.configMapper.batchInsertOrUpdateValueList(configValues);
                    this.configKeyLimitForUserMapper.batchInsertOrUpdateList(configKeyLimitForUsers);
                    this.platformTransactionManager.commit(status);
                }
                catch (Exception ex) {
                    this.platformTransactionManager.rollback(status);
                    throw ex;
                }
                successList.add(res);
            }
            catch (Exception e2) {
                logger.warn("try to update configurations for  user:" + user + " with error", (Throwable)e2);
                res.put("msg", e2.getMessage());
                errorList.add(res);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Serializable> successResult = new HashMap<String, Serializable>();
        HashMap<String, Serializable> errorResult = new HashMap<String, Serializable>();
        successResult.put("num", Integer.valueOf(successList.size()));
        successResult.put("infoList", successList);
        errorResult.put("num", Integer.valueOf(errorList.size()));
        errorResult.put("infoList", errorList);
        result.put("success", successResult);
        result.put("error", errorResult);
        return result;
    }

    @Override
    @Receiver
    public TemplateConfResponse queryKeyInfoList(TemplateConfRequest templateConfRequest) {
        TemplateConfResponse result = new TemplateConfResponse();
        String templateUid = templateConfRequest.getTemplateUuid();
        String templateName = templateConfRequest.getTemplateName();
        if (logger.isDebugEnabled()) {
            logger.debug("query conf list with uid:{},name:{}", (Object)templateUid, (Object)templateName);
        }
        if (StringUtils.isBlank((CharSequence)templateUid) && StringUtils.isBlank((CharSequence)templateName)) {
            return result;
        }
        List<Object> voList = new ArrayList();
        voList = StringUtils.isNotBlank((CharSequence)templateUid) ? this.templateConfigKeyMapper.selectInfoListByTemplateUuid(templateUid) : this.templateConfigKeyMapper.selectInfoListByTemplateName(templateName);
        ArrayList<TemplateConfKey> data = new ArrayList<TemplateConfKey>();
        if (voList != null) {
            for (TemplateConfigKeyVO templateConfigKeyVO : voList) {
                TemplateConfKey item = new TemplateConfKey();
                item.setTemplateUuid(templateConfigKeyVO.getTemplateUuid());
                item.setKey(templateConfigKeyVO.getKey());
                item.setTemplateName(templateConfigKeyVO.getTemplateName());
                item.setConfigValue(templateConfigKeyVO.getConfigValue());
                data.add(item);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("query conf item={}", (Object)item);
            }
        }
        result.setList(data);
        return result;
    }
}

