/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.LinkisCommonErrorException;
import org.apache.linkis.common.utils.CodeAndRunTypeUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.common.utils.VariableOperationUtils;
import org.apache.linkis.common.variable.CustomDateType;
import org.apache.linkis.common.variable.CustomDateType$;
import org.apache.linkis.common.variable.CustomHalfYearType;
import org.apache.linkis.common.variable.CustomHalfYearType$;
import org.apache.linkis.common.variable.CustomHourType;
import org.apache.linkis.common.variable.CustomMonType;
import org.apache.linkis.common.variable.CustomMonType$;
import org.apache.linkis.common.variable.CustomMonthType;
import org.apache.linkis.common.variable.CustomMonthType$;
import org.apache.linkis.common.variable.CustomQuarterType;
import org.apache.linkis.common.variable.CustomQuarterType$;
import org.apache.linkis.common.variable.CustomYearType;
import org.apache.linkis.common.variable.CustomYearType$;
import org.apache.linkis.common.variable.DateType;
import org.apache.linkis.common.variable.DateTypeUtils$;
import org.apache.linkis.common.variable.DoubleValue;
import org.apache.linkis.common.variable.HalfYearType;
import org.apache.linkis.common.variable.HourType;
import org.apache.linkis.common.variable.MonType;
import org.apache.linkis.common.variable.MonthType;
import org.apache.linkis.common.variable.QuarterType;
import org.apache.linkis.common.variable.StringType;
import org.apache.linkis.common.variable.VariableType;
import org.apache.linkis.common.variable.YearType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class VariableUtils$
implements Logging {
    public static VariableUtils$ MODULE$;
    private final String RUN_DATE;
    private final String RUN_TODAY_H;
    private final String RUN_TODAY_HOUR;
    private final Regex codeReg;
    private final Regex calReg;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new VariableUtils$();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$(this, message);
    }

    private Logger logger$lzycompute() {
        VariableUtils$ variableUtils$ = this;
        synchronized (variableUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String RUN_DATE() {
        return this.RUN_DATE;
    }

    public String RUN_TODAY_H() {
        return this.RUN_TODAY_H;
    }

    public String RUN_TODAY_HOUR() {
        return this.RUN_TODAY_HOUR;
    }

    private Regex codeReg() {
        return this.codeReg;
    }

    private Regex calReg() {
        return this.calReg;
    }

    public String replace(String replaceStr) {
        return this.replace(replaceStr, new HashMap<String, Object>(0));
    }

    public String replace(String replaceStr, Map<String, Object> variables) {
        String runTodayHourStr;
        String runTodayHStr;
        scala.collection.mutable.Map nameAndType = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef run_date = ObjectRef.create(null);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(variables).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VariableUtils$.$anonfun$replace$1(nameAndType, run_date, x0$1);
            return BoxedUnit.UNIT;
        });
        if (!nameAndType.contains((Object)this.RUN_DATE()) || (CustomDateType)run_date.elem == null) {
            run_date.elem = new CustomDateType(DateTypeUtils$.MODULE$.getYesterday(false), false);
            nameAndType.update((Object)this.RUN_DATE(), (Object)new DateType(new CustomDateType(((CustomDateType)run_date.elem).toString(), false)));
        }
        if (variables.containsKey(this.RUN_TODAY_H()) && StringUtils.isNotBlank((CharSequence)(runTodayHStr = (String)variables.get(this.RUN_TODAY_H())))) {
            CustomHourType runTodayH = new CustomHourType(runTodayHStr, false);
            nameAndType.update((Object)this.RUN_TODAY_H(), (Object)new HourType(runTodayH));
        }
        if (variables.containsKey(this.RUN_TODAY_HOUR()) && StringUtils.isNotBlank((CharSequence)(runTodayHourStr = (String)variables.get(this.RUN_TODAY_HOUR())))) {
            CustomHourType runTodayHour = new CustomHourType(runTodayHourStr, false);
            nameAndType.update((Object)this.RUN_TODAY_HOUR(), (Object)new HourType(runTodayHour));
        }
        this.initAllDateVars((CustomDateType)run_date.elem, (scala.collection.mutable.Map<String, VariableType>)nameAndType);
        String codeOperation = this.parserVar(replaceStr, (scala.collection.mutable.Map<String, VariableType>)nameAndType);
        return this.parserDate(codeOperation, (CustomDateType)run_date.elem);
    }

    public String replace(String code, String codeType, Map<String, String> variables) {
        String runTodayHourStr;
        String runTodayHStr;
        String languageType = CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType(codeType, CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType$default$2());
        if (StringUtils.isBlank((CharSequence)languageType)) {
            return code;
        }
        ObjectRef run_date = ObjectRef.create(null);
        scala.collection.mutable.Map nameAndType = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map<String, String> nameAndValue = this.getCustomVar(code, languageType);
        VariableUtils$.putNameAndType$1(nameAndValue, nameAndType, run_date);
        if (variables.containsKey("user")) {
            nameAndType.update((Object)"user", (Object)new StringType(variables.get("user")));
        }
        if (variables != null) {
            VariableUtils$.putNameAndType$1((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(variables).asScala(), nameAndType, run_date);
        }
        if (!nameAndType.contains((Object)this.RUN_DATE()) || (CustomDateType)run_date.elem == null) {
            run_date.elem = new CustomDateType(DateTypeUtils$.MODULE$.getYesterday(false), false);
            nameAndType.update((Object)this.RUN_DATE(), (Object)new DateType(new CustomDateType(((CustomDateType)run_date.elem).toString(), false)));
        }
        if (variables.containsKey(this.RUN_TODAY_H()) && StringUtils.isNotBlank((CharSequence)(runTodayHStr = variables.get(this.RUN_TODAY_H())))) {
            CustomHourType runTodayH = new CustomHourType(runTodayHStr, false);
            nameAndType.update((Object)this.RUN_TODAY_H(), (Object)new HourType(runTodayH));
        }
        if (variables.containsKey(this.RUN_TODAY_HOUR()) && StringUtils.isNotBlank((CharSequence)(runTodayHourStr = variables.get(this.RUN_TODAY_HOUR())))) {
            CustomHourType runTodayHour = new CustomHourType(runTodayHourStr, false);
            nameAndType.update((Object)this.RUN_TODAY_HOUR(), (Object)new HourType(runTodayHour));
        }
        this.initAllDateVars((CustomDateType)run_date.elem, (scala.collection.mutable.Map<String, VariableType>)nameAndType);
        String codeOperation = this.parserVar(code, (scala.collection.mutable.Map<String, VariableType>)nameAndType);
        return this.parserDate(codeType, codeOperation, (CustomDateType)run_date.elem);
    }

    private String parserDate(String code, CustomDateType run_date) {
        ZonedDateTime zonedDateTime = VariableOperationUtils.toZonedDateTime(run_date.getDate());
        return VariableOperationUtils.replaces(zonedDateTime, code);
    }

    private String parserDate(String codeType, String code, CustomDateType run_date) {
        ZonedDateTime zonedDateTime = VariableOperationUtils.toZonedDateTime(run_date.getDate());
        return VariableOperationUtils.replaces(codeType, zonedDateTime, code);
    }

    private void initAllDateVars(CustomDateType run_date, scala.collection.mutable.Map<String, VariableType> nameAndType) {
        HourType hourType;
        HourType hourType2;
        String run_date_str = run_date.toString();
        nameAndType.update((Object)"run_date_std", (Object)new DateType(new CustomDateType(run_date.getStdDate(), CustomDateType$.MODULE$.$lessinit$greater$default$2())));
        nameAndType.update((Object)"run_month_begin", (Object)new MonthType(new CustomMonthType(run_date_str, false, CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_begin_std", (Object)new MonthType(new CustomMonthType(run_date_str, CustomMonthType$.MODULE$.$lessinit$greater$default$2(), CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_end", (Object)new MonthType(new CustomMonthType(run_date_str, false, true)));
        nameAndType.update((Object)"run_month_end_std", (Object)new MonthType(new CustomMonthType(run_date_str, true, true)));
        nameAndType.update((Object)"run_quarter_begin", (Object)new QuarterType(new CustomQuarterType(run_date_str, false, CustomQuarterType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_quarter_begin_std", (Object)new QuarterType(new CustomQuarterType(run_date_str, CustomQuarterType$.MODULE$.$lessinit$greater$default$2(), CustomQuarterType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_quarter_end", (Object)new QuarterType(new CustomQuarterType(run_date_str, false, true)));
        nameAndType.update((Object)"run_quarter_end_std", (Object)new QuarterType(new CustomQuarterType(run_date_str, true, true)));
        nameAndType.update((Object)"run_half_year_begin", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, false, CustomHalfYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_half_year_begin_std", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, CustomHalfYearType$.MODULE$.$lessinit$greater$default$2(), CustomHalfYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_half_year_end", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, false, true)));
        nameAndType.update((Object)"run_half_year_end_std", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, true, true)));
        nameAndType.update((Object)"run_year_begin", (Object)new YearType(new CustomYearType(run_date_str, false, CustomYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_year_begin_std", (Object)new YearType(new CustomYearType(run_date_str, CustomYearType$.MODULE$.$lessinit$greater$default$2(), CustomYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_year_end", (Object)new YearType(new CustomYearType(run_date_str, false, true)));
        nameAndType.update((Object)"run_year_end_std", (Object)new YearType(new CustomYearType(run_date_str, true, true)));
        nameAndType.update((Object)"run_date_std", (Object)new DateType(new CustomDateType(run_date.getStdDate(), CustomDateType$.MODULE$.$lessinit$greater$default$2())));
        nameAndType.update((Object)"run_month_begin", (Object)new MonthType(new CustomMonthType(run_date_str, false, CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_begin_std", (Object)new MonthType(new CustomMonthType(run_date_str, CustomMonthType$.MODULE$.$lessinit$greater$default$2(), CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_end", (Object)new MonthType(new CustomMonthType(run_date_str, false, true)));
        nameAndType.update((Object)"run_month_end_std", (Object)new MonthType(new CustomMonthType(run_date_str, true, true)));
        nameAndType.update((Object)"run_quarter_begin", (Object)new QuarterType(new CustomQuarterType(run_date_str, false, CustomQuarterType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_quarter_begin_std", (Object)new QuarterType(new CustomQuarterType(run_date_str, CustomQuarterType$.MODULE$.$lessinit$greater$default$2(), CustomQuarterType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_quarter_end", (Object)new QuarterType(new CustomQuarterType(run_date_str, false, true)));
        nameAndType.update((Object)"run_quarter_end_std", (Object)new QuarterType(new CustomQuarterType(run_date_str, true, true)));
        nameAndType.update((Object)"run_half_year_begin", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, false, CustomHalfYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_half_year_begin_std", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, CustomHalfYearType$.MODULE$.$lessinit$greater$default$2(), CustomHalfYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_half_year_end", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, false, true)));
        nameAndType.update((Object)"run_half_year_end_std", (Object)new HalfYearType(new CustomHalfYearType(run_date_str, true, true)));
        nameAndType.update((Object)"run_year_begin", (Object)new YearType(new CustomYearType(run_date_str, false, CustomYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_year_begin_std", (Object)new YearType(new CustomYearType(run_date_str, CustomYearType$.MODULE$.$lessinit$greater$default$2(), CustomYearType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_year_end", (Object)new YearType(new CustomYearType(run_date_str, false, true)));
        nameAndType.update((Object)"run_year_end_std", (Object)new YearType(new CustomYearType(run_date_str, true, true)));
        CustomDateType run_today = new CustomDateType(DateTypeUtils$.MODULE$.getToday(false, run_date.$plus(1)), false);
        nameAndType.update((Object)"run_today", (Object)new DateType(new CustomDateType(run_today.toString(), false)));
        nameAndType.update((Object)"run_today_std", (Object)new DateType(new CustomDateType(run_today.getStdDate(), CustomDateType$.MODULE$.$lessinit$greater$default$2())));
        nameAndType.update((Object)"run_month_now_begin", (Object)new MonthType(new CustomMonthType(new CustomMonthType(run_today.toString(), false, CustomMonthType$.MODULE$.$lessinit$greater$default$3()).$minus(1), false, CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_now_begin_std", (Object)new MonthType(new CustomMonthType(new CustomMonthType(run_today.toString(), false, CustomMonthType$.MODULE$.$lessinit$greater$default$3()).$minus(1), CustomMonthType$.MODULE$.$lessinit$greater$default$2(), CustomMonthType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_month_now_end", (Object)new MonthType(new CustomMonthType(new CustomMonthType(run_today.toString(), false, CustomMonthType$.MODULE$.$lessinit$greater$default$3()).$minus(1), false, true)));
        nameAndType.update((Object)"run_month_now_end_std", (Object)new MonthType(new CustomMonthType(new CustomMonthType(run_today.toString(), false, CustomMonthType$.MODULE$.$lessinit$greater$default$3()).$minus(1), true, true)));
        CustomMonType run_mon = new CustomMonType(DateTypeUtils$.MODULE$.getMonthDay(false, run_date.getDate()), false, CustomMonType$.MODULE$.$lessinit$greater$default$3());
        nameAndType.update((Object)"run_mon", (Object)new MonType(new CustomMonType(run_mon.toString(), false, CustomMonType$.MODULE$.$lessinit$greater$default$3())));
        nameAndType.update((Object)"run_mon_std", (Object)new MonType(new CustomMonType(run_mon.toString(), true, false)));
        nameAndType.update((Object)"run_mon_start", (Object)new MonType(new CustomMonType(run_mon.toString(), false, false)));
        nameAndType.update((Object)"run_mon_start_std", (Object)new MonType(new CustomMonType(run_mon.toString(), true, false)));
        nameAndType.update((Object)"run_mon_end", (Object)new MonType(new CustomMonType(run_mon.toString(), false, true)));
        nameAndType.update((Object)"run_mon_end_std", (Object)new MonType(new CustomMonType(run_mon.toString(), true, true)));
        if (nameAndType.contains((Object)this.RUN_TODAY_H())) {
            hourType2 = (HourType)nameAndType.apply((Object)this.RUN_TODAY_H());
        } else {
            CustomHourType run_today_h = new CustomHourType(DateTypeUtils$.MODULE$.getCurHour(false, run_today.toString()), false);
            nameAndType.update((Object)this.RUN_TODAY_H(), (Object)new HourType(run_today_h));
            hourType2 = BoxedUnit.UNIT;
        }
        nameAndType.update((Object)"run_today_h_std", (Object)new HourType(new CustomHourType(((HourType)nameAndType.apply((Object)this.RUN_TODAY_H())).getValue(), true)));
        if (nameAndType.contains((Object)"run_today_hour")) {
            hourType = (HourType)nameAndType.apply((Object)"run_today_hour");
        } else {
            CustomHourType run_today_hour = new CustomHourType(DateTypeUtils$.MODULE$.getCurHour(false, run_today.toString()), false);
            nameAndType.update((Object)"run_today_hour", (Object)new HourType(run_today_hour));
            hourType = BoxedUnit.UNIT;
        }
        nameAndType.update((Object)"run_today_hour_std", (Object)new HourType(new CustomHourType(((HourType)nameAndType.apply((Object)"run_today_hour")).getValue(), true)));
        CustomMonType run_roday_mon = new CustomMonType(DateTypeUtils$.MODULE$.getMonthDay(false, run_today.getDate()), false, CustomMonType$.MODULE$.$lessinit$greater$default$3());
        nameAndType.update((Object)"run_last_mon_now", (Object)new MonType(new CustomMonType(run_roday_mon.$minus(1), false, false)));
        nameAndType.update((Object)"run_last_mon_now_std", (Object)new MonType(new CustomMonType(run_roday_mon.$minus(1), true, false)));
        nameAndType.update((Object)"run_current_mon_now", (Object)new MonType(new CustomMonType(run_roday_mon.toString(), false, false)));
        nameAndType.update((Object)"run_current_mon_now_std", (Object)new MonType(new CustomMonType(run_roday_mon.toString(), true, false)));
        nameAndType.update((Object)"run_mon_now", (Object)new MonType(new CustomMonType(run_roday_mon.toString(), false, false)));
        nameAndType.update((Object)"run_mon_now_std", (Object)new MonType(new CustomMonType(run_roday_mon.toString(), true, false)));
    }

    public String parserVar(String code, scala.collection.mutable.Map<String, VariableType> nameAndType) {
        StringBuilder parseCode = new StringBuilder();
        String[] codes = this.codeReg().split((CharSequence)code);
        HashSet expressionCache = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef i = IntRef.create((int)0);
        this.codeReg().findAllIn((CharSequence)code).foreach((Function1 & Serializable & scala.Serializable)str -> {
            VariableUtils$.$anonfun$parserVar$1(i, nameAndType, parseCode, codes, expressionCache, str);
            return BoxedUnit.UNIT;
        });
        Object object = i.elem == codes.length - 1 ? parseCode.$plus$plus$eq(codes[i.elem]) : BoxedUnit.UNIT;
        return StringUtils.strip((String)parseCode.toString());
    }

    public scala.collection.mutable.Map<String, String> getCustomVar(String code, String languageType) {
        scala.collection.mutable.Map nameAndValue = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        String varString = null;
        String errString = null;
        String rightVarString = null;
        String string = languageType;
        String string2 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SQL();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            varString = "\\s*--@set\\s*.+\\s*";
            rightVarString = "^\\s*--@set\\s*.+\\s*";
            errString = "\\s*--@.*";
        } else {
            boolean bl;
            String string4 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_PYTHON();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                bl = true;
            } else {
                String string6 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SHELL();
                String string7 = string;
                bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
            }
            if (bl) {
                varString = "\\s*#@set\\s*.+\\s*";
                rightVarString = "^\\s*#@set\\s*.+\\s*";
                errString = "\\s*#@";
            } else {
                String string8 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SCALA();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    varString = "\\s*//@set\\s*.+\\s*";
                    rightVarString = "^\\s*//@set\\s*.+\\s*";
                    errString = "\\s*//@.+";
                } else {
                    String string10 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_JAVA();
                    String string11 = string;
                    if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                        varString = "\\s*!!@set\\s*.+\\s*";
                        rightVarString = "^\\s*!!@set\\s*.+\\s*";
                    } else {
                        return nameAndValue;
                    }
                }
            }
        }
        UnanchoredRegex customRegex = new StringOps(Predef$.MODULE$.augmentString(varString)).r().unanchored();
        UnanchoredRegex customRightRegex = new StringOps(Predef$.MODULE$.augmentString(rightVarString)).r().unanchored();
        UnanchoredRegex errRegex = new StringOps(Predef$.MODULE$.augmentString(errString)).r().unanchored();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])code.split("\n"))).foreach((Function1 & Serializable & scala.Serializable)str -> {
            VariableUtils$.$anonfun$getCustomVar$1(customRightRegex, customRegex, nameAndValue, errRegex, str);
            return BoxedUnit.UNIT;
        });
        return nameAndValue;
    }

    public static final /* synthetic */ void $anonfun$replace$1(scala.collection.mutable.Map nameAndType$1, ObjectRef run_date$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object value = tuple2._2();
            String string2 = MODULE$.RUN_DATE();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !nameAndType$1.contains((Object)MODULE$.RUN_DATE())) {
                String run_date_str = (String)value;
                if (StringUtils.isNotEmpty((CharSequence)run_date_str)) {
                    run_date$1.elem = new CustomDateType(run_date_str, false);
                    nameAndType$1.update((Object)MODULE$.RUN_DATE(), (Object)new DateType((CustomDateType)run_date$1.elem));
                    return;
                }
                return;
            }
        }
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            if (value instanceof String) {
                String string = (String)value;
                if (!nameAndType$1.contains((Object)key) && StringUtils.isNotEmpty((CharSequence)string)) {
                    nameAndType$1.update((Object)key, Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> new DoubleValue(new StringOps(Predef$.MODULE$.augmentString(string)).toDouble()), (Function1 & Serializable & scala.Serializable)x$1 -> new StringType(string)));
                    return;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$replace$4(scala.collection.mutable.Map nameAndType$2, ObjectRef run_date$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = MODULE$.RUN_DATE();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                if (!nameAndType$2.contains((Object)MODULE$.RUN_DATE())) {
                    String run_date_str = value;
                    if (StringUtils.isNotEmpty((CharSequence)run_date_str)) {
                        run_date$2.elem = new CustomDateType(run_date_str, false);
                        nameAndType$2.update((Object)MODULE$.RUN_DATE(), (Object)new DateType((CustomDateType)run_date$2.elem));
                    }
                }
            } else if (!nameAndType$2.contains((Object)key) && StringUtils.isNotEmpty((CharSequence)value)) {
                if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()).isDefined()) {
                    nameAndType$2.update((Object)key, (Object)new DoubleValue(new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()));
                } else {
                    nameAndType$2.update((Object)key, (Object)new StringType(value));
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void putNameAndType$1(scala.collection.mutable.Map data, scala.collection.mutable.Map nameAndType$2, ObjectRef run_date$2) {
        if (data != null) {
            data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                VariableUtils$.$anonfun$replace$4(nameAndType$2, run_date$2, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parserVar$1(IntRef i$1, scala.collection.mutable.Map nameAndType$3, StringBuilder parseCode$1, String[] codes$1, HashSet expressionCache$1, String str) {
        MODULE$.calReg().findFirstMatchIn((CharSequence)str).foreach((Function1 & Serializable & scala.Serializable)ma -> {
            BoxedUnit boxedUnit;
            ++i$1.elem;
            String name = ma.group(1);
            String signal = ma.group(2);
            String rightValue = ma.group(3);
            if (name == null || name.trim().isEmpty()) {
                throw new LinkisCommonErrorException(20041, new java.lang.StringBuilder(23).append("[").append(str).append("] replaced var is null").toString());
            }
            String expression = name.trim();
            VariableType varType = (VariableType)nameAndType$3.get((Object)name.trim()).orNull(Predef$.MODULE$.$conforms());
            if (varType == null) {
                MODULE$.logger().warn(new java.lang.StringBuilder(73).append("Use undefined variables or use the set method: [").append(str).append("](\u4f7f\u7528\u4e86\u672a\u5b9a\u4e49\u7684\u53d8\u91cf\u6216\u8005\u4f7f\u7528\u4e86set\u65b9\u5f0f:[").append(str).append("])").toString());
                return parseCode$1.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(codes$1[i$1.elem - 1])).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(str)), Predef$.MODULE$.StringCanBuildFrom()));
            }
            String res = varType.getValue();
            if (signal != null && !signal.trim().isEmpty()) {
                if (rightValue == null || rightValue.trim().isEmpty()) {
                    throw new LinkisCommonErrorException(20042, new java.lang.StringBuilder(40).append("[").append(str).append("] expression is not right, please check").toString());
                }
                expression = new java.lang.StringBuilder(2).append(expression).append("_").append(signal.trim()).append("_").append(rightValue.trim()).toString();
                String rightToken = rightValue.trim();
                String rightRes = nameAndType$3.contains((Object)rightToken) ? ((VariableType)nameAndType$3.apply((Object)rightToken)).getValue() : rightToken;
                res = varType.calculator(signal.trim(), rightRes);
            }
            if (!expressionCache$1.contains((Object)expression)) {
                MODULE$.logger().info(new java.lang.StringBuilder(37).append("Variable expression [").append(str).append("] = ").append(res).append("(\u53d8\u91cf\u8868\u8fbe\u5f0f[").append(str).append("] = ").append(res).append(")").toString());
                boxedUnit = expressionCache$1.$plus$eq((Object)expression);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return parseCode$1.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(codes$1[i$1.elem - 1])).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(res)), Predef$.MODULE$.StringCanBuildFrom()));
        });
    }

    public static final /* synthetic */ void $anonfun$getCustomVar$1(UnanchoredRegex customRightRegex$1, UnanchoredRegex customRegex$1, scala.collection.mutable.Map nameAndValue$1, UnanchoredRegex errRegex$1, String str) {
        String string;
        Option option;
        if (Option$.MODULE$.option2Iterable(((Regex)customRightRegex$1).unapplySeq((CharSequence)str)).size() < Option$.MODULE$.option2Iterable(((Regex)customRegex$1).unapplySeq((CharSequence)str)).size()) {
            MODULE$.logger().warn(new java.lang.StringBuilder(40).append("code:").append(str).append(" is wrong custom variable format!!!").toString());
        }
        if (!(option = ((Regex)customRegex$1).unapplySeq((CharSequence)(string = str))).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            String clearStr = str.endsWith(";") ? str.substring(0, str.length() - 1) : str;
            String[] res = clearStr.split("=");
            if (res != null && res.length == 2) {
                String[] nameSet = res[0].split("@set");
                if (nameSet != null && nameSet.length == 2) {
                    String name = nameSet[1].trim();
                    nameAndValue$1.update((Object)name, (Object)res[1].trim());
                    return;
                }
                return;
            }
            if (res.length > 2) {
                throw new LinkisCommonErrorException(20044, new java.lang.StringBuilder(24).append(str).append(" var defined uncorrectly").toString());
            }
            throw new LinkisCommonErrorException(20045, new java.lang.StringBuilder(28).append("var was defined uncorrectly:").append(str).toString());
        }
        Option option2 = ((Regex)errRegex$1).unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
            MODULE$.logger().warn(new java.lang.StringBuilder(148).append("The variable definition is incorrect:").append(str).append(",if it is not used, it will not run the error, but it is recommended to use the correct specification to define").toString());
            return;
        }
    }

    private VariableUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.RUN_DATE = "run_date";
        this.RUN_TODAY_H = "run_today_h";
        this.RUN_TODAY_HOUR = "run_today_hour";
        this.codeReg = new StringOps(Predef$.MODULE$.augmentString("\\$\\{\\s*[A-Za-z][A-Za-z0-9_\\.]*\\s*[\\+\\-\\*/]?\\s*[A-Za-z0-9_\\.]*\\s*\\}")).r();
        this.calReg = new StringOps(Predef$.MODULE$.augmentString("(\\s*[A-Za-z][A-Za-z0-9_\\.]*\\s*)([\\+\\-\\*/]?)(\\s*[A-Za-z0-9_\\.]*\\s*)")).r();
    }
}

