/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.FatalException;
import org.apache.linkis.common.exception.WarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisUtils {
    private static final Logger logger = LoggerFactory.getLogger(LinkisUtils.class);

    public static <T> T tryCatch(Callable<T> tryOp, Function<Throwable, T> catchOp) {
        T result = null;
        try {
            result = tryOp.call();
        }
        catch (Throwable t) {
            if (t instanceof FatalException) {
                logger.error("Fatal error, system exit...", t);
                System.exit(((FatalException)t).getErrCode());
            }
            if (t instanceof VirtualMachineError) {
                logger.error("Fatal error, system exit...", t);
                System.exit(-1);
            }
            if (null != t.getCause() && (t.getCause() instanceof FatalException || t.getCause() instanceof VirtualMachineError)) {
                logger.error("Caused by fatal error, system exit...", t);
                System.exit(-1);
            }
            if (t instanceof Error) {
                logger.error("Throw error", t);
                throw (Error)t;
            }
            result = catchOp.apply(t);
        }
        return result;
    }

    public static void tryFinally(Runnable tryOp, Runnable finallyOp) {
        try {
            tryOp.run();
        }
        finally {
            finallyOp.run();
        }
    }

    public static <T> T tryAndWarn(Callable<T> tryOp, Logger log) {
        return (T)LinkisUtils.tryCatch(tryOp, t -> {
            if (t instanceof ErrorException) {
                ErrorException error = (ErrorException)t;
                log.error("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", new Object[]{error.getErrCode(), error.getDesc(), error});
            } else if (t instanceof WarnException) {
                WarnException warn = (WarnException)t;
                log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", new Object[]{warn.getErrCode(), warn.getDesc(), warn});
            } else {
                log.warn("", t);
            }
            return null;
        });
    }

    public static void tryAndErrorMsg(Runnable tryOp, String message, Logger log) {
        try {
            tryOp.run();
        }
        catch (WarnException t) {
            WarnException warn = t;
            log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", (Object)warn.getErrCode(), (Object)warn.getDesc());
            log.warn(message, (Throwable)warn);
        }
        catch (Exception t) {
            log.warn(message, (Throwable)t);
        }
    }

    public static <T> void tryAndWarn(Runnable tryOp, Logger log) {
        try {
            tryOp.run();
        }
        catch (Throwable error) {
            if (error instanceof WarnException) {
                WarnException warn = (WarnException)error;
                log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", new Object[]{warn.getErrCode(), warn.getDesc(), error});
            }
            log.warn("", error);
        }
    }

    public static void tryAndWarnMsg(Runnable tryOp, String message, Logger log) {
        try {
            tryOp.run();
        }
        catch (WarnException t) {
            WarnException warn = t;
            log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", (Object)warn.getErrCode(), (Object)warn.getDesc());
            log.warn(message, (Throwable)warn);
        }
        catch (Exception t) {
            log.warn(message, (Throwable)t);
        }
    }

    public static <T> T tryAndWarnMsg(Callable<T> tryOp, String message, Logger log) {
        return (T)LinkisUtils.tryCatch(tryOp, t -> {
            if (t instanceof ErrorException) {
                ErrorException error = (ErrorException)t;
                log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", (Object)error.getErrCode(), (Object)error.getDesc());
                log.warn(message, (Throwable)error);
            } else if (t instanceof WarnException) {
                WarnException warn = (WarnException)t;
                log.warn("Warning code\uff08\u8b66\u544a\u7801\uff09: {}, Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: {}.", (Object)warn.getErrCode(), (Object)warn.getDesc());
                log.warn(message, (Throwable)warn);
            } else {
                log.warn(message, t);
            }
            return null;
        });
    }

    public static String getJvmUser() {
        return System.getProperty("user.name");
    }
}

