/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

public final class LDAPUtils$
implements Logging {
    public static LDAPUtils$ MODULE$;
    private String url;
    private final String baseDN;
    private final String userNameFormat;
    private final Cache<String, String> storeUser;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LDAPUtils$();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$(this, message);
    }

    private Logger logger$lzycompute() {
        LDAPUtils$ lDAPUtils$ = this;
        synchronized (lDAPUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String url() {
        return this.url;
    }

    public void url_$eq(String x$1) {
        this.url = x$1;
    }

    public String baseDN() {
        return this.baseDN;
    }

    public String userNameFormat() {
        return this.userNameFormat;
    }

    private Cache<String, String> storeUser() {
        return this.storeUser;
    }

    public void login(String userID, String password) {
        Object object = new Object();
        try {
            String saltPwd = (String)this.storeUser().getIfPresent((Object)userID);
            Object object2 = StringUtils.isNotBlank((CharSequence)saltPwd) ? Utils$.MODULE$.tryAndWarn((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (saltPwd.equalsIgnoreCase(Hex.encodeHexString((byte[])password.getBytes(StandardCharsets.UTF_8)))) {
                    MODULE$.logger().info(new StringBuilder(33).append("user ").append(userID).append(" login success for storeUser").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
            }, this.logger()) : BoxedUnit.UNIT;
            Hashtable<String, String> env = new Hashtable<String, String>();
            String bindDN = StringUtils.isBlank((CharSequence)this.userNameFormat()) ? userID : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.userNameFormat().split("%s", -1))).mkString(userID);
            String bindPassword = password;
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", new StringBuilder(0).append(this.url()).append(this.baseDN()).toString());
            env.put("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindPassword);
            new InitialLdapContext(env, null);
            Utils$.MODULE$.tryAndWarn((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.storeUser().put((Object)userID, (Object)Hex.encodeHexString((byte[])password.getBytes(StandardCharsets.UTF_8))), this.logger());
            this.logger().info(new StringBuilder(20).append("user ").append(userID).append(" login success.").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private LDAPUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.url = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.url", "").getValue();
        if (!this.url().endsWith("/")) {
            this.url_$eq(new StringBuilder(1).append(this.url()).append("/").toString());
        }
        this.baseDN = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.baseDN", "").getValue();
        this.userNameFormat = CommonVars$.MODULE$.apply("wds.linkis.ldap.proxy.userNameFormat", "").getValue();
        this.storeUser = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(60L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, String>(){

            public void onRemoval(RemovalNotification<String, String> removalNotification) {
                LDAPUtils$.MODULE$.logger().info(new StringBuilder(23).append("store user remove key: ").append(removalNotification.getKey()).toString());
            }
        }).build();
    }
}

