/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.conf;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Configuration$
implements Logging {
    public static Configuration$ MODULE$;
    private final CommonVars<String> BDP_ENCODING;
    private final CommonVars<String> DEFAULT_DATE_PATTERN;
    private final CommonVars<String> FIELD_SPLIT;
    private final CommonVars<Object> IS_TEST_MODE;
    private final CommonVars<Object> IS_PROMETHEUS_ENABLE;
    private final boolean IS_MULTIPLE_YARN_CLUSTER;
    private final CommonVars<String> PROMETHEUS_ENDPOINT;
    private final CommonVars<String> LINKIS_HOME;
    private final CommonVars<String> GATEWAY_URL;
    private final CommonVars<String> LINKIS_WEB_VERSION;
    private final String[] REFLECT_SCAN_PACKAGE;
    private final CommonVars<String> CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME;
    private final CommonVars<String> CLOUD_CONSOLE_VARIABLE_SPRING_APPLICATION_NAME;
    private final boolean PREFER_IP_ADDRESS;
    private final CommonVars<String> GOVERNANCE_STATION_ADMIN;
    private final CommonVars<String> JOB_HISTORY_ADMIN;
    private final CommonVars<String> JOB_HISTORY_DEPARTMENT_ADMIN;
    private final String GOVERNANCE_STATION_ADMIN_TOKEN_STARTWITH;
    private final boolean VARIABLE_OPERATION_USE_NOW;
    private final CommonVars<Object> IS_VIEW_FS_ENV;
    private final CommonVars<String> ERROR_MSG_TIP;
    private final CommonVars<String> LINKIS_TOKEN;
    private final String GLOBAL_CONF_CHN_NAME;
    private final String GLOBAL_CONF_CHN_OLDNAME;
    private final String GLOBAL_CONF_CHN_EN_NAME;
    private final String GLOBAL_CONF_SYMBOL;
    private final String GLOBAL_CONF_LABEL;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Configuration$();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$(this, message);
    }

    private Logger logger$lzycompute() {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CommonVars<String> BDP_ENCODING() {
        return this.BDP_ENCODING;
    }

    public CommonVars<String> DEFAULT_DATE_PATTERN() {
        return this.DEFAULT_DATE_PATTERN;
    }

    public CommonVars<String> FIELD_SPLIT() {
        return this.FIELD_SPLIT;
    }

    public CommonVars<Object> IS_TEST_MODE() {
        return this.IS_TEST_MODE;
    }

    public CommonVars<Object> IS_PROMETHEUS_ENABLE() {
        return this.IS_PROMETHEUS_ENABLE;
    }

    public boolean IS_MULTIPLE_YARN_CLUSTER() {
        return this.IS_MULTIPLE_YARN_CLUSTER;
    }

    public CommonVars<String> PROMETHEUS_ENDPOINT() {
        return this.PROMETHEUS_ENDPOINT;
    }

    public CommonVars<String> LINKIS_HOME() {
        return this.LINKIS_HOME;
    }

    public CommonVars<String> GATEWAY_URL() {
        return this.GATEWAY_URL;
    }

    public CommonVars<String> LINKIS_WEB_VERSION() {
        return this.LINKIS_WEB_VERSION;
    }

    public String[] REFLECT_SCAN_PACKAGE() {
        return this.REFLECT_SCAN_PACKAGE;
    }

    public CommonVars<String> CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME() {
        return this.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME;
    }

    public CommonVars<String> CLOUD_CONSOLE_VARIABLE_SPRING_APPLICATION_NAME() {
        return this.CLOUD_CONSOLE_VARIABLE_SPRING_APPLICATION_NAME;
    }

    public boolean PREFER_IP_ADDRESS() {
        return this.PREFER_IP_ADDRESS;
    }

    public CommonVars<String> GOVERNANCE_STATION_ADMIN() {
        return this.GOVERNANCE_STATION_ADMIN;
    }

    public CommonVars<String> JOB_HISTORY_ADMIN() {
        return this.JOB_HISTORY_ADMIN;
    }

    public CommonVars<String> JOB_HISTORY_DEPARTMENT_ADMIN() {
        return this.JOB_HISTORY_DEPARTMENT_ADMIN;
    }

    public String GOVERNANCE_STATION_ADMIN_TOKEN_STARTWITH() {
        return this.GOVERNANCE_STATION_ADMIN_TOKEN_STARTWITH;
    }

    public boolean VARIABLE_OPERATION_USE_NOW() {
        return this.VARIABLE_OPERATION_USE_NOW;
    }

    public CommonVars<Object> IS_VIEW_FS_ENV() {
        return this.IS_VIEW_FS_ENV;
    }

    public CommonVars<String> ERROR_MSG_TIP() {
        return this.ERROR_MSG_TIP;
    }

    public CommonVars<String> LINKIS_TOKEN() {
        return this.LINKIS_TOKEN;
    }

    public String GLOBAL_CONF_CHN_NAME() {
        return this.GLOBAL_CONF_CHN_NAME;
    }

    public String GLOBAL_CONF_CHN_OLDNAME() {
        return this.GLOBAL_CONF_CHN_OLDNAME;
    }

    public String GLOBAL_CONF_CHN_EN_NAME() {
        return this.GLOBAL_CONF_CHN_EN_NAME;
    }

    public String GLOBAL_CONF_SYMBOL() {
        return this.GLOBAL_CONF_SYMBOL;
    }

    public String GLOBAL_CONF_LABEL() {
        return this.GLOBAL_CONF_LABEL;
    }

    public boolean isAdminToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        return token.toUpperCase().startsWith(this.GOVERNANCE_STATION_ADMIN_TOKEN_STARTWITH());
    }

    public String getGateWayURL() {
        String url = this.GATEWAY_URL().getValue().trim();
        String gatewayUr = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        this.logger().info(new StringBuilder(14).append("gatewayUrl is ").append(gatewayUr).toString());
        return gatewayUr;
    }

    public String getLinkisHome() {
        String home = this.LINKIS_HOME().getValue().trim();
        String linkisHome = home.endsWith("/") ? home.substring(0, home.length() - 1) : home;
        this.logger().info(new StringBuilder(14).append("linkisHome is ").append(linkisHome).toString());
        return linkisHome;
    }

    public boolean isAdmin(String username) {
        String[] adminUsers = this.GOVERNANCE_STATION_ADMIN().getHotValue().split(",");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])adminUsers)).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)username.equalsIgnoreCase(x$1)));
    }

    public boolean isNotAdmin(String username) {
        return !this.isAdmin(username);
    }

    public boolean isNotJobHistoryAdmin(String username) {
        return !this.isJobHistoryAdmin(username);
    }

    public boolean isJobHistoryAdmin(String username) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getJobHistoryAdmin())).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)username.equalsIgnoreCase(x$1)));
    }

    public boolean isDepartmentAdmin(String username) {
        String[] departmentAdminUsers = this.JOB_HISTORY_DEPARTMENT_ADMIN().getHotValue().split(",");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])departmentAdminUsers)).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)username.equalsIgnoreCase(x$1)));
    }

    public String[] getJobHistoryAdmin() {
        String[] adminUsers = this.GOVERNANCE_STATION_ADMIN().getHotValue().split(",");
        String[] historyAdminUsers = this.JOB_HISTORY_ADMIN().getHotValue().split(",");
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])adminUsers)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])historyAdminUsers)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
    }

    public String getGlobalCreator(String creator) {
        boolean bl;
        String string = creator;
        String string2 = this.GLOBAL_CONF_CHN_NAME();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = this.GLOBAL_CONF_CHN_OLDNAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                bl = true;
            } else {
                String string6 = this.GLOBAL_CONF_CHN_EN_NAME();
                String string7 = string;
                bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
            }
        }
        if (bl) {
            return this.GLOBAL_CONF_SYMBOL();
        }
        return creator;
    }

    private Configuration$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.BDP_ENCODING = CommonVars$.MODULE$.apply("wds.linkis.encoding", "utf-8");
        this.DEFAULT_DATE_PATTERN = CommonVars$.MODULE$.apply("wds.linkis.date.pattern", "yyyy-MM-dd'T'HH:mm:ssZ");
        this.FIELD_SPLIT = CommonVars$.MODULE$.apply("wds.linkis.field.split", "hadoop");
        this.IS_TEST_MODE = CommonVars$.MODULE$.apply("wds.linkis.test.mode", BoxesRunTime.boxToBoolean((boolean)false));
        this.IS_PROMETHEUS_ENABLE = CommonVars$.MODULE$.apply("wds.linkis.prometheus.enable", BoxesRunTime.boxToBoolean((boolean)false));
        this.IS_MULTIPLE_YARN_CLUSTER = BoxesRunTime.unboxToBoolean((Object)CommonVars$.MODULE$.apply("linkis.multiple.yarn.cluster", BoxesRunTime.boxToBoolean((boolean)false)).getValue());
        this.PROMETHEUS_ENDPOINT = CommonVars$.MODULE$.apply("wds.linkis.prometheus.endpoint", "/actuator/prometheus");
        this.LINKIS_HOME = CommonVars$.MODULE$.apply("wds.linkis.home", CommonVars$.MODULE$.apply("LINKIS_HOME", "/tmp").getValue());
        this.GATEWAY_URL = CommonVars$.MODULE$.apply("wds.linkis.gateway.url", "http://127.0.0.1:9001/");
        this.LINKIS_WEB_VERSION = CommonVars$.MODULE$.apply("wds.linkis.web.version", "v1");
        this.REFLECT_SCAN_PACKAGE = CommonVars$.MODULE$.apply("wds.linkis.reflect.scan.package", "org.apache.linkis,com.webank.wedatasphere").getValue().split(",");
        this.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME = CommonVars$.MODULE$.apply("wds.linkis.console.configuration.application.name", "linkis-ps-configuration");
        this.CLOUD_CONSOLE_VARIABLE_SPRING_APPLICATION_NAME = CommonVars$.MODULE$.apply("wds.linkis.console.variable.application.name", "linkis-ps-publicservice");
        this.PREFER_IP_ADDRESS = BoxesRunTime.unboxToBoolean((Object)CommonVars$.MODULE$.apply("linkis.discovery.prefer-ip-address", CommonVars$.MODULE$.apply("EUREKA_PREFER_IP", BoxesRunTime.boxToBoolean((boolean)false)).getValue()).getValue());
        this.GOVERNANCE_STATION_ADMIN = CommonVars$.MODULE$.apply("wds.linkis.governance.station.admin", "hadoop");
        this.JOB_HISTORY_ADMIN = CommonVars$.MODULE$.apply("wds.linkis.jobhistory.admin", "hadoop");
        this.JOB_HISTORY_DEPARTMENT_ADMIN = CommonVars$.MODULE$.apply("wds.linkis.jobhistory.department.admin", "hadoop");
        this.GOVERNANCE_STATION_ADMIN_TOKEN_STARTWITH = "ADMIN-";
        this.VARIABLE_OPERATION_USE_NOW = BoxesRunTime.unboxToBoolean((Object)CommonVars$.MODULE$.apply("wds.linkis.variable.operation.use.now", BoxesRunTime.boxToBoolean((boolean)true)).getValue());
        this.IS_VIEW_FS_ENV = CommonVars$.MODULE$.apply("wds.linkis.env.is.viewfs", BoxesRunTime.boxToBoolean((boolean)true));
        this.ERROR_MSG_TIP = CommonVars$.MODULE$.apply("linkis.jobhistory.error.msg.tip", "The request interface %s is abnormal. You can try to troubleshoot common problems in the knowledge base document");
        this.LINKIS_TOKEN = CommonVars$.MODULE$.apply("wds.linkis.token", "");
        this.GLOBAL_CONF_CHN_NAME = "\u5168\u5c40\u8bbe\u7f6e";
        this.GLOBAL_CONF_CHN_OLDNAME = "\u901a\u7528\u8bbe\u7f6e";
        this.GLOBAL_CONF_CHN_EN_NAME = "GlobalSettings";
        this.GLOBAL_CONF_SYMBOL = "*";
        this.GLOBAL_CONF_LABEL = "*-*,*-*";
    }
}

