/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.operator.ujes;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.job.JobStatus;
import org.apache.linkis.cli.application.exception.TransformerException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.LinkisJobStatus;
import org.apache.linkis.cli.application.interactor.job.common.ResultSet;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;
import org.apache.linkis.cli.application.operator.ujes.UJESConstants;
import org.apache.linkis.cli.application.operator.ujes.result.OpenLogResult2;
import org.apache.linkis.cli.application.operator.ujes.result.ResultSetResult2;
import org.apache.linkis.cli.application.operator.ujes.result.UJESResult;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.httpclient.dws.response.DWSResult;
import org.apache.linkis.ujes.client.request.UserAction;
import org.apache.linkis.ujes.client.response.JobInfoResult;
import org.apache.linkis.ujes.client.response.JobLogResult;
import org.apache.linkis.ujes.client.response.JobStatusResult;
import org.apache.linkis.ujes.client.response.JobSubmitResult;

public class UJESResultAdapter
implements LinkisOperResultAdapter {
    private Object result;
    private String[] resultsetArray;

    public UJESResultAdapter(Object result) {
        if (!(result instanceof DWSResult) && !(result instanceof UJESResult)) {
            throw new TransformerException("TFM0001", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TransformerException, "Input of UJESResultAdapter is not of correct type. Current type:" + result.getClass().getCanonicalName());
        }
        this.result = result;
    }

    public UJESResultAdapter(String[] resultsetArray) {
        this.resultsetArray = resultsetArray;
    }

    @Override
    public String getJobID() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobSubmitResult) {
            return ((JobSubmitResult)this.result).getTaskID();
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null && ((JobInfoResult)this.result).getRequestPersistTask().getTaskID() != null) {
            return String.valueOf(((JobInfoResult)this.result).getRequestPersistTask().getTaskID());
        }
        return null;
    }

    @Override
    public String getUser() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof UserAction) {
            return ((UserAction)this.result).getUser();
        }
        return null;
    }

    @Override
    public String getProxyUser() {
        String user = null;
        String umUser = null;
        String requestApplication = null;
        String parsedUser1 = null;
        String parsedUser2 = null;
        if (this.result instanceof JobInfoResult) {
            if (this.result != null && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().containsKey("umUser")) {
                umUser = (String)((JobInfoResult)this.result).getTask().get("umUser");
            }
            if (this.result != null && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().containsKey("requestApplicationName")) {
                requestApplication = this.parseUserOutOfExecId((String)((JobInfoResult)this.result).getTask().get("requestApplicationName"), requestApplication);
            }
            if (this.result != null && ((JobInfoResult)this.result).getData() != null && ((JobInfoResult)this.result).getData().containsKey("execId")) {
                parsedUser1 = this.parseUserOutOfExecId((String)((JobInfoResult)this.result).getData().get("execId"), requestApplication);
            }
            if (this.result != null && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().containsKey("strongerExecId")) {
                parsedUser2 = this.parseUserOutOfStrongerExecId((String)((JobInfoResult)this.result).getTask().get("strongerExecId"), requestApplication);
            }
            if (StringUtils.isNotBlank(parsedUser2)) {
                user = parsedUser2;
            } else if (StringUtils.isNotBlank(parsedUser1)) {
                user = parsedUser1;
            } else if (StringUtils.isNotBlank(umUser)) {
                user = umUser;
            }
        }
        return user;
    }

    @Override
    public JobStatus getJobStatus() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult) {
            if (this.result != null && StringUtils.isNotBlank((CharSequence)((JobInfoResult)this.result).getJobStatus())) {
                JobStatus jobStatus = this.convertStatusFromString(((JobInfoResult)this.result).getJobStatus());
                return jobStatus;
            }
        } else if (this.result instanceof JobStatusResult && this.result != null && StringUtils.isNotBlank((CharSequence)((JobInfoResult)this.result).getJobStatus())) {
            JobStatus jobStatus = this.convertStatusFromString(((JobStatusResult)this.result).getJobStatus());
            return jobStatus;
        }
        return null;
    }

    @Override
    public String getStrongerExecId() {
        if (this.result == null) {
            return null;
        }
        String execId = null;
        if (this.result instanceof JobSubmitResult) {
            execId = ((JobSubmitResult)this.result).getExecID();
        }
        if (this.result instanceof JobInfoResult && this.result != null && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().containsKey("strongerExecId")) {
            execId = (String)((JobInfoResult)this.result).getTask().get("strongerExecId");
        }
        if (CliUtils.isValidExecId(execId)) {
            return execId;
        }
        return null;
    }

    @Override
    public Float getJobProgress() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getProgress();
        }
        return null;
    }

    @Override
    public String getLogPath() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null && StringUtils.isNotBlank((CharSequence)((JobInfoResult)this.result).getRequestPersistTask().getLogPath())) {
            String logPath = ((JobInfoResult)this.result).getRequestPersistTask().getLogPath();
            return logPath;
        }
        return null;
    }

    @Override
    public String getResultLocation() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null && ((JobInfoResult)this.result).getRequestPersistTask().getResultLocation() != null && StringUtils.isNotBlank((CharSequence)((JobInfoResult)this.result).getRequestPersistTask().getResultLocation())) {
            String resultLocation = ((JobInfoResult)this.result).getRequestPersistTask().getResultLocation();
            return resultLocation;
        }
        return null;
    }

    @Override
    public String[] getResultSetPaths() {
        return this.resultsetArray;
    }

    @Override
    public Integer getErrCode() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().get("errCode") != null && ((JobInfoResult)this.result).getTask().get("errCode") instanceof Integer) {
            Integer errCode = (Integer)((JobInfoResult)this.result).getTask().get("errCode");
            return errCode;
        }
        return null;
    }

    @Override
    public String getErrDesc() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().get("errDesc") != null && ((JobInfoResult)this.result).getTask().get("errDesc") instanceof String) {
            String errDesc = (String)((JobInfoResult)this.result).getTask().get("errDesc");
            return errDesc;
        }
        return null;
    }

    @Override
    public String getLog() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobLogResult && ((JobLogResult)this.result).getLog() != null) {
            return (String)((JobLogResult)this.result).getLog().get(UJESConstants.IDX_FOR_LOG_TYPE_ALL);
        }
        if (this.result instanceof OpenLogResult2 && ((OpenLogResult2)this.result).getResult() != null && ((OpenLogResult2)this.result).getResult().getLog() != null) {
            String allLog = ((OpenLogResult2)this.result).getResult().getLog()[UJESConstants.IDX_FOR_LOG_TYPE_ALL];
            Integer fromLine = ((OpenLogResult2)this.result).getFromLine();
            return StringUtils.substring((String)allLog, (int)this.getFirstIndexSkippingLines(allLog, fromLine == null ? 0 : fromLine));
        }
        return null;
    }

    @Override
    public Integer getNextLogLine() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobLogResult) {
            return ((JobLogResult)this.result).getFromLine();
        }
        if (this.result instanceof OpenLogResult2 && ((OpenLogResult2)this.result).getResult() != null && ((OpenLogResult2)this.result).getResult().getLog() != null) {
            return this.getNumOfLines(((OpenLogResult2)this.result).getResult().getLog()[UJESConstants.IDX_FOR_LOG_TYPE_ALL]);
        }
        return null;
    }

    @Override
    public Boolean hasNextLogLine() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobLogResult) {
            return true;
        }
        if (this.result instanceof OpenLogResult2) {
            return false;
        }
        return null;
    }

    @Override
    public ResultSet getResultContent() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof ResultSetResult2 && ((ResultSetResult2)this.result).getResultSetResult() != null && ((ResultSetResult2)this.result).getResultSetResult().getFileContent() != null && ((ResultSetResult2)this.result).getResultSetResult().getMetadata() != null) {
            ResultSet ret = new ResultSet();
            ret.setResultsetIdx(((ResultSetResult2)this.result).getIdxResultSet());
            if (((ResultSetResult2)this.result).getResultSetResult().getMetadata() != null) {
                ret.setResultMeta(this.convertResultMeta(((ResultSetResult2)this.result).getResultSetResult().getMetadata()));
            }
            if (((ResultSetResult2)this.result).getResultSetResult().getFileContent() != null) {
                ret.setContent(this.convertRawResultContent(((ResultSetResult2)this.result).getResultSetResult().getFileContent()));
            }
            return ret;
        }
        return null;
    }

    @Override
    public Boolean resultHasNextPage() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof ResultSetResult2) {
            if (((ResultSetResult2)this.result).getResultSetResult() == null || ((ResultSetResult2)this.result).getResultSetResult().getFileContent() == null || ((ResultSetResult2)this.result).getResultSetResult().getFileContent() instanceof List && ((List)((ResultSetResult2)this.result).getResultSetResult().getFileContent()).size() == 0 || ((ResultSetResult2)this.result).getResultSetResult().getTotalLine() == 0) {
                return false;
            }
            return true;
        }
        return null;
    }

    private String parseUserOutOfStrongerExecId(String strongerExecId, String requestApp) {
        int idx = StringUtils.indexOf((CharSequence)strongerExecId, (CharSequence)requestApp) + StringUtils.length((CharSequence)requestApp) + 1;
        int idx2 = StringUtils.indexOf((CharSequence)strongerExecId, (int)95, (int)idx);
        return StringUtils.substring((String)strongerExecId, (int)idx, (int)idx2);
    }

    private String parseUserOutOfExecId(String strongerExecId, String requestApp) {
        int idx = StringUtils.indexOf((CharSequence)strongerExecId, (CharSequence)requestApp) + StringUtils.length((CharSequence)requestApp) + 1;
        int idx2 = StringUtils.indexOf((CharSequence)strongerExecId, (int)95, (int)idx);
        return StringUtils.substring((String)strongerExecId, (int)idx, (int)idx2);
    }

    private JobStatus convertStatusFromString(String status) {
        return LinkisJobStatus.convertFromJobStatusString(status);
    }

    private List<LinkedHashMap<String, String>> convertResultMeta(Object rawMetaData) {
        List ret;
        if (rawMetaData == null) {
            return null;
        }
        if (rawMetaData instanceof String && StringUtils.equalsIgnoreCase((CharSequence)((String)rawMetaData), (CharSequence)"NULL")) {
            return null;
        }
        try {
            ret = (List)rawMetaData;
        }
        catch (Exception e) {
            throw new TransformerException("TFM0005", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TransformerException, "Failed to convert ResultSetMeta", e);
        }
        return ret;
    }

    private List<List<String>> convertRawResultContent(Object rawContent) {
        List ret;
        if (rawContent == null) {
            return null;
        }
        try {
            ret = (List)rawContent;
        }
        catch (ClassCastException e) {
            throw new TransformerException("TFM0007", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.TransformerException, "Failed to convert ResultSet", e);
        }
        return ret;
    }

    @Override
    public String getInstance() {
        if (this.result == null) {
            return null;
        }
        return null;
    }

    @Override
    public String getUmUser() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getUmUser();
        }
        return null;
    }

    @Override
    public String getSimpleExecId() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getExecId();
        }
        return null;
    }

    @Override
    public String getExecutionCode() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getExecutionCode();
        }
        return null;
    }

    @Override
    public String getEngineType() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().get("engineType") != null) {
            return (String)((JobInfoResult)this.result).getTask().get("engineType");
        }
        return null;
    }

    @Override
    public String getRunType() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getRunType();
        }
        return null;
    }

    @Override
    public Long getCostTime() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getTask() != null && ((JobInfoResult)this.result).getTask().get("costTime") != null) {
            return (long)((Integer)((JobInfoResult)this.result).getTask().get("costTime"));
        }
        return null;
    }

    @Override
    public Date getCreatedTime() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getCreatedTime();
        }
        return null;
    }

    @Override
    public Date getUpdatedTime() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getUpdatedTime();
        }
        return null;
    }

    @Override
    public Date getEngineStartTime() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getEngineStartTime();
        }
        return null;
    }

    @Override
    public String getExecuteApplicationName() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getExecuteApplicationName();
        }
        return null;
    }

    @Override
    public String getRequestApplicationName() {
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof JobInfoResult && ((JobInfoResult)this.result).getRequestPersistTask() != null) {
            return ((JobInfoResult)this.result).getRequestPersistTask().getRequestApplicationName();
        }
        return null;
    }

    private int getNumOfLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private int getFirstIndexSkippingLines(String str, Integer lines) {
        if (str == null || str.length() == 0 || lines < 0) {
            return -1;
        }
        if (lines == 0) {
            return 0;
        }
        int curLineIdx = 0;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++curLineIdx;
                if (pos + 1 < len && str.charAt(pos + 1) == '\n') {
                    ++pos;
                }
            } else {
                if (c != '\n') continue;
                ++curLineIdx;
            }
            if (curLineIdx < lines) continue;
            return pos + 1;
        }
        return -1;
    }
}

