/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.linkis.cli.application.exception.PropsException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.properties.ClientProperties;
import org.apache.linkis.cli.application.interactor.properties.reader.PropertiesReader;

public class PropertiesLoader {
    Map<String, PropertiesReader> readersMap = new HashMap<String, PropertiesReader>();

    public PropertiesLoader setPropertiesReaders(PropertiesReader[] readers) {
        this.readersMap = new HashMap<String, PropertiesReader>();
        for (PropertiesReader reader : readers) {
            this.readersMap.put(reader.getPropsId(), reader);
        }
        return this;
    }

    public PropertiesLoader addPropertiesReader(PropertiesReader reader) {
        if (reader != null) {
            this.readersMap.put(reader.getPropsId(), reader);
        }
        return this;
    }

    public PropertiesLoader addPropertiesReaders(PropertiesReader[] readers) {
        if (readers != null && readers.length > 0) {
            for (PropertiesReader reader : readers) {
                this.readersMap.put(reader.getPropsId(), reader);
            }
        }
        return this;
    }

    public void removePropertiesReader(String identifier) {
        this.readersMap.remove(identifier);
    }

    public ClientProperties[] loadProperties() {
        this.checkInit();
        ArrayList<ClientProperties> propsList = new ArrayList<ClientProperties>();
        for (Map.Entry<String, PropertiesReader> entry : this.readersMap.entrySet()) {
            PropertiesReader readerTmp = entry.getValue();
            Properties props = readerTmp.getProperties();
            ClientProperties clientProperties = new ClientProperties();
            clientProperties.putAll(props);
            clientProperties.setPropsId(readerTmp.getPropsId());
            clientProperties.setPropertiesSourcePath(readerTmp.getPropsPath());
            propsList.add(clientProperties);
        }
        return propsList.toArray(new ClientProperties[propsList.size()]);
    }

    public void checkInit() {
        if (this.readersMap == null || this.readersMap.size() == 0) {
            throw new PropsException("PRP0003", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PropsLoaderInitErr, "properties loader is not inited because it contains no reader");
        }
    }
}

