/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.service.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.ResourceHelper;
import org.apache.linkis.bml.common.ResourceHelperFactory;
import org.apache.linkis.bml.common.UpdateResourceException;
import org.apache.linkis.bml.dao.ResourceDao;
import org.apache.linkis.bml.dao.TaskDao;
import org.apache.linkis.bml.dao.VersionDao;
import org.apache.linkis.bml.entity.Resource;
import org.apache.linkis.bml.entity.ResourceTask;
import org.apache.linkis.bml.entity.ResourceVersion;
import org.apache.linkis.bml.entity.Version;
import org.apache.linkis.bml.service.ResourceService;
import org.apache.linkis.bml.service.TaskService;
import org.apache.linkis.bml.service.VersionService;
import org.apache.linkis.bml.service.impl.ResourceServiceImpl;
import org.apache.linkis.bml.threading.TaskState;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskServiceImpl
implements TaskService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private VersionDao versionDao;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResourceTask createUploadTask(List<MultipartFile> files, String user, Map<String, Object> properties) throws Exception {
        String resourceId = UUID.randomUUID().toString();
        ResourceTask resourceTask = ResourceTask.createUploadTask(resourceId, user, properties);
        this.taskDao.insert(resourceTask);
        LOGGER.info("Upload task information was successfully saved (\u6210\u529f\u4fdd\u5b58\u4e0a\u4f20\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        this.taskDao.updateState(resourceTask.getId(), TaskState.RUNNING.getValue(), new Date());
        LOGGER.info("Successful update task (\u6210\u529f\u66f4\u65b0\u4efb\u52a1 ) taskId:{}-resourceId:{} status is  {} .", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.RUNNING.getValue()});
        properties.put("resourceId", resourceTask.getResourceId());
        try {
            ResourceServiceImpl.UploadResult result = this.resourceService.upload(files, user, properties).get(0);
            if (result.isSuccess()) {
                this.taskDao.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
                LOGGER.info("Upload resource successfully. Update task(\u4e0a\u4f20\u8d44\u6e90\u6210\u529f.\u66f4\u65b0\u4efb\u52a1) taskId:{}-resourceId:{} status is   {} .", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
            } else {
                this.taskDao.updateState(resourceTask.getId(), TaskState.FAILED.getValue(), new Date());
                LOGGER.info("Upload resource failed. Update task (\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25.\u66f4\u65b0\u4efb\u52a1) taskId:{}-resourceId:{}  status is   {} .", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue()});
            }
        }
        catch (Exception e) {
            this.taskDao.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
            LOGGER.error("Upload resource successfully. Update task (\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25.\u66f4\u65b0\u4efb\u52a1) taskId:{}-resourceId:{}  status is   {} .", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue(), e});
            throw e;
        }
        return resourceTask;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResourceTask createUpdateTask(String resourceId, String user, MultipartFile file, Map<String, Object> properties) throws Exception {
        String resourceIdLock = resourceId.intern();
        String system = this.resourceDao.getResource(resourceId).getSystem();
        String lastVersion = this.getResourceLastVersion(resourceId);
        String newVersion = this.generateNewVersion(lastVersion);
        ResourceTask resourceTask = ResourceTask.createUpdateTask(resourceId, newVersion, user, system, properties);
        try {
            this.taskDao.insert(resourceTask);
        }
        catch (Exception e) {
            UpdateResourceException updateResourceException = new UpdateResourceException();
            updateResourceException.initCause(e);
            throw updateResourceException;
        }
        LOGGER.info("Upload task information was successfully saved(\u6210\u529f\u4fdd\u5b58\u4e0a\u4f20\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        this.taskDao.updateState(resourceTask.getId(), TaskState.RUNNING.getValue(), new Date());
        LOGGER.info("Successful update task (\u6210\u529f\u66f4\u65b0\u4efb\u52a1 ) taskId:{}-resourceId:{} status is  {} .", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.RUNNING.getValue()});
        properties.put("newVersion", resourceTask.getVersion());
        try {
            this.versionService.updateVersion(resourceTask.getResourceId(), user, file, properties);
            this.taskDao.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
            LOGGER.info("Upload resource successfully. Update task (\u4e0a\u4f20\u8d44\u6e90\u6210\u529f.\u66f4\u65b0\u4efb\u52a1) taskId:{}-resourceId:{}  status is   {}.", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
        }
        catch (Exception e) {
            this.taskDao.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
            LOGGER.error("Upload resource failed . Update task (\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25.\u66f4\u65b0\u4efb\u52a1) taskId:{}-resourceId:{}  status is   {}.", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue(), e});
            throw e;
        }
        return resourceTask;
    }

    @Override
    public ResourceTask createDownloadTask(String resourceId, String version, String user, String clientIp) {
        String system = this.resourceDao.getResource(resourceId).getSystem();
        ResourceTask resourceTask = ResourceTask.createDownloadTask(resourceId, version, user, system, clientIp);
        this.taskDao.insert(resourceTask);
        LOGGER.info("The download task information was successfully saved (\u6210\u529f\u4fdd\u5b58\u4e0b\u8f7d\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        return resourceTask;
    }

    @Override
    public void updateState(long taskId, String state, Date updateTime) {
        this.taskDao.updateState(taskId, state, updateTime);
    }

    @Override
    public void updateState2Failed(long taskId, String state, Date updateTime, String errMsg) {
        this.taskDao.updateState2Failed(taskId, state, updateTime, errMsg);
    }

    @Override
    public ResourceTask createDeleteVersionTask(String resourceId, String version, String user, String clientIp) {
        String system = this.resourceDao.getResource(resourceId).getSystem();
        ResourceTask resourceTask = ResourceTask.createDeleteVersionTask(resourceId, version, user, system, clientIp);
        this.taskDao.insert(resourceTask);
        LOGGER.info("The deleted resource version task information was successfully saved (\u6210\u529f\u4fdd\u5b58\u5220\u9664\u8d44\u6e90\u7248\u672c\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        return resourceTask;
    }

    @Override
    public ResourceTask createDeleteResourceTask(String resourceId, String user, String clientIp) {
        String system = this.resourceDao.getResource(resourceId).getSystem();
        List<Version> versions = this.versionDao.getVersions(resourceId);
        StringBuilder extraParams = new StringBuilder();
        extraParams.append("delete resourceId:").append(resourceId);
        extraParams.append(", and delete versions is :");
        String delVersions = null;
        if (CollectionUtils.isNotEmpty(versions)) {
            delVersions = versions.stream().map(Version::getVersion).collect(Collectors.joining(","));
        }
        extraParams.append(delVersions);
        ResourceTask resourceTask = ResourceTask.createDeleteResourceTask(resourceId, user, system, clientIp, extraParams.toString());
        this.taskDao.insert(resourceTask);
        LOGGER.info("The download task information was successfully saved (\u6210\u529f\u4fdd\u5b58\u4e0b\u8f7d\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        return resourceTask;
    }

    @Override
    public ResourceTask createDeleteResourcesTask(List<String> resourceIds, String user, String clientIp) {
        String system = this.resourceDao.getResource(resourceIds.get(0)).getSystem();
        StringBuilder extraParams = new StringBuilder();
        for (String resourceId : resourceIds) {
            extraParams.append("delete resourceId:").append(resourceId);
            extraParams.append(", and delete versions is :");
            String delVersions = null;
            List<Version> versions = this.versionDao.getVersions(resourceId);
            if (CollectionUtils.isNotEmpty(versions)) {
                delVersions = versions.stream().map(Version::getVersion).collect(Collectors.joining(","));
            }
            extraParams.append(delVersions);
            extraParams.append(System.lineSeparator());
        }
        ResourceTask resourceTask = ResourceTask.createDeleteResourcesTask(user, system, clientIp, extraParams.toString());
        this.taskDao.insert(resourceTask);
        LOGGER.info("The download task information was successfully saved (\u6210\u529f\u4fdd\u5b58\u4e0b\u8f7d\u4efb\u52a1\u4fe1\u606f).taskId:{},resourceTask:{}", (Object)resourceTask.getId(), (Object)resourceTask.toString());
        return resourceTask;
    }

    @Override
    public ResourceTask createRollbackVersionTask(String resourceId, String version, String user, Map<String, Object> properties) throws Exception {
        LOGGER.info("begin to rollback version,resourceId:{}, version:{}", (Object)resourceId, (Object)version);
        String lastVersion = this.getResourceLastVersion(resourceId);
        String newVersion = this.generateNewVersion(lastVersion);
        String firstVersionPath = this.versionDao.getResourcePath(resourceId);
        String dest = firstVersionPath + "_" + newVersion;
        String src = version.equals("v000001") ? firstVersionPath : firstVersionPath + "_" + version;
        FileSystem fs = null;
        ResourceTask resourceTask = ResourceTask.createRollbackVersionTask(resourceId, newVersion, user, null, properties);
        try {
            this.taskDao.insert(resourceTask);
            FsPath srcPath = new FsPath(src);
            FsPath destPath = new FsPath(dest);
            fs = (FileSystem)FSFactory.getFsByProxyUser((FsPath)destPath, (String)user);
            fs.init(null);
            fs.copyFile(srcPath, destPath);
            ResourceVersion oldVersion = this.versionDao.findResourceVersion(resourceId, version);
            ResourceVersion insertVersion = ResourceVersion.copyFromOldResourceVersion(oldVersion);
            insertVersion.setResource(dest);
            insertVersion.setVersion(newVersion);
            insertVersion.setStartTime(new Date());
            insertVersion.setEndTime(new Date());
            this.versionDao.insertNewVersion(insertVersion);
            this.taskDao.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
        }
        catch (Exception e) {
            try {
                this.taskDao.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
        LOGGER.info("end to rollback version,resourceId:{}, version:{}", (Object)resourceId, (Object)version);
        return resourceTask;
    }

    @Override
    @Transactional
    public ResourceTask createCopyResourceTask(String resourceId, String anotherUser, Map<String, Object> properties) throws Exception {
        List<ResourceVersion> resourceVersions = this.versionDao.getResourceVersionsByResourceId(resourceId);
        String newResourceId = UUID.randomUUID().toString();
        ResourceHelper resourceHelper = ResourceHelperFactory.getResourceHelper();
        String firstPath = resourceHelper.generatePath(anotherUser, newResourceId, properties);
        FsPath firstDestPath = new FsPath(firstPath);
        FileSystem hadoopFs = (FileSystem)FSFactory.getFsByProxyUser((FsPath)firstDestPath, (String)((String)StorageConfiguration.HDFS_ROOT_USER().getValue()));
        FileSystem anotherUserFs = (FileSystem)FSFactory.getFsByProxyUser((FsPath)firstDestPath, (String)anotherUser);
        try {
            hadoopFs.init(null);
            anotherUserFs.init(null);
            if (!anotherUserFs.exists(firstDestPath.getParent())) {
                anotherUserFs.mkdirs(firstDestPath.getParent());
            }
        }
        catch (IOException e) {
            LOGGER.error("failed to get filesystem:", (Throwable)e);
        }
        ResourceTask resourceTask = ResourceTask.createCopyResourceTask(newResourceId, anotherUser, null, properties);
        this.taskDao.insert(resourceTask);
        for (ResourceVersion resourceVersion : resourceVersions) {
            try {
                FsPath srcPath = new FsPath(resourceVersion.getResource());
                FsPath destPath = null;
                if (!resourceVersion.getVersion().equals("v000001")) {
                    destPath = new FsPath(firstPath + "_" + resourceVersion.getVersion());
                } else {
                    destPath = new FsPath(firstPath);
                    Resource insertResource = Resource.createNewResource(newResourceId, anotherUser, newResourceId, properties);
                    this.resourceDao.uploadResource(insertResource);
                }
                hadoopFs.copyFile(srcPath, destPath);
                hadoopFs.setOwner(destPath, anotherUser);
                ResourceVersion insertVersion = ResourceVersion.copyFromOldResourceVersion(resourceVersion);
                insertVersion.setResource(destPath.getSchemaPath());
                insertVersion.setStartTime(new Date());
                insertVersion.setEndTime(new Date());
                insertVersion.setResourceId(newResourceId);
                this.versionDao.insertNewVersion(insertVersion);
            }
            catch (Exception e) {
                this.taskDao.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
                IOUtils.closeQuietly((Closeable)anotherUserFs);
                IOUtils.closeQuietly((Closeable)hadoopFs);
                throw e;
            }
        }
        this.taskDao.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
        IOUtils.closeQuietly((Closeable)anotherUserFs);
        IOUtils.closeQuietly((Closeable)hadoopFs);
        return resourceTask;
    }

    private String getResourceLastVersion(String resourceId) {
        String lastVersion = "";
        if (StringUtils.isNotBlank((CharSequence)resourceId)) {
            lastVersion = this.versionDao.getNewestVersion(resourceId);
        }
        return lastVersion;
    }

    private String generateNewVersion(String version) {
        int next = 1;
        if (StringUtils.isNotBlank((CharSequence)version)) {
            next = Integer.parseInt(version.substring(1, version.length())) + 1;
        }
        return "v" + String.format("%06d", next);
    }
}

