/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.service.impl;

import java.util.Date;
import java.util.List;
import org.apache.linkis.bml.dao.BmlProjectDao;
import org.apache.linkis.bml.entity.BmlProject;
import org.apache.linkis.bml.service.BmlProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BmlProjectServiceImpl
implements BmlProjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BmlProjectServiceImpl.class);
    public static final Integer DEFAULT_EDIT_PRIV = 7;
    public static final Integer DEFAULT_ACCESS_PRIV = 5;
    public static final Integer DEFAULT_ADMIN_PRIV = 8;
    @Autowired
    private BmlProjectDao bmlProjectDao;

    @Override
    public int createBmlProject(String projectName, String creator, List<String> editUsers, List<String> accessUsers) {
        BmlProject bmlProject1 = this.bmlProjectDao.getBmlProject(projectName);
        if (bmlProject1 != null) {
            return bmlProject1.getId();
        }
        Date createTime = new Date(System.currentTimeMillis());
        BmlProject bmlProject = new BmlProject();
        bmlProject.setName(projectName);
        bmlProject.setCreator(creator);
        bmlProject.setCreateTime(createTime);
        bmlProject.setDescription(creator + " \u5728bml\u521b\u5efa\u7684\u5de5\u7a0b ");
        bmlProject.setEnabled(1);
        bmlProject.setSystem("dss");
        this.bmlProjectDao.createNewProject(bmlProject);
        if (!editUsers.contains(creator)) {
            editUsers.add(creator);
        }
        if (editUsers.size() > 0) {
            this.setProjectEditPriv(bmlProject.getName(), editUsers);
        }
        if (accessUsers.size() > 0) {
            this.setProjectAccessPriv(bmlProject.getName(), accessUsers);
        }
        return bmlProject.getId();
    }

    @Override
    public boolean checkEditPriv(String projectName, String username) {
        try {
            Integer priv = this.bmlProjectDao.getPrivInProject(projectName, username);
            return priv >= DEFAULT_EDIT_PRIV;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public boolean checkAccessPriv(String projectName, String username) {
        try {
            Integer priv = this.bmlProjectDao.getPrivInProject(projectName, username);
            return priv >= DEFAULT_ACCESS_PRIV;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void setProjectEditPriv(String projectName, List<String> editUsers) {
        BmlProject bmlProject = this.bmlProjectDao.getBmlProject(projectName);
        String creator = bmlProject.getCreator();
        Date createTime = new Date(System.currentTimeMillis());
        this.bmlProjectDao.setProjectPriv(bmlProject.getId(), editUsers, DEFAULT_EDIT_PRIV, creator, createTime);
    }

    @Override
    public void addProjectEditPriv(String projectName, List<String> editUsers) {
    }

    @Override
    public void deleteProjectEditPriv(String projectName, List<String> editUsers) {
    }

    @Override
    public void setProjectAccessPriv(String projectName, List<String> accessUsers) {
        BmlProject bmlProject = this.bmlProjectDao.getBmlProject(projectName);
        String creator = bmlProject.getCreator();
        Date createTime = new Date(System.currentTimeMillis());
        this.bmlProjectDao.setProjectPriv(bmlProject.getId(), accessUsers, DEFAULT_ACCESS_PRIV, creator, createTime);
    }

    @Override
    public void addProjectAccessPriv(String projectName, List<String> accessUsers) {
    }

    @Override
    public void deleteProjectAccessPriv(String projectName, List<String> accessUsers) {
    }

    @Override
    public String getProjectNameByResourceId(String resourceId) {
        return this.bmlProjectDao.getProjectNameByResourceId(resourceId);
    }

    @Override
    public void addProjectResource(String resourceId, String projectName) {
        BmlProject bmlProject = this.bmlProjectDao.getBmlProject(projectName);
        if (bmlProject != null) {
            this.bmlProjectDao.addProjectResource(bmlProject.getId(), resourceId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void attach(String projectName, String resourceId) {
        Integer projectId = this.bmlProjectDao.getProjectIdByName(projectName);
        Integer cnt = this.bmlProjectDao.checkIfExists(projectId, resourceId);
        if (cnt > 0) {
            return;
        }
        this.bmlProjectDao.attachResourceAndProject(projectId, resourceId);
    }

    @Override
    public void updateProjectUsers(String username, String projectName, List<String> editUsers, List<String> accessUsers) {
        Integer projectId = this.bmlProjectDao.getProjectIdByName(projectName);
        if (projectId == null) {
            LOGGER.error("{} does not exist", (Object)projectName);
        } else {
            Date updateTime = new Date(System.currentTimeMillis());
            this.bmlProjectDao.deleteAllPriv(projectId);
            if (editUsers.size() > 0) {
                this.bmlProjectDao.setProjectPriv(projectId, editUsers, DEFAULT_EDIT_PRIV, username, updateTime);
            }
            if (accessUsers.size() > 0) {
                this.bmlProjectDao.setProjectPriv(projectId, accessUsers, DEFAULT_ACCESS_PRIV, username, updateTime);
            }
        }
    }
}

