/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.BmlPermissionDeniedException;
import org.apache.linkis.bml.common.BmlQueryFailException;
import org.apache.linkis.bml.common.BmlResourceExpiredException;
import org.apache.linkis.bml.common.BmlServerParaErrorException;
import org.apache.linkis.bml.entity.DownloadModel;
import org.apache.linkis.bml.entity.Resource;
import org.apache.linkis.bml.entity.ResourceTask;
import org.apache.linkis.bml.entity.ResourceVersion;
import org.apache.linkis.bml.entity.Version;
import org.apache.linkis.bml.errorcode.BmlServerErrorCodeSummary;
import org.apache.linkis.bml.restful.RestfulUtils;
import org.apache.linkis.bml.service.BmlService;
import org.apache.linkis.bml.service.DownloadService;
import org.apache.linkis.bml.service.ResourceService;
import org.apache.linkis.bml.service.TaskService;
import org.apache.linkis.bml.service.VersionService;
import org.apache.linkis.bml.threading.TaskState;
import org.apache.linkis.bml.util.HttpRequestHelper;
import org.apache.linkis.bml.vo.ResourceBasicVO;
import org.apache.linkis.bml.vo.ResourceVO;
import org.apache.linkis.bml.vo.ResourceVersionsVO;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"bml(bigdata material library) opreation"})
@RequestMapping(path={"/bml"})
@RestController
public class BmlRestfulApi {
    @Autowired
    private BmlService bmlService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private TaskService taskService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String URL_PREFIX = "/bml/";

    @ApiOperation(value="getVersions", notes="get resource versions info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", dataType="String"), @ApiImplicitParam(name="currentPage", dataType="String"), @ApiImplicitParam(name="pageSize", required=false, dataType="String", value="page size")})
    @RequestMapping(path={"getVersions"}, method={RequestMethod.GET})
    public Message getVersions(@RequestParam(value="resourceId", required=false) String resourceId, @RequestParam(value="currentPage", required=false) String currentPage, @RequestParam(value="pageSize", required=false) String pageSize, HttpServletRequest request) throws ErrorException {
        String user = RestfulUtils.getUserName(request);
        if (StringUtils.isEmpty((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            this.logger.error("ResourceId {} provided by user {} is illegal (\u7528\u6237{} \u63d0\u4f9b\u7684resourceId {} is illegal)", new Object[]{resourceId, user, user, resourceId});
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.SUBMITTED_INVALID.getErrorDesc());
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getVersions,resourceId:" + resourceId));
        Integer current = 0;
        Integer size = 0;
        current = StringUtils.isEmpty((CharSequence)currentPage) || !StringUtils.isNumeric((CharSequence)currentPage) ? Integer.valueOf(1) : Integer.valueOf(currentPage);
        size = StringUtils.isEmpty((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageSize) ? Integer.valueOf(10) : Integer.valueOf(pageSize);
        Message message = null;
        try {
            this.logger.info("User {} starts getting information about all versions of {} (\u7528\u6237 {} \u5f00\u59cb\u83b7\u53d6 {} \u7684\u6240\u6709\u7248\u672c\u4fe1\u606f)", new Object[]{user, resourceId, user, resourceId});
            List<Version> versionList = this.versionService.selectVersionByPage(current, size, resourceId);
            if (versionList.size() > 0) {
                message = Message.ok((String)"Version information obtained successfully (\u6210\u529f\u83b7\u53d6\u7248\u672c\u4fe1\u606f)");
                message.setMethod("/bml/getVersions");
                message.setStatus(0);
                ResourceVersionsVO resourceVersionsVO = new ResourceVersionsVO();
                resourceVersionsVO.setVersions(versionList);
                resourceVersionsVO.setResourceId(resourceId);
                resourceVersionsVO.setUser(user);
                message.data("ResourceVersions", (Object)resourceVersionsVO);
            } else {
                this.logger.warn("User {} fetch resource {} no error, but fetch version length 0 (user {} \u83b7\u53d6\u8d44\u6e90{}\u672a\u62a5\u9519\uff0c\u4f46\u662f\u83b7\u53d6\u5230\u7684version\u957f\u5ea6\u4e3a0)", new Object[]{user, resourceId, user, resourceId});
                message = Message.error((String)"Failed to get version information correctly(\u672a\u80fd\u6b63\u786e\u83b7\u53d6\u5230\u7248\u672c\u4fe1\u606f)");
                message.setMethod("/bml/getVersions");
                message.setStatus(2);
            }
            this.logger.info("User {} ends getting all version information for {} (\u7528\u6237 {} \u7ed3\u675f\u83b7\u53d6 {} \u7684\u6240\u6709\u7248\u672c\u4fe1\u606f)", new Object[]{user, resourceId, user, resourceId});
        }
        catch (Exception e) {
            this.logger.error("User {} Failed to get version information of the ResourceId {} resource(user {} \u83b7\u53d6resourceId {} \u8d44\u6e90\u7684\u7248\u672c\u4fe1\u606f\u5931\u8d25)", new Object[]{user, resourceId, user, resourceId, e});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.QUERY_VERSION_FAILED.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="getResources", notes="get resources info list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="system", required=false, dataType="String", value="system"), @ApiImplicitParam(name="currentPage", dataType="String"), @ApiImplicitParam(name="pageSize", required=false, dataType="String", value="page size")})
    @RequestMapping(path={"getResources"}, method={RequestMethod.GET})
    public Message getResources(@RequestParam(value="system", required=false) String system, @RequestParam(value="currentPage", required=false) String currentPage, @RequestParam(value="pageSize", required=false) String pageSize, HttpServletRequest request, HttpServletResponse response) throws ErrorException {
        String user = RestfulUtils.getUserName(request);
        if (StringUtils.isEmpty((CharSequence)system)) {
            system = "WTSS";
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getResources,system:" + system));
        Integer current = 0;
        Integer size = 0;
        current = StringUtils.isEmpty((CharSequence)currentPage) || !StringUtils.isNumeric((CharSequence)currentPage) ? Integer.valueOf(1) : Integer.valueOf(currentPage);
        size = StringUtils.isEmpty((CharSequence)pageSize) || !StringUtils.isNumeric((CharSequence)pageSize) ? Integer.valueOf(10) : Integer.valueOf(pageSize);
        Message message = null;
        try {
            this.logger.info("User {} starts fetching all the resources of the system {}(\u7528\u6237 {} \u5f00\u59cb\u83b7\u53d6\u7cfb\u7edf {} \u7684\u6240\u6709\u8d44\u6e90)", new Object[]{user, system, user, system});
            List<ResourceVersion> resourceVersionPageInfoList = this.versionService.selectResourcesViaSystemByPage(current, size, system, user);
            if (resourceVersionPageInfoList.size() > 0) {
                message = Message.ok((String)("Get all your resources in system " + system + " successfully(\u83b7\u53d6\u60a8\u5728\u7cfb\u7edf" + system + "\u4e2d\u6240\u6709\u8d44\u6e90\u6210\u529f)"));
                message.setStatus(0);
                message.setMethod("/bml/getResources");
                ArrayList<ResourceVO> resourceVOList = new ArrayList<ResourceVO>();
                for (ResourceVersion resourceVersion : resourceVersionPageInfoList) {
                    ResourceVO resourceVO = new ResourceVO();
                    resourceVO.setResource(resourceVersion.getResource());
                    resourceVO.setUser(user);
                    resourceVO.setResourceId(resourceVersion.getResourceId());
                    resourceVO.setVersion(resourceVersion.getVersion());
                    resourceVOList.add(resourceVO);
                }
                message.data("Resources", resourceVOList);
            } else {
                this.logger.warn("User {} gets system {} resource size of 0(\u7528\u6237 {} \u83b7\u53d6\u7cfb\u7edf {} \u8d44\u6e90\u7684size\u4e3a0)", new Object[]{user, system, user, system});
                message = Message.error((String)"Failed to obtain all resource information(\u672a\u80fd\u6210\u529f\u83b7\u53d6\u5230\u6240\u6709\u8d44\u6e90\u4fe1\u606f)");
                message.setStatus(2);
                message.setMethod("/bml/getResources");
            }
            this.logger.info("User {} ends fetching all resources for system {}(\u7528\u6237 {} \u7ed3\u675f\u83b7\u53d6\u7cfb\u7edf {} \u7684\u6240\u6709\u8d44\u6e90)", new Object[]{user, system, user, system});
        }
        catch (Exception e) {
            this.logger.error("User {} failed to obtain all resources of the system {}(\u7528\u6237 {} \u83b7\u53d6\u7cfb\u7edf {} \u6240\u6709\u8d44\u6e90\u5931\u8d25).", new Object[]{user, system, user, system, e});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.FAILED_ALL_INFORMATION.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="deleteVersion", notes="delete version", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"deleteVersion"}, method={RequestMethod.POST})
    public Message deleteVersion(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws IOException, ErrorException {
        String user = RestfulUtils.getUserName(request);
        if (null == jsonNode.get("resourceId") || null == jsonNode.get("version") || StringUtils.isEmpty((CharSequence)jsonNode.get("resourceId").textValue()) || StringUtils.isEmpty((CharSequence)jsonNode.get("version").textValue())) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.DELETE_SPECIFIED_VERSION.getErrorDesc());
        }
        String resourceId = jsonNode.get("resourceId").textValue();
        String version = jsonNode.get("version").textValue();
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("deleteVersion,resourceId:{0},version:{1}", resourceId, version));
        if (!(this.resourceService.checkResourceId(resourceId) && this.versionService.checkVersion(resourceId, version) && this.versionService.canAccess(resourceId, version))) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.ILLEGAL_OR_DELETED.getErrorDesc());
        }
        Message message = null;
        ResourceTask resourceTask = this.taskService.createDeleteVersionTask(resourceId, version, user, HttpRequestHelper.getIp(request));
        try {
            this.logger.info("User {} starts to delete resource of ResourceID: {} version: {}(\u7528\u6237 {} \u5f00\u59cb\u5220\u9664 resourceId: {} version: {} \u7684\u8d44\u6e90)", new Object[]{user, resourceId, version, user, resourceId, version});
            this.versionService.deleteResourceVersion(resourceId, version);
            message = Message.ok((String)"Deleted version successfully(\u5220\u9664\u7248\u672c\u6210\u529f)");
            message.setMethod("/bml/deleteVersion");
            message.setStatus(0);
            this.logger.info("User {} ends deleting the resourceID: {} version: {} resource(\u7528\u6237 {} \u7ed3\u675f\u5220\u9664 resourceId: {} version: {} \u7684\u8d44\u6e90)", new Object[]{user, resourceId, version, user, resourceId, version});
            this.taskService.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
            this.logger.info("Update task tasKid :{} -ResourceId :{} with {} state\uff08\u5220\u9664\u7248\u672c\u6210\u529f.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001\uff09.", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
        }
        catch (Exception e) {
            this.logger.error("User {} failed to delete resource {}, version {}(\u7528\u6237{}\u5220\u9664resource {}, version {} \u5931\u8d25)", new Object[]{user, resourceId, version, user, resourceId, version, e});
            this.taskService.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
            this.logger.info("Update task tasKid :{} -ResourceId :{} with {} state\uff08\u5220\u9664\u7248\u672c\u6210\u529f.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001\uff09.", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.DELETE_VERSION_FAILED.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="deleteResource", notes="delete Resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"deleteResource"}, method={RequestMethod.POST})
    public Message deleteResource(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws IOException, ErrorException {
        String user = RestfulUtils.getUserName(request);
        if (null == jsonNode.get("resourceId")) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.NOT_BALID_RESOURCEID.getErrorDesc());
        }
        String resourceId = jsonNode.get("resourceId").textValue();
        if (StringUtils.isEmpty((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            this.logger.error("the error resourceId  is {} ", (Object)resourceId);
            throw new BmlServerParaErrorException("the resourceId" + resourceId + " is null ,Illegal or deleted (resourceId:" + resourceId + "\u4e3a\u7a7a,\u975e\u6cd5\u6216\u8005\u5df2\u88ab\u5220\u9664!)");
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("deleteResource,resourceId:" + resourceId));
        Message message = null;
        ResourceTask resourceTask = this.taskService.createDeleteResourceTask(resourceId, user, HttpRequestHelper.getIp(request));
        try {
            this.logger.info("User {} starts to delete all resources corresponding to ResourceId: {}(\u7528\u6237 {}  \u5f00\u59cb\u5220\u9664 resourceId: {} \u5bf9\u5e94\u7684\u6240\u6709\u8d44\u6e90)", new Object[]{user, resourceId, user, resourceId});
            this.resourceService.deleteResource(resourceId);
            message = Message.ok((String)"Resource deleted successfully(\u5220\u9664\u8d44\u6e90\u6210\u529f)");
            message.setMethod("/bml/deleteResource");
            message.setStatus(0);
            this.logger.info("User {} ends deleting all resources corresponding to ResourceId: {}(\u7528\u6237 {}  \u7ed3\u675f\u5220\u9664 resourceId: {} \u5bf9\u5e94\u7684\u6240\u6709\u8d44\u6e90)", new Object[]{user, resourceId, user, resourceId});
            this.taskService.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
            this.logger.info("Resource deleted successfully. Update task tasKid :{} -ResourceId :{} with {} state (\u5220\u9664\u8d44\u6e90\u6210\u529f.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001).", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
        }
        catch (Exception e) {
            this.logger.error("User {} failed to delete resource {}(\u7528\u6237 {} \u5220\u9664\u8d44\u6e90 {} \u5931\u8d25)", new Object[]{user, resourceId, user, resourceId});
            this.taskService.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
            this.logger.info("Failed to delete resource. Update task tasKid :{} -ResourceId :{} is in {} state(\u5220\u9664\u8d44\u6e90\u5931\u8d25.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001.)", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue()});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.DELETE_OPERATION_FAILED.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="deleteResources", notes="batch delete resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceIds", required=true, dataType="List")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"deleteResources"}, method={RequestMethod.POST})
    public Message deleteResources(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws IOException, ErrorException {
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"deleteResources");
        ArrayList<String> resourceIds = new ArrayList<String>();
        if (null == jsonNode.get("resourceIds")) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.BULK_DELETION_PARAMETERS.getErrorDesc());
        }
        Iterator jsonNodeIter = jsonNode.get("resourceIds").elements();
        while (jsonNodeIter.hasNext()) {
            resourceIds.add(((JsonNode)jsonNodeIter.next()).asText());
        }
        if (0 == resourceIds.size()) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.PARAMETERS_IS_NULL.getErrorDesc());
        }
        for (String resourceId : resourceIds) {
            if (!StringUtils.isBlank((CharSequence)resourceId) && this.resourceService.checkResourceId(resourceId)) continue;
            Message message = Message.error((String)MessageFormat.format(BmlServerErrorCodeSummary.RESOURCEID_BEEN_DELETED.getErrorDesc(), resourceId));
            message.setMethod("/bml/deleteResources");
            message.setStatus(1);
            return message;
        }
        ResourceTask resourceTask = this.taskService.createDeleteResourcesTask(resourceIds, user, HttpRequestHelper.getIp(request));
        Message message = null;
        try {
            this.logger.info("User {} begins to batch delete resources (\u7528\u6237 {} \u5f00\u59cb\u6279\u5220\u9664\u8d44\u6e90) ", (Object)user, (Object)user);
            this.resourceService.batchDeleteResources(resourceIds);
            message = Message.ok((String)"Batch deletion of resource was successful(\u6279\u91cf\u5220\u9664\u8d44\u6e90\u6210\u529f)");
            message.setMethod("/bml/deleteResources");
            message.setStatus(0);
            this.logger.info("User {} ends the bulk deletion of resources (\u7528\u6237 {} \u7ed3\u675f\u6279\u91cf\u5220\u9664\u8d44\u6e90)", (Object)user, (Object)user);
            this.taskService.updateState(resourceTask.getId(), TaskState.SUCCESS.getValue(), new Date());
            this.logger.info("Batch deletion of resource was successful. Update task tasKid :{} -ResourceId :{} is in the {} state (\u6279\u91cf\u5220\u9664\u8d44\u6e90\u6210\u529f.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001.)", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.SUCCESS.getValue()});
        }
        catch (Exception e) {
            this.logger.error("\"User {} failed to delete resources in bulk (\u7528\u6237 {} \u6279\u91cf\u5220\u9664\u8d44\u6e90\u5931\u8d25)", new Object[]{user, user, e});
            this.taskService.updateState2Failed(resourceTask.getId(), TaskState.FAILED.getValue(), new Date(), e.getMessage());
            this.logger.info("Failed to delete resources in bulk. Update task tasKid :{} -ResourceId :{} is in the {} state (\u6279\u91cf\u5220\u9664\u8d44\u6e90\u5931\u8d25.\u66f4\u65b0\u4efb\u52a1 taskId:{}-resourceId:{} \u4e3a {} \u72b6\u6001.)", new Object[]{resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue(), resourceTask.getId(), resourceTask.getResourceId(), TaskState.FAILED.getValue()});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.BULK_DELETE_FAILED.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="download", notes="download resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", dataType="String"), @ApiImplicitParam(name="version", dataType="String")})
    @RequestMapping(path={"download"}, method={RequestMethod.GET})
    public void download(@RequestParam(value="resourceId", required=false) String resourceId, @RequestParam(value="version", required=false) String version, HttpServletResponse resp, HttpServletRequest request) throws IOException, ErrorException {
        String user = RestfulUtils.getUserName(request);
        if (StringUtils.isBlank((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            throw new BmlQueryFailException("ResourceID :" + resourceId + " is empty, illegal or has been deleted (resourceId:" + resourceId + "\u4e3a\u7a7a,\u975e\u6cd5\u6216\u8005\u5df2\u88ab\u5220\u9664!)");
        }
        if (!this.resourceService.checkAuthority(user, resourceId)) {
            throw new BmlPermissionDeniedException(BmlServerErrorCodeSummary.NOT_HAVE_PERMISSION.getErrorDesc());
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            version = this.versionService.getNewestVersion(resourceId);
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("download,resourceId:{0},version:{1}", resourceId, version));
        if (!this.versionService.checkVersion(resourceId, version)) {
            throw new BmlQueryFailException(MessageFormat.format(BmlServerErrorCodeSummary.VERSION_BEEN_DELETED.getErrorDesc(), version));
        }
        if (!this.resourceService.checkExpire(resourceId, version)) {
            throw new BmlResourceExpiredException(resourceId);
        }
        Object message = null;
        resp.setContentType("application/x-msdownload");
        resp.setHeader("Content-Disposition", "attachment");
        String ip = HttpRequestHelper.getIp(request);
        DownloadModel downloadModel = new DownloadModel(resourceId, version, user, ip);
        try {
            this.logger.info("user {} downLoad resource  resourceId is {}, version is {} ,ip is {} ", new Object[]{user, resourceId, version, ip});
            HashMap<String, Object> properties = new HashMap<String, Object>();
            boolean downloadResult = this.versionService.downloadResource(user, resourceId, version, (OutputStream)resp.getOutputStream(), properties);
            downloadModel.setEndTime(new Date(System.currentTimeMillis()));
            downloadModel.setState(0);
            if (!downloadResult) {
                this.logger.warn("ResourceId :{}, version:{} has a problem when user {} downloads the resource. The copied size is less than 0(\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0\u95ee\u9898,\u590d\u5236\u7684size\u5c0f\u4e8e0)", new Object[]{resourceId, version, user, user, resourceId, version});
                downloadModel.setState(1);
                throw new BmlQueryFailException(BmlServerErrorCodeSummary.FAILED_DOWNLOAD_RESOURCE.getErrorDesc());
            }
            this.downloadService.addDownloadRecord(downloadModel);
            this.logger.info("User {} ends downloading the resource {}(\u7528\u6237 {} \u7ed3\u675f\u4e0b\u8f7d\u8d44\u6e90 {}) ", new Object[]{user, resourceId, user, resourceId});
        }
        catch (IOException e) {
            this.logger.error("IO Exception: ResourceId :{}, version:{} (\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0IO\u5f02\u5e38)", new Object[]{resourceId, version, user, resourceId, version, e});
            downloadModel.setEndTime(new Date());
            downloadModel.setState(1);
            this.downloadService.addDownloadRecord(downloadModel);
            throw new ErrorException(73562, "Sorry, the background IO error caused you to download the resources failed(\u62b1\u6b49,\u540e\u53f0IO\u9519\u8bef\u9020\u6210\u60a8\u672c\u6b21\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25)");
        }
        catch (Throwable t) {
            this.logger.error("ResourceId :{}, version:{} abnormal when user {} downloads resource (\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0\u5f02\u5e38)", new Object[]{resourceId, version, user, user, resourceId, version, t});
            downloadModel.setEndTime(new Date());
            downloadModel.setState(1);
            this.downloadService.addDownloadRecord(downloadModel);
            throw new ErrorException(73561, "Sorry, the background service error caused you to download the resources failed(\u62b1\u6b49\uff0c\u540e\u53f0\u670d\u52a1\u51fa\u9519\u5bfc\u81f4\u60a8\u672c\u6b21\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25)");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
        }
        this.logger.info("{} Download resource {} successfully {} \u4e0b\u8f7d\u8d44\u6e90 {} \u6210\u529f", new Object[]{user, resourceId, user, resourceId});
    }

    @ApiOperation(value="upload", notes="upload resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="system", required=false, dataType="String", value="system"), @ApiImplicitParam(name="resourceHeader", dataType="String"), @ApiImplicitParam(name="isExpire", dataType="String"), @ApiImplicitParam(name="expireType", dataType="String"), @ApiImplicitParam(name="expireTime", dataType="String"), @ApiImplicitParam(name="maxVersion", dataType="String"), @ApiImplicitParam(name="file", required=true, dataType="List<MultipartFile>")})
    @RequestMapping(path={"upload"}, method={RequestMethod.POST})
    public Message uploadResource(HttpServletRequest req, @RequestParam(name="system", required=false) String system, @RequestParam(name="resourceHeader", required=false) String resourceHeader, @RequestParam(name="isExpire", required=false) String isExpire, @RequestParam(name="expireType", required=false) String expireType, @RequestParam(name="expireTime", required=false) String expireTime, @RequestParam(name="maxVersion", required=false) Integer maxVersion, @RequestParam(name="file") List<MultipartFile> files) throws ErrorException {
        Message message;
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"uploadResource");
        try {
            this.logger.info("User {} starts uploading resources (\u7528\u6237 {} \u5f00\u59cb\u4e0a\u4f20\u8d44\u6e90)", (Object)user, (Object)user);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("system", system);
            properties.put("resourceHeader", resourceHeader);
            properties.put("isExpire", isExpire);
            properties.put("expireType", expireType);
            properties.put("expireTime", expireTime);
            properties.put("maxVersion", maxVersion);
            String clientIp = HttpRequestHelper.getIp(req);
            properties.put("clientIp", clientIp);
            ResourceTask resourceTask = this.taskService.createUploadTask(files, user, properties);
            message = Message.ok((String)"The task of submitting and uploading resources was successful(\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u6210\u529f)");
            message.setMethod("/bml/upload");
            message.setStatus(0);
            message.data("resourceId", (Object)resourceTask.getResourceId());
            message.data("version", (Object)resourceTask.getVersion());
            message.data("taskId", (Object)resourceTask.getId());
            this.logger.info("User {} submitted upload resource task successfully(\u7528\u6237 {} \u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u6210\u529f, resourceId is {})", new Object[]{user, user, resourceTask.getResourceId()});
        }
        catch (Exception e) {
            this.logger.error("upload resource for user : {} failed, reason:", (Object)user, (Object)e);
            ErrorException exception = new ErrorException(50073, "The commit upload resource task failed(\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u5931\u8d25):" + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="updateVersion", notes="update resource version", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="file", required=true, dataType="MultipartFile", value="file")})
    @RequestMapping(path={"updateVersion"}, method={RequestMethod.POST})
    public Message updateVersion(HttpServletRequest request, @RequestParam(value="resourceId") String resourceId, @RequestParam(value="file") MultipartFile file) throws Exception {
        Message message;
        if (StringUtils.isEmpty((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            this.logger.error("error resourceId  is {} ", (Object)resourceId);
            throw new BmlServerParaErrorException("resourceId: " + resourceId + " is Null, illegal, or deleted!");
        }
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("updateVersion\uff0cresourceId\uff1a" + resourceId));
        if (StringUtils.isEmpty((CharSequence)this.versionService.getNewestVersion(resourceId))) {
            this.logger.error("If the material has not been uploaded or has been deleted, please call the upload interface first .(resourceId:{} \u4e4b\u524d\u672a\u4e0a\u4f20\u7269\u6599,\u6216\u7269\u6599\u5df2\u88ab\u5220\u9664,\u8bf7\u5148\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3.)", (Object)resourceId);
            throw new BmlServerParaErrorException("If the material has not been uploaded or has been deleted, please call the upload interface first( resourceId: " + resourceId + " \u4e4b\u524d\u672a\u4e0a\u4f20\u7269\u6599,\u6216\u7269\u6599\u5df2\u88ab\u5220\u9664,\u8bf7\u5148\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3.!)");
        }
        try {
            this.logger.info("User {} starts updating resources {}(\u7528\u6237 {} \u5f00\u59cb\u66f4\u65b0\u8d44\u6e90 {}) ", new Object[]{user, resourceId, user, resourceId});
            String clientIp = HttpRequestHelper.getIp(request);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("clientIp", clientIp);
            ResourceTask resourceTask = null;
            String string = resourceId.intern();
            synchronized (string) {
                resourceTask = this.taskService.createUpdateTask(resourceId, user, file, properties);
            }
            message = Message.ok((String)"The update resource task was submitted successfully(\u63d0\u4ea4\u66f4\u65b0\u8d44\u6e90\u4efb\u52a1\u6210\u529f)");
            message.data("resourceId", (Object)resourceId).data("version", (Object)resourceTask.getVersion()).data("taskId", (Object)resourceTask.getId());
        }
        catch (ErrorException e) {
            this.logger.error("{} update resource failed, resourceId is {}, reason:", new Object[]{user, resourceId, e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("{} update resource failed, resourceId is {}, reason:", new Object[]{user, resourceId, e});
            ErrorException exception = new ErrorException(50073, "The commit upload resource task failed(\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u5931\u8d25):" + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
        this.logger.info("User {} ends updating resources {}(\u7528\u6237 {} \u7ed3\u675f\u66f4\u65b0\u8d44\u6e90 {}) ", new Object[]{user, resourceId, user, resourceId});
        return message;
    }

    @ApiOperation(value="getBasic", notes="get resource basic info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String")})
    @RequestMapping(path={"getBasic"}, method={RequestMethod.GET})
    public Message getBasic(@RequestParam(value="resourceId", required=false) String resourceId, HttpServletRequest request) throws ErrorException {
        if (StringUtils.isEmpty((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            throw new BmlServerParaErrorException(BmlServerErrorCodeSummary.PARAMETER_IS_ILLEGAL.getErrorDesc());
        }
        String user = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getBasic\uff0cresourceId\uff1a" + resourceId));
        Message message = null;
        try {
            Resource resource = this.resourceService.getResource(resourceId);
            if (!resource.isEnableFlag()) {
                this.logger.warn("The resource {} that user {} wants to query has been deleted (\u7528\u6237 {} \u60f3\u8981\u67e5\u8be2\u7684\u8d44\u6e90 {} \u5df2\u7ecf\u88ab\u5220\u9664)", new Object[]{user, resourceId, user, resourceId});
                message = Message.error((String)"The resource has been deleted(\u8d44\u6e90\u5df2\u7ecf\u88ab\u5220\u9664)");
            } else {
                this.logger.info("User {} starts getting basic information about {}(\u7528\u6237 {} \u5f00\u59cb\u83b7\u53d6 {} \u7684\u57fa\u672c\u4fe1\u606f)", new Object[]{user, resourceId, user, resourceId});
                ResourceBasicVO basic = new ResourceBasicVO();
                basic.setResourceId(resourceId);
                basic.setCreateTime(resource.getCreateTime());
                basic.setDownloadedFileName(resource.getDownloadedFileName());
                basic.setOwner(resource.getUser());
                basic.setNumberOfVerions(10);
                if (resource.isExpire()) {
                    basic.setExpireTime(RestfulUtils.getExpireTime(resource.getCreateTime(), resource.getExpireType(), resource.getExpireTime()));
                } else {
                    basic.setExpireTime("Resource not expired(\u8d44\u6e90\u4e0d\u8fc7\u671f)");
                }
                message = Message.ok((String)"Acquisition of resource basic information successfully(\u83b7\u53d6\u8d44\u6e90\u57fa\u672c\u4fe1\u606f\u6210\u529f)");
                message.setStatus(0);
                message.setMethod("/bml/getBasic");
                message.data("basic", (Object)basic);
                this.logger.info("User {} ends fetching basic information for {}(\u7528\u6237 {} \u7ed3\u675f\u83b7\u53d6 {} \u7684\u57fa\u672c\u4fe1\u606f)", new Object[]{user, resourceId, user, resourceId});
            }
        }
        catch (Exception e) {
            this.logger.error("\u7528\u6237 {} \u83b7\u53d6 {} \u8d44\u6e90\u4fe1\u606f\u5931\u8d25", new Object[]{user, resourceId, e});
            throw new BmlQueryFailException(BmlServerErrorCodeSummary.FAILED_RESOURCE_BASIC.getErrorDesc());
        }
        return message;
    }

    @ApiOperation(value="getResourceInfo", notes="get resource info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String")})
    @RequestMapping(path={"getResourceInfo"}, method={RequestMethod.GET})
    public Message getResourceInfo(HttpServletRequest request, @RequestParam(value="resourceId", required=false) String resourceId) {
        return Message.ok((String)"Obtained information successfully(\u83b7\u53d6\u4fe1\u606f\u6210\u529f)");
    }

    @ApiOperation(value="changeOwner", notes="change resource owner", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="oldOwner", required=true, dataType="String", value="old Owner"), @ApiImplicitParam(name="newOwner", required=true, dataType="String", value="new Owner")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"changeOwner"}, method={RequestMethod.POST})
    public Message changeOwnerByResourceId(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ErrorException {
        String resourceId = jsonNode.get("resourceId").textValue();
        String oldOwner = jsonNode.get("oldOwner").textValue();
        String newOwner = jsonNode.get("newOwner").textValue();
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("download,resourceId:{0},oldOwner:{1},newOwner:{2}", resourceId, oldOwner, newOwner));
        this.resourceService.changeOwnerByResourceId(resourceId, oldOwner, newOwner);
        return Message.ok((String)"\u66f4\u65b0owner\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="copyResourceToAnotherUser", notes="copy resource to another user", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="anotherUser", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"copyResourceToAnotherUser"}, method={RequestMethod.POST})
    public Message copyResourceToAnotherUser(HttpServletRequest request, @RequestBody JsonNode jsonNode) {
        String resourceId = jsonNode.get("resourceId").textValue();
        String anotherUser = jsonNode.get("anotherUser").textValue();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("copyResourceToAnotherUser\uff0cresourceId\uff1a" + resourceId));
        Message message = null;
        try {
            this.logger.info("\u7528\u6237 {} \u5f00\u59cb copy bml resource: {}", (Object)username, (Object)resourceId);
            String clientIp = HttpRequestHelper.getIp(request);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("clientIp", clientIp);
            properties.put("maxVersion", 0);
            properties.put("system", "dss");
            ResourceTask resourceTask = null;
            String string = resourceId.intern();
            synchronized (string) {
                resourceTask = this.taskService.createCopyResourceTask(resourceId, anotherUser, properties);
            }
            message = Message.ok();
            message.data("resourceId", (Object)resourceTask.getResourceId());
        }
        catch (Exception e) {
            this.logger.error("failed to copy bml resource:", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        this.logger.info("\u7528\u6237 {} \u7ed3\u675f copy bml resource: {}", (Object)username, (Object)resourceId);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="RollbackVersion", notes="rollback resource version", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="version", required=true, dataType="String", value="version")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"rollbackVersion"}, method={RequestMethod.POST})
    public Message rollbackVersion(HttpServletRequest request, @RequestBody JsonNode jsonNode) {
        String resourceId = jsonNode.get("resourceId").textValue();
        String rollbackVersion = jsonNode.get("version").textValue();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("download,resourceId:{0},rollbackVersion:{1}", resourceId, rollbackVersion));
        Message message = null;
        try {
            this.logger.info("\u7528\u6237 {} \u5f00\u59cbrollback bml resource: {}, version:{} ", new Object[]{username, resourceId, rollbackVersion});
            String clientIp = HttpRequestHelper.getIp(request);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("clientIp", clientIp);
            ResourceTask resourceTask = null;
            String string = resourceId.intern();
            synchronized (string) {
                resourceTask = this.taskService.createRollbackVersionTask(resourceId, rollbackVersion, username, properties);
            }
            message = Message.ok();
            message.data("resourceId", (Object)resourceTask.getResourceId()).data("version", (Object)resourceTask.getVersion());
        }
        catch (Exception e) {
            this.logger.error("failed to rollback version:", (Throwable)e);
            message = Message.error((String)e.getMessage());
        }
        this.logger.info("\u7528\u6237 {} \u7ed3\u675frollback bml resource: {}, version:{} ", new Object[]{username, resourceId, rollbackVersion});
        return message;
    }
}

