/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.entity;

import java.util.Date;
import java.util.Map;
import org.apache.linkis.bml.common.OperationEnum;
import org.apache.linkis.bml.threading.TaskState;
import org.apache.linkis.rpc.Sender;

public class ResourceTask {
    private long id;
    private String resourceId;
    private String version;
    private String operation;
    private String state;
    private String submitUser;
    private String system;
    private String instance;
    private String clientIp;
    private String errMsg;
    private String extraParams;
    private Date startTime;
    private Date endTime;
    private Date lastUpdateTime;
    private static final String DEFAULT_SYSTEM = "dss";
    private static final String SYSTEM = "system";
    private static final String CLIENT_IP = "clientIp";

    public static ResourceTask createUploadTask(String resourceId, String user, Map<String, Object> properties) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setVersion("v000001");
        resourceTask.setOperation(OperationEnum.UPLOAD.getValue());
        resourceTask.setState(TaskState.SCHEDULED.getValue());
        resourceTask.setSubmitUser(user);
        if (null != properties.get(SYSTEM)) {
            resourceTask.setSystem((String)properties.get(SYSTEM));
        } else {
            resourceTask.setSystem(DEFAULT_SYSTEM);
        }
        resourceTask.setClientIp((String)properties.get(CLIENT_IP));
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createUpdateTask(String resourceId, String version, String user, String system, Map<String, Object> properties) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setVersion(version);
        resourceTask.setOperation(OperationEnum.UPDATE.getValue());
        resourceTask.setState(TaskState.SCHEDULED.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp((String)properties.get(CLIENT_IP));
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createDownloadTask(String resourceId, String version, String user, String system, String clientIp) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setVersion(version);
        resourceTask.setOperation(OperationEnum.DOWNLOAD.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(clientIp);
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createDeleteVersionTask(String resourceId, String version, String user, String system, String clientIp) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setVersion(version);
        resourceTask.setOperation(OperationEnum.DELETE_VERSION.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(clientIp);
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createDeleteResourceTask(String resourceId, String user, String system, String clientIp, String extraParams) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setExtraParams(extraParams);
        resourceTask.setOperation(OperationEnum.DELETE_RESOURCE.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(clientIp);
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createDeleteResourcesTask(String user, String system, String clientIp, String extraParams) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setExtraParams(extraParams);
        resourceTask.setOperation(OperationEnum.DELETE_RESOURCES.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(clientIp);
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createRollbackVersionTask(String resourceId, String version, String user, String system, Map<String, Object> properties) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setVersion(version);
        resourceTask.setExtraParams(null);
        resourceTask.setOperation(OperationEnum.ROLLBACK_VERSION.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(properties.get(CLIENT_IP).toString());
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public static ResourceTask createCopyResourceTask(String resourceId, String user, String system, Map<String, Object> properties) {
        ResourceTask resourceTask = new ResourceTask();
        resourceTask.setResourceId(resourceId);
        resourceTask.setExtraParams(null);
        resourceTask.setOperation(OperationEnum.COPY_RESOURCE.getValue());
        resourceTask.setState(TaskState.RUNNING.getValue());
        resourceTask.setSubmitUser(user);
        resourceTask.setClientIp(properties.get(CLIENT_IP).toString());
        resourceTask.setSystem(system);
        resourceTask.setInstance(Sender.getThisInstance());
        resourceTask.setStartTime(new Date());
        resourceTask.setLastUpdateTime(new Date());
        return resourceTask;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public String toString() {
        return "ResourceTask{id=" + this.id + ", resourceId='" + this.resourceId + '\'' + ", version='" + this.version + '\'' + ", operation='" + this.operation + '\'' + ", state='" + this.state + '\'' + ", submitUser='" + this.submitUser + '\'' + ", system='" + this.system + '\'' + ", instance='" + this.instance + '\'' + ", clientIp='" + this.clientIp + '\'' + ", errMsg='" + this.errMsg + '\'' + ", extraParams='" + this.extraParams + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", lastUpdateTime=" + this.lastUpdateTime + '}';
    }
}

