/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.monitor;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.manager.am.conf.ManagerMonitorConf;
import org.apache.linkis.manager.am.converter.MetricsConverter;
import org.apache.linkis.manager.am.service.em.EMUnregisterService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.am.service.heartbeat.AMHeartbeatService;
import org.apache.linkis.manager.am.service.monitor.NodeHeartbeatMonitor$;
import org.apache.linkis.manager.am.service.monitor.OwnerNodeMetrics;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeHealthyInfo;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.monitor.ManagerMonitor;
import org.apache.linkis.manager.common.protocol.em.StopEMRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatMsg;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatRequest;
import org.apache.linkis.manager.common.utils.ManagerUtils;
import org.apache.linkis.manager.persistence.NodeManagerPersistence;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.manager.service.common.label.ManagerLabelService;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.exception.NoInstanceExistsException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Component
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001\u0002\u001c8\u0001\u0019CQ!\u0018\u0001\u0005\u0002yC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00022\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0013Q\u0007\"C:\u0001\u0001\u0004\u0005\t\u0015)\u0003d\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u0003'\u0001\u0001\u0019!A!B\u0013\t9\u0001C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003SA1\"!\f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001c!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\t\u0017\u0005\u001d\u0003\u00011A\u0001B\u0003&\u0011Q\u0007\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0005C\u0006\u0002\\\u0001\u0001\r\u00111A\u0005\n\u0005u\u0003bCA1\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fB1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002h!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\tY\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u0017\u0005}\u0004\u00011AA\u0002\u0013%\u0011\u0011\u0011\u0005\f\u0003'\u0003\u0001\u0019!a\u0001\n\u0013\t)\nC\u0006\u0002\u001a\u0002\u0001\r\u0011!Q!\n\u0005\r\u0005\"CAO\u0001\t\u0007I\u0011BAP\u0011!\t\t\f\u0001Q\u0001\n\u0005\u0005\u0006\"CAZ\u0001\t\u0007I\u0011BA[\u0011!\ti\f\u0001Q\u0001\n\u0005]\u0006\"CA`\u0001\t\u0007I\u0011BA[\u0011!\t\t\r\u0001Q\u0001\n\u0005]\u0006\"CAb\u0001\t\u0007I\u0011BAc\u0011!\ti\r\u0001Q\u0001\n\u0005\u001d\u0007\"CAh\u0001\t\u0007I\u0011BAc\u0011!\t\t\u000e\u0001Q\u0001\n\u0005\u001d\u0007\"CAj\u0001\t\u0007I\u0011BAc\u0011!\t)\u000e\u0001Q\u0001\n\u0005\u001d\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqA!\u0012\u0001\t\u0013\u00119\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9!q\f\u0001\u0005\n\t\u0005\u0004b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqA!!\u0001\t\u0013\u0011\u0019\tC\u0004\u00030\u0002!IA!-\u0003)9{G-\u001a%fCJ$(-Z1u\u001b>t\u0017\u000e^8s\u0015\tA\u0014(A\u0004n_:LGo\u001c:\u000b\u0005iZ\u0014aB:feZL7-\u001a\u0006\u0003yu\n!!Y7\u000b\u0005yz\u0014aB7b]\u0006<WM\u001d\u0006\u0003\u0001\u0006\u000ba\u0001\\5oW&\u001c(B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u000f>3\u0006C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0011a\u0017M\\4\u000b\u00031\u000bAA[1wC&\u0011a*\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A#V\"A)\u000b\u0005a\u0012&BA*>\u0003\u0019\u0019w.\\7p]&\u0011Q+\u0015\u0002\u000f\u001b\u0006t\u0017mZ3s\u001b>t\u0017\u000e^8s!\t96,D\u0001Y\u0015\tI&,A\u0003vi&d7O\u0003\u0002T\u007f%\u0011A\f\u0017\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\f\u0005\u0002a\u00015\tq'\u0001\fo_\u0012,W*\u00198bO\u0016\u0014\b+\u001a:tSN$XM\\2f+\u0005\u0019\u0007C\u00013h\u001b\u0005)'B\u00014>\u0003-\u0001XM]:jgR,gnY3\n\u0005!,'A\u0006(pI\u0016l\u0015M\\1hKJ\u0004VM]:jgR,gnY3\u000259|G-Z'b]\u0006<WM\u001d)feNL7\u000f^3oG\u0016|F%Z9\u0015\u0005-\f\bC\u00017p\u001b\u0005i'\"\u00018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Al'\u0001B+oSRDqA]\u0002\u0002\u0002\u0003\u00071-A\u0002yIE\nqC\\8eK6\u000bg.Y4feB+'o]5ti\u0016t7-\u001a\u0011)\u0005\u0011)\bC\u0001<\u0000\u001b\u00059(B\u0001=z\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003un\fqAZ1di>\u0014\u0018P\u0003\u0002}{\u0006)!-Z1og*\u0011apQ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0019\u0011\u0011A<\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\b8pI\u0016lU\r\u001e:jG6\u000bg.Y4feB+'o]5ti\u0016t7-Z\u000b\u0003\u0003\u000f\u00012\u0001ZA\u0005\u0013\r\tY!\u001a\u0002\u001d\u001d>$W-T3ue&\u001cW*\u00198bO\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003\u0001rw\u000eZ3NKR\u0014\u0018nY'b]\u0006<WM\u001d)feNL7\u000f^3oG\u0016|F%Z9\u0015\u0007-\f\t\u0002\u0003\u0005s\r\u0005\u0005\t\u0019AA\u0004\u0003uqw\u000eZ3NKR\u0014\u0018nY'b]\u0006<WM\u001d)feNL7\u000f^3oG\u0016\u0004\u0003FA\u0004v\u0003AiW\r\u001e:jGN\u001cuN\u001c<feR,'/\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"m\n\u0011bY8om\u0016\u0014H/\u001a:\n\t\u0005\u0015\u0012q\u0004\u0002\u0011\u001b\u0016$(/[2t\u0007>tg/\u001a:uKJ\fA#\\3ue&\u001c7oQ8om\u0016\u0014H/\u001a:`I\u0015\fHcA6\u0002,!A!/CA\u0001\u0002\u0004\tY\"A\tnKR\u0014\u0018nY:D_:4XM\u001d;fe\u0002B#AC;\u0002%\u0005l\u0007*Z1si\n,\u0017\r^*feZL7-Z\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wI\u0014!\u00035fCJ$(-Z1u\u0013\u0011\ty$!\u000f\u0003%\u0005k\u0005*Z1si\n,\u0017\r^*feZL7-Z\u0001\u0017C6DU-\u0019:uE\u0016\fGoU3sm&\u001cWm\u0018\u0013fcR\u00191.!\u0012\t\u0011Id\u0011\u0011!a\u0001\u0003k\t1#Y7IK\u0006\u0014HOY3biN+'O^5dK\u0002B#!D;\u0002#\u0015tw-\u001b8f'R|\u0007oU3sm&\u001cW-\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002Ve\na!\u001a8hS:,\u0017\u0002BA-\u0003'\u0012\u0011#\u00128hS:,7\u000b^8q'\u0016\u0014h/[2f\u0003U)gnZ5oKN#x\u000e]*feZL7-Z0%KF$2a[A0\u0011!\u0011x\"!AA\u0002\u0005=\u0013AE3oO&tWm\u0015;paN+'O^5dK\u0002B#\u0001E;\u0002'\u0015lWK\u001c:fO&\u001cH/\u001a:TKJ4\u0018nY3\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=\u0014(\u0001\u0002f[&!\u00111OA7\u0005M)U*\u00168sK\u001eL7\u000f^3s'\u0016\u0014h/[2f\u0003])W.\u00168sK\u001eL7\u000f^3s'\u0016\u0014h/[2f?\u0012*\u0017\u000fF\u0002l\u0003sB\u0001B\u001d\n\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u0015K6,fN]3hSN$XM]*feZL7-\u001a\u0011)\u0005M)\u0018aE7b]\u0006<WM\u001d'bE\u0016d7+\u001a:wS\u000e,WCAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bQ\u0001\\1cK2T1aUAG\u0015\tQT(\u0003\u0003\u0002\u0012\u0006\u001d%aE'b]\u0006<WM\u001d'bE\u0016d7+\u001a:wS\u000e,\u0017aF7b]\u0006<WM\u001d'bE\u0016d7+\u001a:wS\u000e,w\fJ3r)\rY\u0017q\u0013\u0005\teV\t\t\u00111\u0001\u0002\u0004\u0006!R.\u00198bO\u0016\u0014H*\u00192fYN+'O^5dK\u0002B#AF;\u0002\u001f\u0019L\u00070\u001a3UQJ,\u0017\r\u001a)pY2,\"!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005-6*\u0001\u0003vi&d\u0017\u0002BAX\u0003K\u0013q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0011M&DX\r\u001a+ie\u0016\fG\rU8mY\u0002\na!Z2OC6,WCAA\\!\rA\u0015\u0011X\u0005\u0004\u0003wK%AB*ue&tw-A\u0004fG:\u000bW.\u001a\u0011\u0002\u000f\u0015\u001cWNT1nK\u0006AQmY7OC6,\u0007%A\tnCb\u001c%/Z1uK&sG/\u001a:wC2,\"!a2\u0011\u00071\fI-C\u0002\u0002L6\u0014A\u0001T8oO\u0006\u0011R.\u0019=De\u0016\fG/Z%oi\u0016\u0014h/\u00197!\u0003Ei\u0017\r_+qI\u0006$X-\u00138uKJ4\u0018\r\\\u0001\u0013[\u0006DX\u000b\u001d3bi\u0016Le\u000e^3sm\u0006d\u0007%\u0001\tfG6DU-\u0019:u\u0005\u0016\fG\u000fV5nK\u0006\tRmY7IK\u0006\u0014HOQ3biRKW.\u001a\u0011\u0002\u0007I,h\u000eF\u0001l\u0003-!W-\u00197F\u0007:{G-Z:\u0015\u0007-\fy\u000eC\u0004\u0002b\u0012\u0002\r!a9\u0002\u0017\u0015tw-\u001b8f\u001d>$Wm\u001d\t\u0007\u0003K\f9/a;\u000e\u0005\u0005%\u0016\u0002BAu\u0003S\u0013A\u0001T5tiB!\u0011Q^A|\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0018\u0001\u00028pI\u0016T1!!>S\u0003\u0019)g\u000e^5us&!\u0011\u0011`Ax\u0005\u0011qu\u000eZ3\u0002\u001bU\u0004H-\u0019;f\u001b\u0016$(/[2t)\rY\u0017q \u0005\b\u0003c,\u0003\u0019AAv\u0003i!W-\u00197F\u00076su\u000e^#ySN$8/\u00138SK\u001eL7\u000f\u001e:z)\rY'Q\u0001\u0005\b\u0005\u000f1\u0003\u0019AAr\u0003!)7-\u001c(pI\u0016\u001c\u0018a\u00043fC2DU-\u00197uQfd\u0015n\u001d;\u0015\u0007-\u0014i\u0001C\u0004\u0003\u0010\u001d\u0002\rA!\u0005\u0002\u0017!,\u0017\r\u001c;is2K7\u000f\u001e\t\u0007\u0003K\f9Oa\u0005\u0011\t\tU!1D\u0007\u0003\u0005/QAA!\u0007\u0002t\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002\u0002B\u000f\u0005/\u00111BT8eK6+GO]5dg\u0006\tB-Z1m+:DU-\u00197uQfd\u0015n\u001d;\u0015\u0007-\u0014\u0019\u0003C\u0004\u0003&!\u0002\rA!\u0005\u0002\u001bUt\u0007.Z1mi\"LH*[:u\u0003Y!W-\u00197Ti>\u001c7.\u0011<bS2\f'\r\\3MSN$HcA6\u0003,!9!QF\u0015A\u0002\tE\u0011AE:u_\u000e\\\u0017I^1jY\u0006\u0014G.\u001a'jgR\f\u0001\u0004Z3bYN#xnY6V]\u00063\u0018-\u001b7bE2,G*[:u)\rY'1\u0007\u0005\b\u0005kQ\u0003\u0019\u0001B\t\u0003Q\u0019Ho\\2l+:\fe/Y5mC\ndW\rT5ti\u0006Ab-\u001b7uKJDU-\u00197uQf\fe\u000eZ,be:d\u0015n\u001d;\u0015\t\tE!1\b\u0005\b\u0005{Y\u0003\u0019\u0001B\t\u0003-qw\u000eZ3NKR\u0014\u0018nY:\u00021\u0019LG\u000e^3s'R|7m[!wC&d\u0017M\u00197f\u0019&\u001cH\u000f\u0006\u0003\u0003\u0012\t\r\u0003b\u0002B\u001fY\u0001\u0007!\u0011C\u0001\u001bM&dG/\u001a:Ti>\u001c7.\u00168Bm\u0006LG.\u00192mK2K7\u000f\u001e\u000b\u0005\u0005#\u0011I\u0005C\u0004\u0003>5\u0002\rA!\u0005\u0002'\u0019LG\u000e^3s+:DU-\u00197uQfd\u0015n\u001d;\u0015\t\tE!q\n\u0005\b\u0005{q\u0003\u0019\u0001B\t\u0003I\u0019G.Z1s+:DW-\u00197uQftu\u000eZ3\u0015\u0007-\u0014)\u0006C\u0004\u0003X=\u0002\rA!\u0017\u0002!=<h.\u001a:O_\u0012,W*\u001a;sS\u000e\u001c\bc\u00011\u0003\\%\u0019!QL\u001c\u0003!=;h.\u001a:O_\u0012,W*\u001a;sS\u000e\u001c\u0018aD2mK\u0006\u0014XI\\4j]\u0016tu\u000eZ3\u0015\u0007-\u0014\u0019\u0007C\u0004\u0003fA\u0002\rAa\u001a\u0002\u0011%t7\u000f^1oG\u0016\u0004BA!\u001b\u0003l5\t!,C\u0002\u0003ni\u0013qbU3sm&\u001cW-\u00138ti\u0006t7-Z\u0001\u0016iJLwmZ3s\u000b6#vn\u0015;pa\u0016sw-\u001b8f)\rY'1\u000f\u0005\b\u0005K\n\u0004\u0019\u0001B4\u0003Q!(/[4hKJ,enZ5oKN+\u0018nY5eKR\u00191N!\u001f\t\u000f\t\u0015$\u00071\u0001\u0003h\u0005\u0001BO]5hO\u0016\u0014X)T*vS\u000eLG-\u001a\u000b\u0004W\n}\u0004b\u0002B3g\u0001\u0007!qM\u0001\u0014kB$\u0017\r^3NKR\u0014\u0018n\u0019%fC2$\b.\u001f\u000b\bW\n\u0015%q\u0011BL\u0011\u001d\u0011i\u0004\u000ea\u0001\u0005'AqA!#5\u0001\u0004\u0011Y)A\u0006o_\u0012,\u0007*Z1mi\"L\b\u0003\u0002BG\u0005'k!Aa$\u000b\t\tE\u00151_\u0001\fK:,X.\u001a:bi&|g.\u0003\u0003\u0003\u0016\n=%a\u0003(pI\u0016DU-\u00197uQfDqA!'5\u0001\u0004\u0011Y*\u0001\u0004sK\u0006\u001cxN\u001c\t\u0005\u0005;\u0013YK\u0004\u0003\u0003 \n\u001d\u0006c\u0001BQ[6\u0011!1\u0015\u0006\u0004\u0005K+\u0015A\u0002\u001fs_>$h(C\u0002\u0003*6\fa\u0001\u0015:fI\u00164\u0017\u0002BA^\u0005[S1A!+n\u0003]!W-\u00197NKR\u0014\u0018nY+qI\u0006$X\rV5nK>+H\u000fF\u0003l\u0005g\u00139\fC\u0004\u00036V\u0002\rAa\u0005\u0002\u00159|G-Z'fiJL7\rC\u0004\u0003:V\u0002\rAa/\u0002\u0003\u0015\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003L\u0015a\u0002:fM2,7\r^\u0005\u0005\u0005\u000b\u0014yL\u0001\u000fV]\u0012,7\r\\1sK\u0012$\u0006N]8xC\ndW-\u0012=dKB$\u0018n\u001c8)\u0007\u0001\u0011I\r\u0005\u0003\u0003L\nEWB\u0001Bg\u0015\r\u0011y-`\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002Bj\u0005\u001b\u0014\u0011bQ8na>tWM\u001c;")
public class NodeHeartbeatMonitor
implements ManagerMonitor,
Logging {
    @Autowired
    private NodeManagerPersistence nodeManagerPersistence;
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    @Autowired
    private MetricsConverter metricsConverter;
    @Autowired
    private AMHeartbeatService amHeartbeatService;
    @Autowired
    private EngineStopService engineStopService;
    @Autowired
    private EMUnregisterService emUnregisterService;
    @Autowired
    private ManagerLabelService managerLabelService;
    private final ExecutorService fixedThreadPoll;
    private final String ecName;
    private final String ecmName;
    private final long maxCreateInterval;
    private final long maxUpdateInterval;
    private final long ecmHeartBeatTime;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        NodeHeartbeatMonitor nodeHeartbeatMonitor = this;
        synchronized (nodeHeartbeatMonitor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeManagerPersistence nodeManagerPersistence() {
        return this.nodeManagerPersistence;
    }

    private void nodeManagerPersistence_$eq(NodeManagerPersistence x$1) {
        this.nodeManagerPersistence = x$1;
    }

    private NodeMetricManagerPersistence nodeMetricManagerPersistence() {
        return this.nodeMetricManagerPersistence;
    }

    private void nodeMetricManagerPersistence_$eq(NodeMetricManagerPersistence x$1) {
        this.nodeMetricManagerPersistence = x$1;
    }

    private MetricsConverter metricsConverter() {
        return this.metricsConverter;
    }

    private void metricsConverter_$eq(MetricsConverter x$1) {
        this.metricsConverter = x$1;
    }

    private AMHeartbeatService amHeartbeatService() {
        return this.amHeartbeatService;
    }

    private void amHeartbeatService_$eq(AMHeartbeatService x$1) {
        this.amHeartbeatService = x$1;
    }

    private EngineStopService engineStopService() {
        return this.engineStopService;
    }

    private void engineStopService_$eq(EngineStopService x$1) {
        this.engineStopService = x$1;
    }

    private EMUnregisterService emUnregisterService() {
        return this.emUnregisterService;
    }

    private void emUnregisterService_$eq(EMUnregisterService x$1) {
        this.emUnregisterService = x$1;
    }

    private ManagerLabelService managerLabelService() {
        return this.managerLabelService;
    }

    private void managerLabelService_$eq(ManagerLabelService x$1) {
        this.managerLabelService = x$1;
    }

    private ExecutorService fixedThreadPoll() {
        return this.fixedThreadPoll;
    }

    private String ecName() {
        return this.ecName;
    }

    private String ecmName() {
        return this.ecmName;
    }

    private long maxCreateInterval() {
        return this.maxCreateInterval;
    }

    private long maxUpdateInterval() {
        return this.maxUpdateInterval;
    }

    private long ecmHeartBeatTime() {
        return this.ecmHeartBeatTime;
    }

    public void run() {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info("Start to check the health of the node");
            List nodes = this.nodeManagerPersistence().getAllNodes();
            List metricList = this.nodeMetricManagerPersistence().getNodeMetrics(nodes);
            if (metricList != null) {
                Map metricses = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metricList).asScala()).map((Function1 & Serializable & scala.Serializable)m -> new Tuple2((Object)m.getServiceInstance().toString(), m), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
                    NodeHeartbeatMonitor.$anonfun$run$3(metricses, node);
                    return BoxedUnit.UNIT;
                });
            }
            Buffer engineNodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$run$5(this, x$1)));
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dealECNodes((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(engineNodes).asJava()), this.logger());
            Buffer ecmNodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$run$7(this, x$2)));
            this.dealECMNotExistsInRegistry((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(ecmNodes).asJava());
            this.logger().info("Finished to check the health of the node");
        }, this.logger());
    }

    private void dealECNodes(List<Node> engineNodes) {
        ServiceInstance[] existingEngineInstances = Sender$.MODULE$.getInstances(this.ecName());
        HashSet clearECSet = new HashSet();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(engineNodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)engineNode -> {
            boolean updateOverdue;
            if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)engineNode.getNodeStatus()))) {
                this.logger().info("{} is completed {}, will be remove", (Object)engineNode.getServiceInstance(), (Object)engineNode.getNodeStatus());
                return BoxesRunTime.boxToBoolean((boolean)clearECSet.add((Object)engineNode.getServiceInstance()));
            }
            boolean engineIsStarted = System.currentTimeMillis() - engineNode.getStartTime().getTime() > this.maxCreateInterval();
            long updateTime = engineNode.getUpdateTime() == null ? engineNode.getStartTime().getTime() : engineNode.getUpdateTime().getTime();
            boolean bl = updateOverdue = System.currentTimeMillis() - updateTime > this.maxUpdateInterval();
            if (engineNode.getNodeStatus() == null) {
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingEngineInstances)).contains((Object)engineNode.getServiceInstance()) && engineIsStarted) {
                    this.logger().warn("Failed to find instance {} from Service Registry prepare to kill, engineIsStarted", new Object[]{engineNode.getServiceInstance()});
                    return BoxesRunTime.boxToBoolean((boolean)clearECSet.add((Object)engineNode.getServiceInstance()));
                }
                return BoxedUnit.UNIT;
            }
            if (updateOverdue) {
                this.logger().warn("{} heartbeat updateOverdue", new Object[]{engineNode.getServiceInstance()});
                return BoxesRunTime.boxToBoolean((boolean)clearECSet.add((Object)engineNode.getServiceInstance()));
            }
            return BoxedUnit.UNIT;
        });
        clearECSet.foreach((Function1 & Serializable & scala.Serializable)instance -> {
            this.org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$clearEngineNode(instance);
            return BoxedUnit.UNIT;
        });
    }

    private void updateMetrics(Node node) {
        NodeMetrics metric = this.nodeMetricManagerPersistence().getNodeMetrics(node);
        if (metric != null) {
            node.setNodeStatus(NodeStatus.values()[Predef$.MODULE$.Integer2int(metric.getStatus())]);
            node.setUpdateTime(metric.getUpdateTime());
            return;
        }
    }

    private void dealECMNotExistsInRegistry(List<Node> ecmNodes) {
        ServiceInstance[] existingECMInstances = Sender$.MODULE$.getInstances(this.ecmName());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ecmNodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)ecm -> {
            NodeHeartbeatMonitor.$anonfun$dealECMNotExistsInRegistry$1(this, existingECMInstances, ecm);
            return BoxedUnit.UNIT;
        });
    }

    private void dealHealthyList(List<NodeMetrics> healthyList) {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (healthyList != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(healthyList).asScala()).foreach((Function1 & Serializable & scala.Serializable)nodeMetric -> {
                    NodeHeartbeatMonitor.$anonfun$dealHealthyList$2(this, nodeMetric);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }, this.logger());
    }

    private void dealUnHealthyList(List<NodeMetrics> unhealthyList) {
        Object object = new Object();
        try {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (unhealthyList == null) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(unhealthyList).asScala()).foreach((Function1 & Serializable & scala.Serializable)nodeMetric -> {
                    if (this.managerLabelService().isEM(nodeMetric.getServiceInstance())) {
                        List nodes = this.nodeManagerPersistence().getEngineNodeByEM(nodeMetric.getServiceInstance());
                        if (nodes == null || nodes.isEmpty()) {
                            this.triggerEMSuicide(nodeMetric.getServiceInstance());
                            return BoxedUnit.UNIT;
                        }
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
                            this.triggerEngineSuicide(node.getServiceInstance());
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    }
                    return this.fixedThreadPoll().submit(new Runnable(this, (NodeMetrics)nodeMetric){
                        private final /* synthetic */ NodeHeartbeatMonitor $outer;
                        private final NodeMetrics nodeMetric$2;

                        public void run() {
                            this.$outer.org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$clearEngineNode(this.nodeMetric$2.getServiceInstance());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nodeMetric$2 = nodeMetric$2;
                        }
                    });
                });
            }, this.logger());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dealStockAvailableList(List<NodeMetrics> stockAvailableList) {
        Object object = new Object();
        try {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (stockAvailableList == null) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stockAvailableList).asScala()).foreach((Function1 & Serializable & scala.Serializable)nodeMetric -> {
                    this.updateMetricHealthy(nodeMetric, NodeHealthy.StockUnavailable, "Manager believes that the EM is already in the StockUnAvailable state");
                    return BoxedUnit.UNIT;
                });
            }, this.logger());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dealStockUnAvailableList(List<NodeMetrics> stockUnAvailableList) {
        Object object = new Object();
        try {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (stockUnAvailableList == null) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stockUnAvailableList).asScala()).foreach((Function1 & Serializable & scala.Serializable)nodeMetric -> {
                    if (this.managerLabelService().isEM(nodeMetric.getServiceInstance())) {
                        List nodes = this.nodeManagerPersistence().getEngineNodeByEM(nodeMetric.getServiceInstance());
                        if (nodes == null || nodes.isEmpty()) {
                            this.updateMetricHealthy((NodeMetrics)nodeMetric, NodeHealthy.UnHealthy, "Manager believes that the EM is already in the Unhealthy state");
                            return BoxedUnit.UNIT;
                        }
                        return this.fixedThreadPoll().submit(new Runnable(this, nodes){
                            private final /* synthetic */ NodeHeartbeatMonitor $outer;
                            private final List nodes$1;

                            public void run() {
                                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.nodes$1).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
                                    $anon$2.$anonfun$run$8(this, node);
                                    return BoxedUnit.UNIT;
                                });
                            }

                            public static final /* synthetic */ void $anonfun$run$8($anon$2 $this, EngineNode node) {
                                $this.$outer.org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$triggerEMToStopEngine(node.getServiceInstance());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.nodes$1 = nodes$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$8$adapted(org.apache.linkis.manager.am.service.monitor.NodeHeartbeatMonitor$$anon$2 org.apache.linkis.manager.common.entity.node.EngineNode )}, serializedLambda);
                            }
                        });
                    }
                    return BoxedUnit.UNIT;
                });
            }, this.logger());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private List<NodeMetrics> filterHealthyAndWarnList(List<NodeMetrics> nodeMetrics) {
        long curTime = System.currentTimeMillis();
        long maxInterval = ((TimeType)ManagerMonitorConf.NODE_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodeMetrics).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$filterHealthyAndWarnList$1(this, curTime, maxInterval, metric)))).asJava();
    }

    private List<NodeMetrics> filterStockAvailableList(List<NodeMetrics> nodeMetrics) {
        long curTime = System.currentTimeMillis();
        long maxInterval = ((TimeType)ManagerMonitorConf.NODE_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodeMetrics).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$filterStockAvailableList$1(this, curTime, maxInterval, metric)))).asJava();
    }

    private List<NodeMetrics> filterStockUnAvailableList(List<NodeMetrics> nodeMetrics) {
        long curTime = System.currentTimeMillis();
        long maxInterval = ((TimeType)ManagerMonitorConf.NODE_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodeMetrics).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$filterStockUnAvailableList$1(this, curTime, maxInterval, metric)))).asJava();
    }

    private List<NodeMetrics> filterUnHealthyList(List<NodeMetrics> nodeMetrics) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodeMetrics).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)NodeHeartbeatMonitor.$anonfun$filterUnHealthyList$1(this, metric)))).asJava();
    }

    private void clearUnhealthyNode(OwnerNodeMetrics ownerNodeMetrics) {
        Sender sender = Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance());
        if (this.managerLabelService().isEM(ownerNodeMetrics.nodeMetrics().getServiceInstance())) {
            StopEMRequest stopEMRequest = new StopEMRequest();
            stopEMRequest.setEm(ownerNodeMetrics.nodeMetrics().getServiceInstance());
            stopEMRequest.setUser(ownerNodeMetrics.owner());
            this.emUnregisterService().stopEM(stopEMRequest, sender);
            return;
        }
        EngineStopRequest stopEngineRequest = new EngineStopRequest(ownerNodeMetrics.nodeMetrics().getServiceInstance(), ownerNodeMetrics.owner());
        this.engineStopService().stopEngine(stopEngineRequest, sender);
    }

    public void org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$clearEngineNode(ServiceInstance instance) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn(new StringBuilder(39).append("Manager Monitor prepare to kill engine ").append(instance).toString());
            EngineStopRequest stopEngineRequest = new EngineStopRequest(instance, ManagerUtils.getAdminUser());
            Sender sender = Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance());
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.engineStopService().stopEngine(stopEngineRequest, sender), (Function1 & Serializable & scala.Serializable)e -> {
                NodeHeartbeatMonitor.$anonfun$clearEngineNode$3(this, instance, e);
                return BoxedUnit.UNIT;
            });
        }, this.logger());
    }

    public void org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$triggerEMToStopEngine(ServiceInstance instance) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn(new StringBuilder(45).append("Manager Monitor prepare to kill engine ").append(instance).append(" by em").toString());
            EngineStopRequest stopEngineRequest = new EngineStopRequest(instance, ManagerUtils.getAdminUser());
            Sender sender = Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance());
            this.engineStopService().stopEngine(stopEngineRequest, sender);
        }, this.logger());
    }

    private void triggerEngineSuicide(ServiceInstance instance) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logger().warn(new StringBuilder(55).append("Manager Monitor prepare to triggerEngineSuicide engine ").append(instance).toString()), this.logger());
    }

    private void triggerEMSuicide(ServiceInstance instance) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().warn(new StringBuilder(35).append("Manager Monitor prepare to kill EM ").append(instance).toString());
            StopEMRequest stopEMRequest = new StopEMRequest();
            stopEMRequest.setEm(instance);
            stopEMRequest.setUser(ManagerUtils.getAdminUser());
            Sender sender = Sender$.MODULE$.getSender(Sender$.MODULE$.getThisServiceInstance());
            this.emUnregisterService().stopEM(stopEMRequest, sender);
        }, this.logger());
    }

    private void updateMetricHealthy(NodeMetrics nodeMetrics, NodeHealthy nodeHealthy, String reason) {
        this.logger().warn(new StringBuilder(26).append("update instance ").append(nodeMetrics.getServiceInstance()).append(" from ").append(nodeMetrics.getHealthy()).append(" to ").append(nodeHealthy).toString());
        NodeHealthyInfo nodeHealthyInfo = new NodeHealthyInfo();
        nodeHealthyInfo.setMsg(new StringBuilder(69).append("Manager-Monitor considers the node to be in UnHealthy state, reason: ").append(reason).toString());
        nodeHealthyInfo.setNodeHealthy(nodeHealthy);
        nodeMetrics.setHealthy(this.metricsConverter().convertHealthyInfo(nodeHealthyInfo));
        this.nodeMetricManagerPersistence().addOrupdateNodeMetrics(nodeMetrics);
    }

    private void dealMetricUpdateTimeOut(NodeMetrics nodeMetric, UndeclaredThrowableException e) {
        boolean timeout;
        long maxInterval = ((TimeType)ManagerMonitorConf.NODE_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
        boolean bl = timeout = System.currentTimeMillis() - nodeMetric.getUpdateTime().getTime() > maxInterval;
        if (timeout) {
            this.logger().warn(new StringBuilder(134).append("The engine failed to send the RPC request, and the engine instance could not be found: ").append(nodeMetric.getServiceInstance()).append(", ").append("start sending the request to stop the engine!").toString(), (Throwable)e);
            this.org$apache$linkis$manager$am$service$monitor$NodeHeartbeatMonitor$$triggerEMToStopEngine(nodeMetric.getServiceInstance());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$run$4(Node node$1, NodeMetrics metrics) {
        node$1.setNodeStatus(NodeStatus.values()[Predef$.MODULE$.Integer2int(metrics.getStatus())]);
        node$1.setUpdateTime(metrics.getUpdateTime());
    }

    public static final /* synthetic */ void $anonfun$run$3(Map metricses$1, Node node) {
        metricses$1.get((Object)node.getServiceInstance().toString()).foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            NodeHeartbeatMonitor.$anonfun$run$4(node, metrics);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$run$5(NodeHeartbeatMonitor $this, Node x$1) {
        return x$1.getServiceInstance().getApplicationName().equalsIgnoreCase($this.ecName());
    }

    public static final /* synthetic */ boolean $anonfun$run$7(NodeHeartbeatMonitor $this, Node x$2) {
        return x$2.getServiceInstance().getApplicationName().equalsIgnoreCase($this.ecmName());
    }

    public static final /* synthetic */ void $anonfun$dealECMNotExistsInRegistry$1(NodeHeartbeatMonitor $this, ServiceInstance[] existingECMInstances$1, Node ecm) {
        boolean updateOverdue;
        long updateTime = ecm.getUpdateTime() == null ? ecm.getStartTime().getTime() : ecm.getUpdateTime().getTime();
        boolean bl = updateOverdue = System.currentTimeMillis() - updateTime > $this.ecmHeartBeatTime();
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingECMInstances$1)).contains((Object)ecm.getServiceInstance()) && updateOverdue) {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.updateMetrics(ecm), $this.logger());
            boolean isUpdateOverdue = ecm.getUpdateTime() == null ? System.currentTimeMillis() - ecm.getStartTime().getTime() > $this.ecmHeartBeatTime() : System.currentTimeMillis() - ecm.getUpdateTime().getTime() > $this.ecmHeartBeatTime();
            boolean isExistingECMInstances = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Sender$.MODULE$.getInstances($this.ecmName()))).contains((Object)ecm.getServiceInstance());
            if (!isExistingECMInstances && isUpdateOverdue) {
                $this.logger().warn("Failed to find ecm instance {} from Service Registry to kill", new Object[]{ecm.getServiceInstance()});
                Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.triggerEMSuicide(ecm.getServiceInstance()), new StringBuilder(17).append("ecm ").append(ecm.getServiceInstance()).append(" clear failed").toString(), $this.logger());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$dealHealthyList$4(NodeHeartbeatMonitor $this, NodeMetrics nodeMetric$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)throwable;
            $this.dealMetricUpdateTimeOut(nodeMetric$1, undeclaredThrowableException);
            return;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().warn(new StringBuilder(121).append("heartbeat RPC request failed, but it is not caused by timeout, ").append("the engine will not be forcibly stopped, engine instance: ").append(nodeMetric$1.getServiceInstance()).toString(), (Throwable)exception);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$dealHealthyList$2(NodeHeartbeatMonitor $this, NodeMetrics nodeMetric) {
        ObjectRef sender = ObjectRef.create(null);
        try {
            sender.elem = Sender$.MODULE$.getSender(nodeMetric.getServiceInstance());
        }
        catch (NoInstanceExistsException n) {
            $this.updateMetricHealthy(nodeMetric, NodeHealthy.UnHealthy, "NoInstanceExistsException");
        }
        if ((Sender)sender.elem == null) {
            $this.updateMetricHealthy(nodeMetric, NodeHealthy.UnHealthy, "sender is null");
        }
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object = ((Sender)sender$1.elem).ask((Object)new NodeHeartbeatRequest());
            if (object instanceof NodeHeartbeatMsg) {
                NodeHeartbeatMsg nodeHeartbeatMsg = (NodeHeartbeatMsg)object;
                if (!Predef$.MODULE$.Boolean2boolean(NodeHealthy.isAvailable((NodeHealthy)nodeHeartbeatMsg.getHealthyInfo().getNodeHealthy())) && $this.managerLabelService().isEngine(nodeMetric.getServiceInstance())) {
                    $this.updateMetricHealthy(nodeMetric, NodeHealthy.UnHealthy, "ec is Unhealthy");
                    return;
                }
                $this.amHeartbeatService().heartbeatEventDeal(nodeHeartbeatMsg);
                return;
            }
            $this.updateMetricHealthy(nodeMetric, NodeHealthy.UnHealthy, "sender is null");
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            NodeHeartbeatMonitor.$anonfun$dealHealthyList$4($this, nodeMetric, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$filterHealthyAndWarnList$1(NodeHeartbeatMonitor $this, long curTime$1, long maxInterval$1, NodeMetrics metric) {
        long interval = curTime$1 - metric.getUpdateTime().getTime();
        if (interval > maxInterval$1) {
            NodeHealthy healthy = $this.metricsConverter().parseHealthyInfo(metric).getNodeHealthy();
            return NodeHealthy.Healthy.equals(healthy) || NodeHealthy.WARN.equals(healthy);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$filterStockAvailableList$1(NodeHeartbeatMonitor $this, long curTime$2, long maxInterval$2, NodeMetrics metric) {
        long interval = curTime$2 - metric.getUpdateTime().getTime();
        if (interval > maxInterval$2) {
            NodeHealthy healthy = $this.metricsConverter().parseHealthyInfo(metric).getNodeHealthy();
            return NodeHealthy.StockAvailable.equals(healthy);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$filterStockUnAvailableList$1(NodeHeartbeatMonitor $this, long curTime$3, long maxInterval$3, NodeMetrics metric) {
        long interval = curTime$3 - metric.getUpdateTime().getTime();
        if (interval > maxInterval$3) {
            NodeHealthy healthy = $this.metricsConverter().parseHealthyInfo(metric).getNodeHealthy();
            return NodeHealthy.StockUnavailable.equals(healthy);
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$filterUnHealthyList$1(NodeHeartbeatMonitor $this, NodeMetrics metric) {
        NodeHealthy healthy = $this.metricsConverter().parseHealthyInfo(metric).getNodeHealthy();
        return NodeHealthy.UnHealthy.equals(healthy);
    }

    public static final /* synthetic */ void $anonfun$clearEngineNode$3(NodeHeartbeatMonitor $this, ServiceInstance instance$1, Throwable e) {
        $this.logger().error(new StringBuilder(25).append("Em failed to kill engine ").append(instance$1).toString(), e);
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.triggerEngineSuicide(instance$1), $this.logger());
    }

    public NodeHeartbeatMonitor() {
        Logging.$init$((Logging)this);
        this.fixedThreadPoll = Utils$.MODULE$.newFixedThreadPool(Predef$.MODULE$.Integer2int((Integer)ManagerMonitorConf.MANAGER_MONITOR_ASYNC_POLL_SIZE.getValue()), "manager_async", false);
        this.ecName = (String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_SPRING_NAME().getValue();
        this.ecmName = (String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_MANAGER_SPRING_NAME().getValue();
        this.maxCreateInterval = ((TimeType)ManagerMonitorConf.NODE_MAX_CREATE_TIME.getValue()).toLong();
        this.maxUpdateInterval = ((TimeType)ManagerMonitorConf.NODE_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
        this.ecmHeartBeatTime = ((TimeType)ManagerMonitorConf.ECM_HEARTBEAT_MAX_UPDATE_TIME.getValue()).toLong();
    }
}

