/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.plugin.spark.authz.util;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.plugin.spark.authz.AccessControlException;
import org.apache.kyuubi.plugin.spark.authz.AccessControlException$;
import org.apache.kyuubi.util.SemanticVersion;
import org.apache.kyuubi.util.SemanticVersion$;
import org.apache.kyuubi.util.reflect.DynConstructors;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.spark.SparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Properties$;

public final class AuthZUtils$ {
    public static AuthZUtils$ MODULE$;
    private boolean isRanger21orGreater;
    private SemanticVersion SPARK_RUNTIME_VERSION;
    private boolean isSparkV32OrGreater;
    private boolean isSparkV33OrGreater;
    private boolean isSparkV34OrGreater;
    private boolean isSparkV35OrGreater;
    private boolean isSparkV40OrGreater;
    private SemanticVersion SCALA_RUNTIME_VERSION;
    private boolean isScalaV212;
    private boolean isScalaV213;
    private volatile int bitmap$0;

    static {
        new AuthZUtils$();
    }

    public UserGroupInformation getAuthzUgi(SparkContext spark) {
        boolean isSessionUserVerifyEnabled = spark.getConf().getBoolean(new StringBuilder(38).append("spark.").append("kyuubi.session.user.sign.enabled").toString(), false);
        String user = spark.getLocalProperty("kyuubi.session.user");
        if (isSessionUserVerifyEnabled) {
            this.verifyKyuubiSessionUser(spark, user);
        }
        if (user != null) {
            String string = user;
            String string2 = UserGroupInformation.getCurrentUser().getShortUserName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return UserGroupInformation.createRemoteUser((String)user);
            }
        }
        return UserGroupInformation.getCurrentUser();
    }

    public boolean hasResolvedPermanentView(LogicalPlan plan) {
        View view;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof View && (view = (View)logicalPlan).resolved()) {
            return !BoxesRunTime.unboxToBoolean((Object)ReflectUtils$.MODULE$.getField((Object)view, "isTempView"));
        }
        return false;
    }

    private boolean isRanger21orGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isRanger21orGreater = AuthZUtils$.liftedTree1$1();
                this.bitmap$0 |= 1;
            }
        }
        return this.isRanger21orGreater;
    }

    public boolean isRanger21orGreater() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.isRanger21orGreater$lzycompute();
        }
        return this.isRanger21orGreater;
    }

    private SemanticVersion SPARK_RUNTIME_VERSION$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.SPARK_RUNTIME_VERSION = SemanticVersion$.MODULE$.apply(package$.MODULE$.SPARK_VERSION());
                this.bitmap$0 |= 2;
            }
        }
        return this.SPARK_RUNTIME_VERSION;
    }

    public SemanticVersion SPARK_RUNTIME_VERSION() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.SPARK_RUNTIME_VERSION$lzycompute();
        }
        return this.SPARK_RUNTIME_VERSION;
    }

    private boolean isSparkV32OrGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.isSparkV32OrGreater = this.SPARK_RUNTIME_VERSION().$greater$eq("3.2");
                this.bitmap$0 |= 4;
            }
        }
        return this.isSparkV32OrGreater;
    }

    public boolean isSparkV32OrGreater() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.isSparkV32OrGreater$lzycompute();
        }
        return this.isSparkV32OrGreater;
    }

    private boolean isSparkV33OrGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.isSparkV33OrGreater = this.SPARK_RUNTIME_VERSION().$greater$eq("3.3");
                this.bitmap$0 |= 8;
            }
        }
        return this.isSparkV33OrGreater;
    }

    public boolean isSparkV33OrGreater() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.isSparkV33OrGreater$lzycompute();
        }
        return this.isSparkV33OrGreater;
    }

    private boolean isSparkV34OrGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.isSparkV34OrGreater = this.SPARK_RUNTIME_VERSION().$greater$eq("3.4");
                this.bitmap$0 |= 0x10;
            }
        }
        return this.isSparkV34OrGreater;
    }

    public boolean isSparkV34OrGreater() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.isSparkV34OrGreater$lzycompute();
        }
        return this.isSparkV34OrGreater;
    }

    private boolean isSparkV35OrGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.isSparkV35OrGreater = this.SPARK_RUNTIME_VERSION().$greater$eq("3.5");
                this.bitmap$0 |= 0x20;
            }
        }
        return this.isSparkV35OrGreater;
    }

    public boolean isSparkV35OrGreater() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.isSparkV35OrGreater$lzycompute();
        }
        return this.isSparkV35OrGreater;
    }

    private boolean isSparkV40OrGreater$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.isSparkV40OrGreater = this.SPARK_RUNTIME_VERSION().$greater$eq("4.0");
                this.bitmap$0 |= 0x40;
            }
        }
        return this.isSparkV40OrGreater;
    }

    public boolean isSparkV40OrGreater() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.isSparkV40OrGreater$lzycompute();
        }
        return this.isSparkV40OrGreater;
    }

    private SemanticVersion SCALA_RUNTIME_VERSION$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SCALA_RUNTIME_VERSION = SemanticVersion$.MODULE$.apply(Properties$.MODULE$.versionNumberString());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SCALA_RUNTIME_VERSION;
    }

    public SemanticVersion SCALA_RUNTIME_VERSION() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.SCALA_RUNTIME_VERSION$lzycompute();
        }
        return this.SCALA_RUNTIME_VERSION;
    }

    private boolean isScalaV212$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.isScalaV212 = this.SCALA_RUNTIME_VERSION().$eq$eq$eq("2.12");
                this.bitmap$0 |= 0x100;
            }
        }
        return this.isScalaV212;
    }

    public boolean isScalaV212() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.isScalaV212$lzycompute();
        }
        return this.isScalaV212;
    }

    private boolean isScalaV213$lzycompute() {
        AuthZUtils$ authZUtils$ = this;
        synchronized (authZUtils$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.isScalaV213 = this.SCALA_RUNTIME_VERSION().$eq$eq$eq("2.13");
                this.bitmap$0 |= 0x200;
            }
        }
        return this.isScalaV213;
    }

    public boolean isScalaV213() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.isScalaV213$lzycompute();
        }
        return this.isScalaV213;
    }

    public String derbyJdbcDriverClass() {
        if (this.isSparkV40OrGreater()) {
            return "org.apache.derby.iapi.jdbc.AutoloadedDriver";
        }
        return "org.apache.derby.jdbc.AutoloadedDriver";
    }

    public String quoteIfNeeded(String part) {
        if (part.matches("[a-zA-Z0-9_]+") && !part.matches("\\d+")) {
            return part;
        }
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    public String quote(Seq<String> parts) {
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    private void verifyKyuubiSessionUser(SparkContext spark, String user) {
        try {
            String userPubKeyBase64 = spark.getLocalProperty("kyuubi.session.sign.publickey");
            String userSignBase64 = spark.getLocalProperty("kyuubi.session.user.sign");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{user, userPubKeyBase64, userSignBase64})) {
                throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
            }
            if (!this.verifySignWithECDSA(user, userSignBase64, userPubKeyBase64)) {
                throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
            }
        }
        catch (Exception exception) {
            throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
        }
    }

    private boolean verifySignWithECDSA(String plainText, String signatureBase64, String publicKeyBase64) {
        byte[] pubKeyBytes = Base64.getDecoder().decode(publicKeyBase64);
        ECPublicKey publicKey = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(pubKeyBytes));
        Signature publicSignature = Signature.getInstance("SHA256withECDSA");
        publicSignature.initVerify(publicKey);
        publicSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
        return publicSignature.verify(signatureBytes);
    }

    private static final /* synthetic */ boolean liftedTree1$1() {
        boolean bl;
        try {
            DynConstructors.builder().impl(RangerBasePlugin.class, new Class[]{String.class, String.class, String.class}).buildChecked();
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        return bl;
    }

    private static final Nothing$ illegalAccessWithUnverifiedUser$1(String user$1) {
        throw new AccessControlException(new StringBuilder(26).append("Invalid user identifier [").append(user$1).append("]").toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
    }

    private AuthZUtils$() {
        MODULE$ = this;
    }
}

