/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticFilesChecker {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");

    private DiagnosticFilesChecker() {
    }

    public static synchronized void writeMsgToFile(String msg, Long time, File file) {
        String interruptString = Thread.currentThread().isInterrupted() ? "(INTERRUPT)" : "";
        String content = String.format(Locale.ROOT, "TIME OF EXTRACT %s %s: %dms", msg, interruptString, time);
        logger.info(content);
        String charsetName = Charset.defaultCharset().name();
        try (FileOutputStream fos = new FileOutputStream(file, true);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, charsetName));){
            writer.write(content);
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void writeMsgToFile(String msg, File file) {
        String charsetName = Charset.defaultCharset().name();
        try (FileOutputStream fos = new FileOutputStream(file, true);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, charsetName));){
            writer.write(msg);
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

