/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableCleaner
extends MetadataCleaner {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableCleaner.class);

    public ExecutableCleaner(String project) {
        super(project);
    }

    @Override
    public void beforeExecute() {
    }

    @Override
    public void execute() {
        logger.info("Start to clean executable in project {}", (Object)this.project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        long expirationTime = config.getExecutableSurvivalTimeThreshold();
        ExecutableManager executableManager = ExecutableManager.getInstance((KylinConfig)config, (String)this.project);
        List finalExecutablePOs = executableManager.getExecutablePOsByStatus((List)Lists.newArrayList((Object[])ExecutableState.getFinalStates()));
        List filteredExecutables = finalExecutablePOs.stream().filter(executablePO -> {
            AbstractExecutable job = executableManager.fromPO(executablePO);
            if (System.currentTimeMillis() - AbstractExecutable.getCreateTime((Output)job.getOutput(executablePO)) < expirationTime) {
                return false;
            }
            ExecutableState state = job.getStatusInMem();
            return state.isFinalState();
        }).map(arg_0 -> ((ExecutableManager)executableManager).fromPO(arg_0)).collect(Collectors.toList());
        ArrayList<String> jobsToBeDelete = new ArrayList<String>();
        for (AbstractExecutable executable : filteredExecutables) {
            jobsToBeDelete.add(executable.getJobId());
        }
        if (jobsToBeDelete.isEmpty()) {
            logger.info("No executables need to clean in project {}", (Object)this.project);
            return;
        }
        executableManager.deleteJobByIdList(jobsToBeDelete);
        logger.info("Clean executable in project {} finished", (Object)this.project);
    }

    @Override
    public void afterExecute() {
    }
}

