/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.setup;

import com.alibaba.nacos.common.JustForTest;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnResourceInfoTool {
    private static final Logger logger = LoggerFactory.getLogger(YarnResourceInfoTool.class);
    private static final String AVAILABLE_VIRTUAL_CORE = "availableVirtualCores";
    private static final String AVAILABLE_MEMORY = "availableMB";
    private Configuration configuration = YarnResourceInfoTool.initConfiguration(HadoopUtil.getHadoopConfDir());
    private YarnClient yarnClient;

    public YarnResourceInfoTool() {
        YarnResourceInfoTool.initKerberosENV(this.configuration);
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(this.configuration);
        this.yarnClient.start();
    }

    @JustForTest
    public YarnResourceInfoTool(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    public Map<String, Integer> getYarnResourceInfoByQueueName(String queue) throws IOException, YarnException {
        int availableMB = 0;
        int availableVirtualCores = 0;
        HashMap<String, Integer> clusterMetricsMap = new HashMap<String, Integer>();
        QueueInfo queueInfo = this.yarnClient.getQueueInfo(queue);
        if (queueInfo == null) {
            return Collections.emptyMap();
        }
        availableMB = (int)((long)availableMB + queueInfo.getQueueStatistics().getAvailableMemoryMB());
        availableVirtualCores = (int)((long)availableVirtualCores + queueInfo.getQueueStatistics().getAvailableVCores());
        clusterMetricsMap.put(AVAILABLE_MEMORY, availableMB);
        clusterMetricsMap.put(AVAILABLE_VIRTUAL_CORE, availableVirtualCores);
        logger.info("yarn-client get Queue:{} metrics response: availableMB:{} availableVirtualCores:{}", new Object[]{queue, availableMB, availableVirtualCores});
        this.yarnClient.close();
        return clusterMetricsMap;
    }

    public Map<String, Integer> getYarnResourceInfo() throws IOException, YarnException {
        int availableMB = 0;
        int availableVirtualCores = 0;
        HashMap<String, Integer> clusterMetricsMap = new HashMap<String, Integer>();
        List rootQueueInfos = this.yarnClient.getRootQueueInfos();
        for (QueueInfo rootInfo : rootQueueInfos) {
            availableMB = (int)((long)availableMB + rootInfo.getQueueStatistics().getAvailableMemoryMB());
            availableVirtualCores = (int)((long)availableVirtualCores + rootInfo.getQueueStatistics().getAvailableVCores());
        }
        clusterMetricsMap.put(AVAILABLE_MEMORY, availableMB);
        clusterMetricsMap.put(AVAILABLE_VIRTUAL_CORE, availableVirtualCores);
        logger.info("yarn-client get the whole cluster metrics response: availableMB:{} availableVirtualCores:{}", (Object)availableMB, (Object)availableVirtualCores);
        this.yarnClient.close();
        return clusterMetricsMap;
    }

    public static Configuration initConfiguration(String confPath) {
        confPath = System.getProperty("kylin.hadoop.conf.dir", confPath);
        logger.info("-------------> hadoop conf dir: {}", (Object)confPath);
        Configuration configuration = new Configuration();
        configuration.addResource(new Path(Paths.get(confPath, "core-site.xml").toString()));
        configuration.addResource(new Path(Paths.get(confPath, "hdfs-site.xml").toString()));
        configuration.addResource(new Path(Paths.get(confPath, "yarn-site.xml").toString()));
        return configuration;
    }

    public static void initKerberosENV(Configuration conf) {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        Unsafe.setProperty((String)"java.security.krb5.conf", (String)kapConfig.getKerberosKrb5ConfPath());
        Unsafe.setProperty((String)"javax.security.auth.useSubjectCredsOnly", (String)"false");
        Unsafe.setProperty((String)"sun.security.krb5.debug", (String)"false");
        logger.info("Init Kerberos with Principal:{}, Krb5Conf:{} and KeytabPath:{}", new Object[]{kapConfig.getKerberosPrincipal(), kapConfig.getKerberosKrb5ConfPath(), kapConfig.getKerberosKeytabPath()});
        try {
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)kapConfig.getKerberosPrincipal(), (String)kapConfig.getKerberosKeytabPath());
        }
        catch (IOException e) {
            logger.error("Failed init Kerberos", (Throwable)e);
        }
    }
}

