/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.metadata.upgrade.GlobalAclVersionManager;
import org.apache.kylin.tool.util.LdapUtils;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

public class UpdateUserAclToolHelper {
    private UpdateUserAclToolHelper() {
    }

    public static UpdateUserAclToolHelper getInstance() {
        return new UpdateUserAclToolHelper();
    }

    public Set<String> getLdapAdminUsers() {
        SpringSecurityLdapTemplate ldapTemplate = this.createLdapTemplate();
        Set<String> ldapUserDNs = LdapUtils.getAllGroupMembers(ldapTemplate, KylinConfig.getInstanceFromEnv().getLDAPAdminRole());
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Map<String, String> dnMapperMap = LdapUtils.getAllValidUserDnMap(ldapTemplate, searchControls);
        HashSet<String> users = new HashSet<String>();
        for (String u : ldapUserDNs) {
            Optional.ofNullable(dnMapperMap.get(u)).ifPresent(users::add);
        }
        return users;
    }

    private SpringSecurityLdapTemplate createLdapTemplate() {
        Properties properties = KylinConfig.getInstanceFromEnv().exportToProperties();
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(properties.getProperty("kylin.security.ldap.connection-server"));
        contextSource.setUserDn(properties.getProperty("kylin.security.ldap.connection-username"));
        contextSource.setPassword(this.getPassword(properties));
        contextSource.afterPropertiesSet();
        return new SpringSecurityLdapTemplate((ContextSource)contextSource);
    }

    public String getPassword(Properties properties) {
        String password = properties.getProperty("kylin.security.ldap.connection-password");
        return EncryptUtil.decrypt((String)password);
    }

    public boolean isUpgraded() {
        GlobalAclVersionManager versionManager = GlobalAclVersionManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        return versionManager.exists();
    }
}

