/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataParser<I>
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataParser.class);

    public static <I> AbstractDataParser<I> getDataParser(String parserPath, ClassLoader classLoader) throws ReflectiveOperationException {
        if (StringUtils.isEmpty((CharSequence)parserPath)) {
            throw new IllegalStateException("Invalid parserName " + parserPath);
        }
        Class<?> clazz = Class.forName(parserPath, true, classLoader);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object instance = constructor.newInstance(new Object[0]);
        if (!(instance instanceof AbstractDataParser)) {
            throw new IllegalStateException(parserPath + " does not extends from AbstractDataParser");
        }
        return (AbstractDataParser)instance;
    }

    protected AbstractDataParser() {
    }

    public Map<String, Object> process(I input) {
        this.before();
        if (Objects.isNull(input)) {
            log.error("input data is null ...");
            return Collections.emptyMap();
        }
        return this.after(this.parse(input));
    }

    protected void before() {
    }

    protected abstract Map<String, Object> parse(I var1);

    protected Map<String, Object> after(Map<String, Object> parseMap) {
        return parseMap;
    }

    protected Map<String, Object> defineDataTypes() {
        return Collections.emptyMap();
    }
}

