/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.CachedRowSet;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.SupportsSparkCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcExplorer
implements ISourceMetadataExplorer,
ISampleDataDeployer,
SupportsSparkCatalog,
Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcExplorer.class);
    private JdbcConnector dataSource;

    public JdbcExplorer(JdbcConnector dataSource) {
        this.dataSource = dataSource;
    }

    public static boolean isPrecisionApplicable(String typeName) {
        return JdbcExplorer.isScaleApplicable(typeName) || DataType.STRING_FAMILY.contains(typeName);
    }

    public static boolean isScaleApplicable(String typeName) {
        return typeName.equals("decimal") || typeName.equals("numeric");
    }

    public void createSampleDatabase(String database) throws Exception {
        String[] sql = this.dataSource.buildSqlToCreateSchema(database);
        this.dataSource.executeUpdate(sql);
    }

    public void createSampleTable(TableDesc table) throws Exception {
        LinkedHashMap columnInfo = Maps.newLinkedHashMap();
        for (ColumnDesc columnDesc : table.getColumns()) {
            columnInfo.put(columnDesc.getName(), columnDesc.getTypeName());
        }
        String[] sqls = this.dataSource.buildSqlToCreateTable(table.getIdentity(), columnInfo);
        this.dataSource.executeUpdate(sqls);
    }

    public void loadSampleData(String tableName, String tmpDataDir) {
        throw new UnsupportedOperationException("Unsupported load sample data");
    }

    public void createWrapperView(String origTableName, String viewName) {
        throw new UnsupportedOperationException("Unsupported create wrapper view");
    }

    public List<String> listDatabases() throws Exception {
        List databases = this.dataSource.listDatabases();
        if (KylinConfig.getInstanceFromEnv().isDDLLogicalViewEnabled()) {
            String logicalViewDB = KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB();
            databases.forEach(db -> {
                if (db.equalsIgnoreCase(logicalViewDB)) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DDL_CHECK_ERROR, "Logical view database should not be duplicated with normal hive database!!!");
                }
            });
            ArrayList databasesWithLogicalDB = Lists.newArrayList();
            databasesWithLogicalDB.add(logicalViewDB);
            databasesWithLogicalDB.addAll(databases);
            databases = databasesWithLogicalDB;
        }
        return databases;
    }

    public static boolean isJdbcLogicalViewDataBase(String database) {
        String logicalViewDB = KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB();
        return database.equals(logicalViewDB) && KylinConfig.getInstanceFromEnv().isDDLLogicalViewEnabled();
    }

    public List<String> listTables(String database) throws Exception {
        if (JdbcExplorer.isJdbcLogicalViewDataBase(database)) {
            return SourceFactory.getSparkSource().getSourceMetadataExplorer().listTables(database);
        }
        return this.dataSource.listTables(database);
    }

    public Pair<TableDesc, TableExtDesc> loadTableMetadata(String database, String table, String prj) throws Exception {
        if (JdbcExplorer.isJdbcLogicalViewDataBase(database)) {
            Pair pair = SourceFactory.getSparkSource().getSourceMetadataExplorer().loadTableMetadata(database, table, prj);
            ((TableDesc)pair.getFirst()).setSourceType(8);
            return pair;
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager metaMgr = NTableMetadataManager.getInstance((KylinConfig)config, (String)prj);
        TableDesc tableDesc = metaMgr.getTableDesc(database + "." + table);
        if (tableDesc == null) {
            tableDesc = new TableDesc();
            tableDesc.setDatabase(database);
            tableDesc.setName(table);
            tableDesc.setLastModified(0L);
        } else {
            tableDesc = new TableDesc(tableDesc);
        }
        tableDesc.setSourceType(8);
        tableDesc.init(prj);
        CachedRowSet tables = this.dataSource.getTable(database, table);
        String tableType = null;
        while (tables.next()) {
            tableType = tables.getString("TABLE_TYPE");
        }
        if (tableType == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "table %s not found in schema:%s", table, database));
        }
        tableDesc.setTableType(tableType);
        CachedRowSet columns = this.dataSource.listColumns(database, table);
        ArrayList columnDescs = Lists.newArrayList();
        while (columns.next()) {
            String cname = columns.getString("COLUMN_NAME");
            int type = columns.getInt("DATA_TYPE");
            int csize = columns.getInt("COLUMN_SIZE");
            int digits = columns.getInt("DECIMAL_DIGITS");
            int pos = columns.getInt("ORDINAL_POSITION");
            String remarks = columns.getString("REMARKS");
            ColumnDesc columnDesc = new ColumnDesc();
            columnDesc.setName(cname.toUpperCase(Locale.ROOT));
            columnDesc.setCaseSensitiveName(cname);
            String kylinType = this.dataSource.toKylinTypeName(type);
            if ("any".equals(kylinType)) {
                String typeName = columns.getString("TYPE_NAME");
                int kylinTypeId = this.dataSource.toKylinTypeId(typeName, type);
                kylinType = this.dataSource.toKylinTypeName(kylinTypeId);
            }
            int precision = JdbcExplorer.isPrecisionApplicable(kylinType) && csize >= 0 ? csize : -1;
            precision = Math.min(precision, KylinConfig.getInstanceFromEnv().getDefaultVarcharPrecision());
            int scale = JdbcExplorer.isScaleApplicable(kylinType) && digits >= 0 ? digits : -1;
            columnDesc.setDatatype(new DataType(kylinType, precision, scale).toString());
            columnDesc.setId(String.valueOf(pos));
            columnDesc.setComment(remarks);
            columnDescs.add(columnDesc);
        }
        tableDesc.setColumns(columnDescs.toArray(new ColumnDesc[columnDescs.size()]));
        TableExtDesc tableExtDesc = new TableExtDesc();
        tableExtDesc.setIdentity(tableDesc.getIdentity());
        tableExtDesc.setLastModified(0L);
        tableExtDesc.init(prj);
        return Pair.newPair((Object)tableDesc, (Object)tableExtDesc);
    }

    public List<String> getRelatedKylinResources(TableDesc table) {
        return Collections.emptyList();
    }

    public boolean checkDatabaseAccess(String database) {
        return true;
    }

    public boolean checkTablesAccess(Set<String> tables) {
        return true;
    }

    public Set<String> getTablePartitions(String database, String table, String prj, String partitionCols) {
        throw new UnsupportedOperationException();
    }

    public String addCatalog(KylinConfig kylinConfig, String sql, String project) {
        return this.dataSource.addCatalog(kylinConfig, sql, project);
    }

    public Map<String, String> getSourceCatalogConf(KylinConfig kylinConfig, String project) {
        return this.dataSource.getSourceCatalogConf(kylinConfig, project);
    }
}

