/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;
import org.apache.kylin.source.jdbc.ISourceConnector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class DefaultSourceConnector
extends DefaultAdaptor
implements ISourceConnector {
    public DefaultSourceConnector(AdaptorConfig config) throws Exception {
        super(config);
    }

    public DefaultSourceConnector() {
    }

    @Override
    public Dataset<Row> getSourceData(KylinConfig kylinConfig, SparkSession sparkSession, String sql, Map<String, String> params) {
        String url = kylinConfig.getJdbcConnectionUrl();
        String user = kylinConfig.getJdbcUser();
        String password = kylinConfig.getJdbcPass();
        String driver = kylinConfig.getJdbcDriver();
        return sparkSession.read().format("jdbc").option("url", url).option("user", user).option("password", password).option("driver", driver).option("query", sql).options(params).load();
    }

    @Override
    public Dataset<Row> getCountData(KylinConfig kylinConfig, SparkSession sparkSession, String sql, Map<String, String> params) {
        return this.getSourceData(kylinConfig, sparkSession, sql, params);
    }
}

