/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.rest.service.QueryHistoryScheduler;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
@Order(value=-200)
public class QueryInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryInterceptor.class);

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        long responseStartTime;
        long start = System.currentTimeMillis();
        String queryExecutionID = QueryContext.current().getExecutionID();
        if (!Strings.isNullOrEmpty((String)queryExecutionID)) {
            SparderEnv.deleteQueryTaskResultBlock((String)queryExecutionID);
        }
        if ((responseStartTime = QueryContext.current().getResponseStartTime()) > 0L) {
            String queryId = QueryContext.current().getQueryId();
            long responseTime = System.currentTimeMillis() - responseStartTime;
            log.info("Query[{}] record QUERY_RESPONSE_TIME [{}]", (Object)queryId, (Object)responseTime);
            QueryMetrics queryMetrics = new QueryMetrics(queryId);
            QueryHistoryInfo info = new QueryHistoryInfo();
            info.getTraces().add(new QueryHistoryInfo.QueryTraceSpan("QUERY_RESPONSE_TIME", null, responseTime));
            queryMetrics.setQueryHistoryInfo(info);
            queryMetrics.setUpdateMetrics(true);
            QueryHistoryScheduler queryHistoryScheduler = QueryHistoryScheduler.getInstance();
            queryHistoryScheduler.offerQueryHistoryQueue(queryMetrics);
        }
        QueryContext.current().close();
        log.debug("QueryInterceptor use time [{}]ms", (Object)(System.currentTimeMillis() - start));
    }
}

