/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AclPermissionUtil {
    private AclPermissionUtil() {
        throw new IllegalStateException("Class AclPermissionUtil is an utility class !");
    }

    public static List<String> transformAuthorities(Collection<? extends GrantedAuthority> authorities) {
        HashSet<String> groups = new HashSet<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            groups.add(grantedAuthority.getAuthority());
        }
        ArrayList<String> ret = new ArrayList<String>(groups);
        return ret;
    }

    public static Set<String> getCurrentUserGroups() {
        HashSet<String> groups = new HashSet<String>();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return groups;
        }
        Collection authorities = auth.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            groups.add(authority.getAuthority());
        }
        return groups;
    }

    public static String getCurUser() {
        return SecurityContextHolder.getContext().getAuthentication().toString();
    }
}

