/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.CsvColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.request.HiveTableRequest;
import org.apache.kylin.rest.service.TableACLService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/tables"})
public class TableController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(TableController.class);
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    @Qualifier(value="TableAclService")
    private TableACLService tableACLService;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<TableDesc> getTableDesc(@RequestParam(value="ext", required=false) boolean withExt, @RequestParam(value="project", required=true) String project) throws IOException {
        try {
            return this.tableService.getTableDescByProject(project, withExt);
        }
        catch (IOException e) {
            logger.error("Failed to get Hive Tables", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{project}/{tableName:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public TableDesc getTableDesc(@PathVariable String tableName, @PathVariable String project) {
        TableDesc table = this.tableService.getTableDescByName(tableName, false, project);
        if (table == null) {
            throw new NotFoundException("Could not find Hive table: " + tableName);
        }
        return table;
    }

    @RequestMapping(value={"/{tables}/{project}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Map<String, String[]> loadHiveTables(@PathVariable String tables, @PathVariable String project, @RequestBody HiveTableRequest request) throws IOException {
        String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String[] tableNames = StringUtil.splitAndTrim((String)tables, (String)",");
        try {
            String[] loaded = this.tableService.loadHiveTablesToProject(tableNames, project);
            result.put("result.loaded", loaded);
            HashSet<String> allTables = new HashSet<String>();
            for (String tableName : tableNames) {
                allTables.add(this.tableService.normalizeHiveTableName(tableName));
            }
            for (String loadedTableName : loaded) {
                allTables.remove(loadedTableName);
            }
            String[] unloaded = new String[allTables.size()];
            allTables.toArray(unloaded);
            result.put("result.unloaded", unloaded);
        }
        catch (Throwable e) {
            logger.error("Failed to load Hive Table", e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    @RequestMapping(value={"/{tables}/{project}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public Map<String, String[]> unLoadHiveTables(@PathVariable String tables, @PathVariable String project) {
        HashSet unLoadSuccess = Sets.newHashSet();
        HashSet unLoadFail = Sets.newHashSet();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        try {
            for (String tableName : StringUtil.splitByComma((String)tables)) {
                this.tableACLService.deleteFromTableACLByTbl(project, tableName);
                if (this.tableService.unloadHiveTable(tableName, project)) {
                    unLoadSuccess.add(tableName);
                    continue;
                }
                unLoadFail.add(tableName);
            }
        }
        catch (Throwable e) {
            logger.error("Failed to unload Hive Table", e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        result.put("result.unload.success", unLoadSuccess.toArray(new String[unLoadSuccess.size()]));
        result.put("result.unload.fail", unLoadFail.toArray(new String[unLoadFail.size()]));
        return result;
    }

    @RequestMapping(value={"/hive"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    private List<String> showHiveDatabases(@RequestParam(value="project", required=false) String project) throws IOException {
        try {
            return this.tableService.getSourceDbNames(project);
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/hive/{database}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    private List<String> showHiveTables(@PathVariable String database, @RequestParam(value="project", required=false) String project) throws IOException {
        try {
            return this.tableService.getSourceTableNames(project, database);
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{project}/{tableName}/snapshots"}, method={RequestMethod.GET})
    @ResponseBody
    public void getTableSnapshots(@PathVariable String project, @PathVariable String tableName) throws IOException {
        logger.warn("API getTableSnapshots is not supported in Kylin 4.0 .");
    }

    @RequestMapping(value={"/supported_datetime_patterns"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] getSupportedDatetimePatterns() {
        return DateFormat.SUPPORTED_DATETIME_PATTERN;
    }

    @RequestMapping(value={"/fetchCsvData"}, method={RequestMethod.POST})
    @ResponseBody
    public List<CsvColumnDesc> fetchCsvData(@RequestParam(value="file") MultipartFile file, @RequestParam(value="withHeader", required=false) boolean withHeader, @RequestParam(value="separator", required=false) String separator) throws IOException {
        if (file.isEmpty()) {
            throw new IllegalArgumentException("Please select a file");
        }
        return this.tableService.parseCsvFile(file, withHeader, separator);
    }

    @RequestMapping(value={"/saveCsvTable"}, method={RequestMethod.POST})
    @ResponseBody
    public TableDesc saveCsvTable(@RequestParam(value="file") MultipartFile file, @RequestParam(value="withHeader", required=false) boolean withHeader, @RequestParam(value="separator", required=true) String separator, @RequestParam(value="tableName", required=true) String tableName, @RequestParam(value="project", required=true) String project, @RequestParam(value="columns", required=true) String columnDescList) throws IOException {
        if (file.isEmpty()) {
            throw new IllegalArgumentException("Please select a file");
        }
        if (this.tableService.getTableDescByName(tableName, false, project) != null) {
            throw new InternalErrorException("Table " + tableName + " already exists!");
        }
        TableDesc desc = this.tableService.generateCsvTableDesc(tableName, (List)JsonUtil.readValue((String)columnDescList, List.class));
        TableExtDesc extDesc = this.tableService.generateTableExtDesc(desc, withHeader, separator);
        this.tableService.loadTableToProject(desc, extDesc, project);
        this.tableService.saveCsvFile(file, tableName, project);
        return desc;
    }

    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }
}

