/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.HybridRequest;
import org.apache.kylin.rest.response.HybridRespone;
import org.apache.kylin.rest.service.HybridService;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hybrids"})
public class HybridController
extends BasicController {
    @Autowired
    private HybridService hybridService;

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public HybridRespone create(@RequestBody HybridRequest request) {
        this.checkRequiredArg("hybrid", request.getHybrid());
        this.checkRequiredArg("project", request.getProject());
        this.checkRequiredArg("model", request.getModel());
        this.checkRequiredArg("cubes", request.getCubes());
        HybridInstance hybridInstance = this.hybridService.createHybridInstance(request.getHybrid(), request.getProject(), request.getModel(), request.getCubes());
        return this.hybridInstance2response(hybridInstance);
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public HybridRespone update(@RequestBody HybridRequest request) {
        this.checkRequiredArg("hybrid", request.getHybrid());
        this.checkRequiredArg("project", request.getProject());
        this.checkRequiredArg("model", request.getModel());
        this.checkRequiredArg("cubes", request.getCubes());
        HybridInstance hybridInstance = this.hybridService.updateHybridInstance(request.getHybrid(), request.getProject(), request.getModel(), request.getCubes());
        return this.hybridInstance2response(hybridInstance);
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void delete(String hybrid, String project) {
        this.checkRequiredArg("hybrid", hybrid);
        this.checkRequiredArg("project", project);
        this.hybridService.deleteHybridInstance(hybrid, project);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Collection<HybridRespone> list(@RequestParam(required=false) String project, @RequestParam(required=false) String model) {
        List<HybridInstance> hybridInstances = this.hybridService.listHybrids(project, model);
        ArrayList hybridRespones = Lists.newArrayListWithCapacity((int)hybridInstances.size());
        for (HybridInstance hybridInstance : hybridInstances) {
            hybridRespones.add(this.hybridInstance2response(hybridInstance));
        }
        return hybridRespones;
    }

    @RequestMapping(value={"{hybrid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public HybridRespone get(@PathVariable String hybrid) {
        HybridInstance hybridInstance = this.hybridService.getHybridInstance(hybrid);
        return this.hybridInstance2response(hybridInstance);
    }

    private HybridRespone hybridInstance2response(HybridInstance hybridInstance) {
        DataModelDesc modelDesc = hybridInstance.getModel();
        return new HybridRespone(modelDesc == null ? "NO_PROJECT" : modelDesc.getProject(), modelDesc == null ? "NO_MODEL" : modelDesc.getName(), hybridInstance);
    }
}

