/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.common.persistence.AutoDeleteDirectory;
import org.apache.kylin.metadata.badquery.BadQueryEntry;
import org.apache.kylin.metadata.badquery.BadQueryHistory;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.service.DiagnosisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/diag"})
public class DiagnosisController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisController.class);
    @Autowired
    @Qualifier(value="diagnosisService")
    private DiagnosisService dgService;

    @RequestMapping(value={"/{project}/sql"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<BadQueryEntry> getBadQuerySql(@PathVariable String project) {
        ArrayList badEntry = Lists.newArrayList();
        try {
            BadQueryHistory badQueryHistory = this.dgService.getProjectBadQueryHistory(project);
            badEntry.addAll(badQueryHistory.getEntries());
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to get bad queries.", e);
        }
        return badEntry;
    }

    @RequestMapping(value={"/project/{project}/download"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void dumpProjectDiagnosisInfo(@PathVariable String project, HttpServletRequest request, HttpServletResponse response) {
        try (AutoDeleteDirectory diagDir = new AutoDeleteDirectory("diag_project", "");){
            String filePath = this.dgService.dumpProjectDiagnosisInfo(project, diagDir.getFile());
            this.setDownloadResponse(filePath, response);
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to dump project diagnosis info. " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/job/{jobId}/download"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void dumpJobDiagnosisInfo(@PathVariable String jobId, HttpServletRequest request, HttpServletResponse response) {
        try (AutoDeleteDirectory diagDir = new AutoDeleteDirectory("diag_job", "");){
            String filePath = this.dgService.dumpJobDiagnosisInfo(jobId, diagDir.getFile());
            this.setDownloadResponse(filePath, response);
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to dump job diagnosis info. " + e.getMessage(), e);
        }
    }
}

