/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class TableSchemaUpdateChecker {
    private final TableMetadataManager metadataManager;
    private final CubeManager cubeManager;
    private final DataModelManager dataModelManager;

    TableSchemaUpdateChecker(TableMetadataManager metadataManager, CubeManager cubeManager, DataModelManager dataModelManager) {
        this.metadataManager = (TableMetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
        this.cubeManager = (CubeManager)Preconditions.checkNotNull((Object)cubeManager, (Object)"cubeManager is null");
        this.dataModelManager = (DataModelManager)Preconditions.checkNotNull((Object)dataModelManager, (Object)"dataModelManager is null");
    }

    private List<CubeInstance> findCubeByTable(final TableDesc table) {
        Iterable relatedCubes = Iterables.filter((Iterable)this.cubeManager.listAllCubes(), (Predicate)new Predicate<CubeInstance>(){

            public boolean apply(@Nullable CubeInstance cube) {
                if (cube == null || cube.allowBrokenDescriptor()) {
                    return false;
                }
                DataModelDesc model = cube.getModel();
                if (model == null) {
                    return false;
                }
                return model.containsTable(table);
            }
        });
        return ImmutableList.copyOf((Iterable)relatedCubes);
    }

    private boolean isColumnCompatible(ColumnDesc column, ColumnDesc newCol) {
        if (!column.getName().equalsIgnoreCase(newCol.getName())) {
            return false;
        }
        if (column.getType().isIntegerFamily()) {
            return newCol.getType().isIntegerFamily();
        }
        if (column.getType().isNumberFamily()) {
            return newCol.getType().isNumberFamily();
        }
        if (column.getType().isStringFamily() && newCol.getType().isDateTimeFamily() && this.metadataManager.getConfig().isAbleChangeStringToDateTime()) {
            return true;
        }
        return column.getTypeName().equals(newCol.getTypeName());
    }

    private List<String> checkAllColumnsInCube(CubeInstance cube, TableDesc origTable, TableDesc newTable) {
        HashSet usedColumns = Sets.newHashSet();
        for (TblColRef col : cube.getAllColumns()) {
            usedColumns.add(col.getColumnDesc());
        }
        ArrayList violateColumns = Lists.newArrayList();
        for (ColumnDesc column : origTable.getColumns()) {
            ColumnDesc newCol;
            if (column.isComputedColumn() || !usedColumns.contains(column) || (newCol = newTable.findColumnByName(column.getName())) != null && this.isColumnCompatible(column, newCol)) continue;
            violateColumns.add(column.getName());
        }
        return violateColumns;
    }

    private boolean checkAllColumnsInTableDesc(TableDesc origTable, TableDesc newTable) {
        if (origTable.getColumnCount() > newTable.getColumnCount()) {
            return false;
        }
        ColumnDesc[] columns = origTable.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (this.isColumnCompatible(columns[i], newTable.getColumns()[i])) continue;
            return false;
        }
        return true;
    }

    public CheckResult allowReload(TableDesc newTableDesc, String prj) {
        String fullTableName = newTableDesc.getIdentity();
        TableDesc existing = this.metadataManager.getTableDesc(fullTableName, prj);
        if (existing == null) {
            return CheckResult.validOnFirstLoad(fullTableName);
        }
        ArrayList issues = Lists.newArrayList();
        for (DataModelDesc dataModelDesc : this.findModelByTable(newTableDesc, prj)) {
            this.checkValidationInModel(newTableDesc, issues, dataModelDesc);
        }
        for (CubeInstance cubeInstance : this.findCubeByTable(newTableDesc)) {
            this.checkValidationInCube(newTableDesc, issues, cubeInstance);
        }
        if (issues.isEmpty()) {
            return CheckResult.validOnCompatibleSchema(fullTableName);
        }
        return CheckResult.invalidOnIncompatibleSchema(fullTableName, issues);
    }

    private Iterable<? extends DataModelDesc> findModelByTable(TableDesc newTableDesc, String prj) {
        ArrayList usedModels = Lists.newArrayList();
        List modelNames = this.dataModelManager.getModelsUsingTable(newTableDesc, prj);
        modelNames.stream().map(mn -> this.dataModelManager.getDataModelDesc(mn)).filter(m -> null != m).forEach(m -> usedModels.add(m));
        return usedModels;
    }

    private void checkValidationInCube(TableDesc newTableDesc, List<String> issues, CubeInstance cube) {
        TableDesc lookupTable;
        TableDesc factTable;
        List<String> violateColumns;
        String fullTableName = newTableDesc.getIdentity();
        String modelName = cube.getModel().getName();
        if (cube.getModel().isFactTable(fullTableName) && !(violateColumns = this.checkAllColumnsInCube(cube, factTable = cube.getModel().findFirstTable(fullTableName).getTableDesc(), newTableDesc)).isEmpty()) {
            issues.add(String.format(Locale.ROOT, "Column %s used in cube[%s] and model[%s], but changed in hive", violateColumns, cube.getName(), modelName));
        }
        if (cube.getModel().isLookupTable(fullTableName) && !this.checkAllColumnsInTableDesc(lookupTable = cube.getModel().findFirstTable(fullTableName).getTableDesc(), newTableDesc)) {
            issues.add(String.format(Locale.ROOT, "Table '%s' is used as Lookup Table in cube[%s] and model[%s], but changed in hive, only append operation are supported on hive table as lookup table", lookupTable.getIdentity(), cube.getName(), modelName));
        }
    }

    private void checkValidationInModel(TableDesc newTableDesc, List<String> issues, DataModelDesc usedModel) {
        ArrayList violateColumns = Lists.newArrayList();
        String fullTableName = newTableDesc.getIdentity();
        if (usedModel.isFactTable(fullTableName)) {
            TableDesc factTable = usedModel.findFirstTable(fullTableName).getTableDesc();
            violateColumns.addAll(this.checkAllColumnsInFactTable(usedModel, factTable, newTableDesc));
        }
        if (usedModel.isLookupTable(fullTableName)) {
            violateColumns.addAll(this.checkAllColumnsInLookupTable(usedModel, newTableDesc));
        }
        if (!violateColumns.isEmpty()) {
            issues.add(String.format(Locale.ROOT, "Column %s used in model[%s], but not exist in hive", violateColumns, usedModel.getName()));
        }
    }

    private List<String> checkAllColumnsInLookupTable(DataModelDesc usedModel, TableDesc newTableDesc) {
        ArrayList violateColumns = Lists.newArrayList();
        Set newColumns = Sets.newHashSet((Object[])newTableDesc.getColumns()).stream().map(c -> c.getName().toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        for (ModelDimensionDesc dim : usedModel.getDimensions()) {
            if (!dim.getTable().equalsIgnoreCase(newTableDesc.getIdentity())) continue;
            Set oldColumns = Sets.newHashSet((Object[])dim.getColumns()).stream().map(c -> c.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
            oldColumns.removeAll(newColumns);
            violateColumns.addAll(oldColumns);
        }
        return violateColumns;
    }

    private List<String> checkAllColumnsInFactTable(DataModelDesc usedModel, TableDesc factTable, TableDesc newTableDesc) {
        ArrayList violateColumns = Lists.newArrayList();
        for (ColumnDesc column : this.findUsedColumnsInFactTable(usedModel, factTable)) {
            ColumnDesc newCol;
            if (column.isComputedColumn() || (newCol = newTableDesc.findColumnByName(column.getName())) != null) continue;
            violateColumns.add(column.getName());
        }
        return violateColumns;
    }

    private String getTableName(String columnName) {
        int lastIndexOfDot = columnName.lastIndexOf(46);
        String tableName = null;
        if (lastIndexOfDot < 0) {
            return null;
        }
        tableName = columnName.substring(0, lastIndexOfDot);
        lastIndexOfDot = tableName.lastIndexOf(46);
        if (lastIndexOfDot >= 0) {
            tableName = tableName.substring(lastIndexOfDot + 1);
        }
        return tableName;
    }

    private ColumnDesc mustGetColumnDesc(TableDesc factTable, String columnName) {
        ColumnDesc columnDesc = factTable.findColumnByName(columnName);
        Preconditions.checkNotNull((Object)columnDesc, (Object)String.format(Locale.ROOT, "Can't find column %s in current fact table %s.", columnName, factTable.getIdentity()));
        return columnDesc;
    }

    private Set<ColumnDesc> findUsedColumnsInFactTable(DataModelDesc usedModel, TableDesc factTable) {
        HashSet usedColumns = Sets.newHashSet();
        for (ModelDimensionDesc dim : usedModel.getDimensions()) {
            if (!dim.getTable().equalsIgnoreCase(factTable.getName())) continue;
            for (String col : dim.getColumns()) {
                usedColumns.add(this.mustGetColumnDesc(factTable, col));
            }
        }
        for (String columnInMeasure : usedModel.getMetrics()) {
            if (!factTable.getName().equalsIgnoreCase(this.getTableName(columnInMeasure))) continue;
            usedColumns.add(this.mustGetColumnDesc(factTable, columnInMeasure));
        }
        return usedColumns;
    }

    public CheckResult allowMigrate(TableDesc newTableDesc, TableDesc hiveTableDesc) throws Exception {
        String fullTableName = newTableDesc.getIdentity();
        ArrayList issues = Lists.newArrayList();
        this.checkAllColumnsInHiveTableDesc(hiveTableDesc, newTableDesc, issues);
        if (issues.isEmpty()) {
            return new CheckResult(true, String.format(Locale.ROOT, "Table '%s' is compatible with existing hive table", fullTableName));
        }
        return new CheckResult(false, String.format(Locale.ROOT, "Table '%s' is incompatible with existing hive table due to '%s'", fullTableName, issues));
    }

    private void checkAllColumnsInHiveTableDesc(TableDesc hiveTable, TableDesc newTable, List<String> issues) {
        Object[] newTableCols;
        Object[] hiveTableCols = hiveTable.getColumns();
        if (hiveTableCols.length < (newTableCols = newTable.getColumns()).length) {
            Set colNamesNew = Lists.newArrayList((Object[])newTableCols).stream().map(input -> input.getName()).collect(Collectors.toSet());
            Set colNamesHive = Lists.newArrayList((Object[])hiveTableCols).stream().map(input -> input.getName()).collect(Collectors.toSet());
            colNamesNew.removeAll(colNamesHive);
            issues.add(String.format(Locale.ROOT, "columns %s are not existing in hive table", colNamesNew));
            return;
        }
        Map<String, ColumnDesc> hiveColMap = Lists.newArrayList((Object[])hiveTableCols).stream().collect(Collectors.toMap(input -> input.getName().toUpperCase(Locale.ROOT), input -> input));
        Map<String, ColumnDesc> newColMap = Lists.newArrayList((Object[])newTableCols).stream().collect(Collectors.toMap(input -> input.getName().toUpperCase(Locale.ROOT), input -> input));
        ArrayList violateColumns = Lists.newArrayList();
        for (String colName : newColMap.keySet()) {
            ColumnDesc hiveCol = hiveColMap.get(colName);
            if (hiveCol == null) {
                issues.add(String.format(Locale.ROOT, "column %s is not existing in hive table", colName));
                continue;
            }
            if (this.isColumnCompatible(hiveCol, newColMap.get(colName))) continue;
            violateColumns.add(colName);
        }
        if (!violateColumns.isEmpty()) {
            issues.add(String.format(Locale.ROOT, "Columns %s are incompatible in hive", violateColumns));
        }
    }

    public static class CheckResult {
        private final boolean valid;
        private final String reason;

        private CheckResult(boolean valid, String reason) {
            this.valid = valid;
            this.reason = reason;
        }

        public void raiseExceptionWhenInvalid() {
            if (!this.valid) {
                throw new RuntimeException(this.reason);
            }
        }

        static CheckResult validOnFirstLoad(String tableName) {
            return new CheckResult(true, String.format(Locale.ROOT, "Table '%s' hasn't been loaded before", tableName));
        }

        static CheckResult validOnCompatibleSchema(String tableName) {
            return new CheckResult(true, String.format(Locale.ROOT, "Table '%s' is compatible with all existing cubes", tableName));
        }

        static CheckResult invalidOnFetchSchema(String tableName, Exception e) {
            return new CheckResult(false, String.format(Locale.ROOT, "Failed to fetch metadata of '%s': %s", tableName, e.getMessage()));
        }

        static CheckResult invalidOnIncompatibleSchema(String tableName, List<String> reasons) {
            StringBuilder buf = new StringBuilder();
            for (String reason : reasons) {
                buf.append("- ").append(reason).append("\n");
            }
            return new CheckResult(false, String.format(Locale.ROOT, "Found %d issue(s) with '%s':%n%s Please disable and purge related cube(s) first", reasons.size(), tableName, buf.toString()));
        }
    }
}

