/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.acl.TableACLManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.draft.DraftManager;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.streaming.StreamingManager;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.storage.hybrid.HybridManager;

public abstract class BasicService {
    public KylinConfig getConfig() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig == null) {
            throw new IllegalArgumentException("Failed to load kylin config instance");
        }
        return kylinConfig;
    }

    public TableMetadataManager getTableManager() {
        return TableMetadataManager.getInstance((KylinConfig)this.getConfig());
    }

    public DataModelManager getDataModelManager() {
        return DataModelManager.getInstance((KylinConfig)this.getConfig());
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance((KylinConfig)this.getConfig());
    }

    public StreamingManager getStreamingManager() {
        return StreamingManager.getInstance((KylinConfig)this.getConfig());
    }

    public KafkaConfigManager getKafkaManager() throws IOException {
        return KafkaConfigManager.getInstance((KylinConfig)this.getConfig());
    }

    public CubeDescManager getCubeDescManager() {
        return CubeDescManager.getInstance((KylinConfig)this.getConfig());
    }

    public ProjectManager getProjectManager() {
        return ProjectManager.getInstance((KylinConfig)this.getConfig());
    }

    public HybridManager getHybridManager() {
        return HybridManager.getInstance((KylinConfig)this.getConfig());
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance((KylinConfig)this.getConfig());
    }

    public BadQueryHistoryManager getBadQueryHistoryManager() {
        return BadQueryHistoryManager.getInstance((KylinConfig)this.getConfig());
    }

    public DraftManager getDraftManager() {
        return DraftManager.getInstance((KylinConfig)this.getConfig());
    }

    public TableACLManager getTableACLManager() {
        return TableACLManager.getInstance((KylinConfig)this.getConfig());
    }

    public MetricsManager getMetricsManager() {
        return MetricsManager.getInstance();
    }
}

