/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.acl.TableACLManager;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.security.QueryInterceptor;
import org.apache.kylin.rest.util.AclPermissionUtil;

public class TableInterceptor
extends QueryInterceptor {
    protected boolean isEnabled() {
        return KylinConfig.getInstanceFromEnv().isTableACLEnabled();
    }

    public Set<String> getQueryIdentifiers(List<OLAPContext> contexts) {
        return this.getAllTblsWithSchema(contexts);
    }

    protected Set<String> getIdentifierBlackList(List<OLAPContext> contexts) {
        String project = this.getProject(contexts);
        String username = this.getUser(contexts);
        return TableACLManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getTableACLByCache(project).getTableBlackList(username, AclPermissionUtil.getCurrentUserGroups());
    }

    protected String getIdentifierType() {
        return "table";
    }

    private Set<String> getAllTblsWithSchema(List<OLAPContext> contexts) {
        TreeSet<String> tableWithSchema = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (OLAPContext context : contexts) {
            for (OLAPTableScan tableScan : context.allTableScans) {
                tableWithSchema.add(tableScan.getTableRef().getTableIdentity());
            }
        }
        return tableWithSchema;
    }
}

