/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.KylinUserManager;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class KylinUserService
implements UserService {
    private Logger logger = LoggerFactory.getLogger(KylinUserService.class);
    @Autowired
    private AclEvaluate aclEvaluate;
    public static final String DIR_PREFIX = "/user/";
    public static final String SUPER_ADMIN = "ADMIN";
    public static final Serializer<ManagedUser> SERIALIZER = new JsonSerializer(ManagedUser.class);
    private static final String ACTIVE_PROFILES_NAME = "spring.profiles.active";
    private static final String ADMIN = "ADMIN";
    private static final String MODELER = "MODELER";
    private static final String ANALYST = "ANALYST";
    private static final String ADMIN_DEFAULT = "KYLIN";
    private BCryptPasswordEncoder pwdEncoder;
    public List<User> configUsers;
    protected ResourceStore aclStore;
    private boolean evictCacheFlag = false;

    public KylinUserService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KylinUserService(List<User> users) throws IOException {
        this.pwdEncoder = new BCryptPasswordEncoder();
        Class<KylinUserService> clazz = KylinUserService.class;
        synchronized (KylinUserService.class) {
            if (!StringUtils.equals((String)"testing", (String)System.getProperty(ACTIVE_PROFILES_NAME))) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            List<ManagedUser> all = this.listUsers();
            this.configUsers = users;
            if (!this.configUsers.isEmpty()) {
                for (User cuser : this.configUsers) {
                    try {
                        String username = cuser.getUsername();
                        ManagedUser userDetail = (ManagedUser)this.loadUserByUsername(username);
                        if (userDetail == null || new KylinVersion((String)userDetail.getVersion()).major >= KylinVersion.getCurrentVersion().major) continue;
                        this.updateUser(new ManagedUser(cuser.getUsername(), cuser.getPassword(), (Boolean)false, cuser.getAuthorities()));
                    }
                    catch (UsernameNotFoundException e) {
                        this.createUser(new ManagedUser(cuser.getUsername(), cuser.getPassword(), (Boolean)false, cuser.getAuthorities()));
                    }
                }
            }
            if (all.isEmpty() && this.configUsers.isEmpty()) {
                this.createUser(new ManagedUser("ADMIN", this.pwdEncoder.encode((CharSequence)ADMIN_DEFAULT), (Boolean)true, "ROLE_ADMIN", "ALL_USERS"));
                this.createUser(new ManagedUser(ANALYST, this.pwdEncoder.encode((CharSequence)ANALYST), (Boolean)true, "ALL_USERS"));
                this.createUser(new ManagedUser(MODELER, this.pwdEncoder.encode((CharSequence)MODELER), (Boolean)true, "ALL_USERS"));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isEvictCacheFlag() {
        return this.evictCacheFlag;
    }

    @Override
    public void setEvictCacheFlag(boolean evictCacheFlag) {
        this.evictCacheFlag = evictCacheFlag;
    }

    @PostConstruct
    public void init() throws IOException {
        this.aclStore = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public void createUser(UserDetails user) {
        this.updateUser(user);
    }

    public void updateUser(UserDetails user) {
        Preconditions.checkState((boolean)(user instanceof ManagedUser), (String)"User {} is not ManagedUser", (Object[])new Object[]{user});
        ManagedUser managedUser = (ManagedUser)user;
        if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority("ALL_USERS"))) {
            managedUser.addAuthorities("ALL_USERS");
        }
        this.getKylinUserManager().update(managedUser);
        this.logger.trace("update user : {}", (Object)user.getUsername());
        this.setEvictCacheFlag(true);
    }

    public void deleteUser(String userName) {
        if (userName.equalsIgnoreCase("ADMIN")) {
            throw new InternalErrorException("User " + userName + " is not allowed to be deleted.");
        }
        this.getKylinUserManager().delete(userName);
        this.logger.trace("delete user : {}", (Object)userName);
        this.setEvictCacheFlag(true);
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean userExists(String userName) {
        this.logger.trace("judge user exist: {}", (Object)userName);
        return this.getKylinUserManager().exists(userName);
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        Message msg = MsgPicker.getMsg();
        ManagedUser managedUser = this.getKylinUserManager().get(userName);
        if (managedUser == null) {
            throw new UsernameNotFoundException(String.format(Locale.ROOT, msg.getUSER_NOT_FOUND(), userName));
        }
        this.logger.trace("load user : {}", (Object)userName);
        return managedUser;
    }

    @Override
    public List<ManagedUser> listUsers() throws IOException {
        return this.getKylinUserManager().list();
    }

    @Override
    public List<ManagedUser> listUsers(String userName, Boolean isFuzzMatch) throws IOException {
        List<ManagedUser> userList = this.getKylinUserManager().list();
        return this.getManagedUsersByFuzzMatching(userName, isFuzzMatch, userList, null);
    }

    @Override
    public List<ManagedUser> listUsers(String userName, String groupName, Boolean isFuzzMatch) throws IOException {
        List<ManagedUser> userList = this.getKylinUserManager().list();
        return this.getManagedUsersByFuzzMatching(userName, isFuzzMatch, userList, groupName);
    }

    @Override
    public List<String> listAdminUsers() throws IOException {
        ArrayList<String> adminUsers = new ArrayList<String>();
        for (ManagedUser managedUser : this.listUsers()) {
            if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"))) continue;
            adminUsers.add(managedUser.getUsername());
        }
        return adminUsers;
    }

    @Override
    public void completeUserInfo(ManagedUser user) {
    }

    public static String getId(String userName) {
        return DIR_PREFIX + userName;
    }

    private KylinUserManager getKylinUserManager() {
        return KylinUserManager.getInstance(KylinConfig.getInstanceFromEnv());
    }

    private List<ManagedUser> getManagedUsersByFuzzMatching(String nameSeg, boolean isFuzzMatch, List<ManagedUser> userList, String groupName) {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (StringUtils.isBlank((String)nameSeg) && StringUtils.isBlank((String)groupName)) {
            return userList;
        }
        ArrayList<ManagedUser> usersByFuzzyMatching = new ArrayList<ManagedUser>();
        for (ManagedUser u : userList) {
            if (!isFuzzMatch && StringUtils.equals((String)u.getUsername(), (String)nameSeg) && this.isUserInGroup(u, groupName)) {
                usersByFuzzyMatching.add(u);
            }
            if (!isFuzzMatch || !StringUtils.containsIgnoreCase((String)u.getUsername(), (String)nameSeg) || !this.isUserInGroup(u, groupName)) continue;
            usersByFuzzyMatching.add(u);
        }
        return usersByFuzzyMatching;
    }

    private boolean isUserInGroup(ManagedUser user, String groupName) {
        return StringUtils.isBlank((String)groupName) || user.getAuthorities().contains(new SimpleGrantedAuthority(groupName));
    }
}

