/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclEntityFactory;
import org.apache.kylin.rest.security.springacl.AclRecord;
import org.apache.kylin.rest.security.springacl.MutableAclRecord;
import org.apache.kylin.rest.security.springacl.ObjectIdentityImpl;
import org.apache.kylin.rest.service.AclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="accessService")
public class AccessService {
    private static final Logger logger = LoggerFactory.getLogger(AccessService.class);
    @Autowired
    @Qualifier(value="aclService")
    private AclService aclService;

    @Transactional
    public MutableAclRecord init(AclEntity ae, Permission initPermission) {
        MutableAclRecord acl = null;
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae);
        try {
            acl = (MutableAclRecord)this.aclService.createAcl(objectIdentity);
        }
        catch (AlreadyExistsException e) {
            acl = this.aclService.readAcl(objectIdentity);
        }
        if (null != initPermission) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            PrincipalSid sid = new PrincipalSid(auth);
            acl = this.grant(ae, initPermission, (Sid)sid);
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void batchGrant(AclEntity ae, Map<Sid, Permission> sidToPerm) {
        MutableAclRecord acl;
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (sidToPerm == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        try {
            acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        }
        catch (NotFoundException e) {
            acl = this.init(ae, null);
        }
        for (Sid sid : sidToPerm.keySet()) {
            this.secureOwner(acl, sid);
        }
        this.aclService.batchUpsertAce(acl, sidToPerm);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord grant(AclEntity ae, Permission permission, Sid sid) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (permission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        if (sid == null) {
            throw new BadRequestException(msg.getSID_REQUIRED());
        }
        MutableAclRecord acl = null;
        try {
            acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        }
        catch (NotFoundException e) {
            acl = this.init(ae, null);
        }
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, permission);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord update(AclEntity ae, int accessEntryIndex, Permission newPermission) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (newPermission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        MutableAclRecord acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        Sid sid = acl.getAclRecord().getAccessControlEntryAt(accessEntryIndex).getSid();
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, newPermission);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public MutableAclRecord revoke(AclEntity ae, int accessEntryIndex) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        MutableAclRecord acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        Sid sid = acl.getAclRecord().getAccessControlEntryAt(accessEntryIndex).getSid();
        this.secureOwner(acl, sid);
        return this.aclService.upsertAce(acl, sid, null);
    }

    @Transactional
    public void inherit(AclEntity ae, AclEntity parentAe) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (parentAe == null) {
            throw new BadRequestException(msg.getPARENT_ACL_NOT_FOUND());
        }
        MutableAclRecord acl = null;
        try {
            acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        }
        catch (NotFoundException e) {
            acl = this.init(ae, null);
        }
        MutableAclRecord parentAcl = null;
        try {
            parentAcl = this.aclService.readAcl(new ObjectIdentityImpl(parentAe));
        }
        catch (NotFoundException e) {
            parentAcl = this.init(parentAe, null);
        }
        if (null == acl || null == parentAcl) {
            return;
        }
        this.aclService.inherit(acl, parentAcl);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void clean(AclEntity ae, boolean deleteChildren) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (ae.getId() == null) {
            return;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae);
        try {
            this.aclService.deleteAcl(objectIdentity, deleteChildren);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RootPersistentEntity getAclEntity(String entityType, String uuid) {
        if (null == uuid) {
            return null;
        }
        return AclEntityFactory.createAclEntity(entityType, uuid);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION') or hasPermission(#ae, 'MANAGEMENT') or hasPermission(#ae, 'OPERATION') or hasPermission(#ae, 'READ')")
    public MutableAclRecord getAcl(AclEntity ae) {
        if (null == ae) {
            return null;
        }
        MutableAclRecord acl = null;
        try {
            acl = this.aclService.readAcl(new ObjectIdentityImpl(ae));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return acl;
    }

    public Sid getSid(String sid, boolean isPrincepal) {
        if (isPrincepal) {
            return new PrincipalSid(sid);
        }
        return new GrantedAuthoritySid(sid);
    }

    public List<AccessEntryResponse> generateAceResponsesByFuzzMatching(Acl acl, String nameSeg, boolean isCaseSensitive) {
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        for (AccessControlEntry ace : acl.getEntries()) {
            if (nameSeg != null && !this.needAdd(nameSeg, isCaseSensitive, AccessService.getName(ace.getSid()))) continue;
            result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
        }
        return result;
    }

    private boolean needAdd(String nameSeg, boolean isCaseSensitive, String name) {
        return isCaseSensitive && StringUtils.contains((String)name, (String)nameSeg) || !isCaseSensitive && StringUtils.containsIgnoreCase((String)name, (String)nameSeg);
    }

    private static String getName(Sid sid) {
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        return ((GrantedAuthoritySid)sid).getGrantedAuthority();
    }

    public List<AccessEntryResponse> generateAceResponses(Acl acl) {
        return this.generateAceResponsesByFuzzMatching(acl, null, false);
    }

    public List<String> getAllAclSids(Acl acl, String type) {
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            String name = null;
            if (type.equalsIgnoreCase("user") && ace.getSid() instanceof PrincipalSid) {
                name = ((PrincipalSid)ace.getSid()).getPrincipal();
            }
            if (type.equalsIgnoreCase("group") && ace.getSid() instanceof GrantedAuthoritySid) {
                name = ((GrantedAuthoritySid)ace.getSid()).getGrantedAuthority();
            }
            if (StringUtils.isBlank(name)) continue;
            result.add(name);
        }
        return result;
    }

    private void secureOwner(MutableAclRecord acl, Sid sid) {
        Message msg = MsgPicker.getMsg();
        AclRecord record = acl.getAclRecord();
        if (!record.getOwner().equals((Object)sid)) {
            return;
        }
        if (BasePermission.ADMINISTRATION.equals(record.getPermission(sid))) {
            throw new ForbiddenException(msg.getREVOKE_ADMIN_PERMISSION());
        }
    }

    public Object generateAllAceResponses(Acl acl) {
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        while (acl != null) {
            for (AccessControlEntry ace : acl.getEntries()) {
                result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
            }
            acl = acl.getParentAcl();
        }
        return result;
    }

    public void revokeProjectPermission(String name, String type) {
        PrincipalSid sid = null;
        if (type.equalsIgnoreCase("user")) {
            sid = new PrincipalSid(name);
        } else if (type.equalsIgnoreCase("group")) {
            sid = new GrantedAuthoritySid(name);
        } else {
            return;
        }
        List projectInstances = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        for (ProjectInstance pi : projectInstances) {
            RootPersistentEntity ae = this.getAclEntity("ProjectInstance", pi.getUuid());
            MutableAclRecord acl = this.getAcl((AclEntity)ae);
            if (acl == null) {
                return;
            }
            Permission perm = acl.getAclRecord().getPermission((Sid)sid);
            if (perm == null) continue;
            this.secureOwner(acl, (Sid)sid);
            this.aclService.upsertAce(acl, (Sid)sid, null);
        }
    }

    public String getUserPermissionInPrj(String project) {
        String grantedPermission = "";
        List<String> groups = this.getGroupsFromCurrentUser();
        if (groups.contains("ROLE_ADMIN")) {
            return "GLOBAL_ADMIN";
        }
        Map<String, Integer> projectPermissions = this.getProjectPermission(project);
        Integer greaterPermission = projectPermissions.get(SecurityContextHolder.getContext().getAuthentication().getName());
        for (String group : groups) {
            Integer groupPerm = projectPermissions.get(group);
            greaterPermission = (Integer)Preconditions.checkNotNull((Object)this.getGreaterPerm(groupPerm, greaterPermission));
        }
        switch (greaterPermission) {
            case 16: {
                grantedPermission = "ADMINISTRATION";
                break;
            }
            case 32: {
                grantedPermission = "MANAGEMENT";
                break;
            }
            case 64: {
                grantedPermission = "OPERATION";
                break;
            }
            case 1: {
                grantedPermission = "READ";
                break;
            }
            case 0: {
                grantedPermission = "EMPTY";
                break;
            }
            default: {
                throw new RuntimeException("invalid permission state:" + greaterPermission);
            }
        }
        return grantedPermission;
    }

    private Map<String, Integer> getProjectPermission(String project) {
        TreeMap<String, Integer> SidWithPermission = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        String uuid = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getUuid();
        RootPersistentEntity ae = this.getAclEntity("ProjectInstance", uuid);
        MutableAclRecord acl = this.getAcl((AclEntity)ae);
        if (acl != null && acl.getEntries() != null) {
            List aces = acl.getEntries();
            for (AccessControlEntry ace : aces) {
                Sid sid = ace.getSid();
                if (sid instanceof PrincipalSid) {
                    String principal = ((PrincipalSid)sid).getPrincipal();
                    SidWithPermission.put(principal, ace.getPermission().getMask());
                }
                if (!(sid instanceof GrantedAuthoritySid)) continue;
                String grantedAuthority = ((GrantedAuthoritySid)sid).getGrantedAuthority();
                SidWithPermission.put(grantedAuthority, ace.getPermission().getMask());
            }
        }
        return SidWithPermission;
    }

    private List<String> getGroupsFromCurrentUser() {
        ArrayList<String> groups = new ArrayList<String>();
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        for (GrantedAuthority auth : authorities) {
            groups.add(auth.getAuthority());
        }
        return groups;
    }

    private Integer getGreaterPerm(Integer mask1, Integer mask2) {
        if (mask1 == null && mask2 == null) {
            return 0;
        }
        if (mask1 != null && mask2 == null) {
            return mask1;
        }
        if (mask1 == null && mask2 != null) {
            return mask2;
        }
        if (mask1 == 16 || mask2 == 16) {
            return 16;
        }
        if (mask1 == 32 || mask2 == 32) {
            return 32;
        }
        if (mask1 == 64 || mask2 == 64) {
            return 64;
        }
        if (mask1 == 1 || mask2 == 1) {
            return 1;
        }
        return null;
    }
}

