/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class KylinAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(KylinAuthenticationProvider.class);
    private static final Cache<String, Authentication> userCache = CacheBuilder.newBuilder().maximumSize((long)KylinConfig.getInstanceFromEnv().getServerUserCacheMaxEntries()).expireAfterWrite((long)KylinConfig.getInstanceFromEnv().getServerUserCacheExpireSeconds(), TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<String, Authentication>(){

        public void onRemoval(RemovalNotification<String, Authentication> notification) {
            logger.debug("User cache {} is removed due to {}", notification.getKey(), (Object)notification.getCause());
        }
    }).build();
    @Autowired
    @Qualifier(value="userService")
    UserService userService;
    private AuthenticationProvider authenticationProvider;
    private HashFunction hf = null;

    public KylinAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"The embedded authenticationProvider should not be null.");
        this.authenticationProvider = authenticationProvider;
        this.hf = Hashing.murmur3_128();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authed;
        byte[] hashKey = this.hf.hashString((CharSequence)(authentication.getName() + authentication.getCredentials())).asBytes();
        String userKey = Arrays.toString(hashKey);
        if (this.userService.isEvictCacheFlag()) {
            userCache.invalidateAll();
            this.userService.setEvictCacheFlag(false);
        }
        if (null != (authed = (Authentication)userCache.getIfPresent((Object)userKey))) {
            SecurityContextHolder.getContext().setAuthentication(authed);
        } else {
            try {
                ManagedUser user;
                authed = this.authenticationProvider.authenticate(authentication);
                if (authed.getDetails() == null) {
                    throw new UsernameNotFoundException("User not found in LDAP, check whether he/she has been added to the groups.");
                }
                if (authed.getDetails() instanceof UserDetails) {
                    UserDetails details = (UserDetails)authed.getDetails();
                    user = new ManagedUser(details.getUsername(), details.getPassword(), (Boolean)false, details.getAuthorities());
                } else {
                    user = new ManagedUser(authentication.getName(), "skippped-ldap", (Boolean)false, authed.getAuthorities());
                }
                Assert.notNull((Object)((Object)user), (String)"The UserDetail is null.");
                String username = user.getUsername();
                logger.debug("User {} authorities : {}", (Object)username, (Object)user.getAuthorities());
                if (!this.userService.userExists(username)) {
                    this.userService.createUser(user);
                } else if (!this.userService.loadUserByUsername(username).equals((Object)user)) {
                    this.userService.updateUser(user);
                }
                userCache.put((Object)userKey, (Object)authed);
            }
            catch (AuthenticationException e) {
                logger.error("Failed to auth user: " + authentication.getName(), (Throwable)e);
                throw e;
            }
            logger.debug("Authenticated user " + authed.toString());
        }
        return authed;
    }

    public boolean supports(Class<?> authentication) {
        return this.authenticationProvider.supports(authentication);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

