/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.signature;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.security.MessageDigest;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.signature.RealizationSignature;
import org.apache.kylin.rest.signature.SignatureCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationSetCalculator
implements SignatureCalculator {
    public static final Logger logger = LoggerFactory.getLogger(RealizationSetCalculator.class);

    @Override
    public String calculateSignature(KylinConfig config, SQLResponse sqlResponse, ProjectInstance project) {
        Set<String> realizations = this.getRealizations(config, sqlResponse.getCube(), project);
        if (realizations == null) {
            return null;
        }
        TreeSet signatureSet = Sets.newTreeSet();
        for (String realization : realizations) {
            RealizationSignature realizationSignature = RealizationSetCalculator.getRealizationSignature(config, realization);
            if (realizationSignature == null) continue;
            signatureSet.add(realizationSignature);
        }
        if (signatureSet.isEmpty()) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] signature = md.digest(((Object)signatureSet).toString().getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])signature), "UTF-8");
        }
        catch (Exception e) {
            logger.warn("Failed to calculate signature due to " + e);
            return null;
        }
    }

    protected Set<String> getRealizations(KylinConfig config, String cubes, ProjectInstance project) {
        if (Strings.isNullOrEmpty((String)cubes)) {
            return null;
        }
        Object[] realizations = RealizationSetCalculator.parseNamesFromCanonicalNames(StringUtil.splitByComma((String)cubes));
        return Sets.newHashSet((Object[])realizations);
    }

    protected static RealizationSignature getRealizationSignature(KylinConfig config, String realizationName) {
        RealizationSignature result = RealizationSignature.HybridSignature.getHybridSignature(config, realizationName);
        if (result == null) {
            result = RealizationSignature.CubeSignature.getCubeSignature(config, realizationName);
        }
        return result;
    }

    private static String[] parseNamesFromCanonicalNames(String[] canonicalNames) {
        String[] result = new String[canonicalNames.length];
        for (int i = 0; i < canonicalNames.length; ++i) {
            result[i] = (String)RealizationSetCalculator.parseCanonicalName(canonicalNames[i]).getSecond();
        }
        return result;
    }

    private static Pair<String, String> parseCanonicalName(String canonicalName) {
        Iterable parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"[]=,")).split((CharSequence)canonicalName);
        String[] partsStr = (String[])Iterables.toArray((Iterable)parts, String.class);
        return new Pair((Object)partsStr[0], (Object)partsStr[2]);
    }
}

