/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclEntityFactory;
import org.apache.kylin.rest.service.AclService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="accessService")
public class AccessService {
    @Autowired
    @Qualifier(value="aclService")
    private AclService aclService;

    @Transactional
    public Acl init(AclEntity ae, Permission initPermission) {
        MutableAcl acl = null;
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        try {
            acl = this.aclService.createAcl((ObjectIdentity)objectIdentity);
        }
        catch (AlreadyExistsException e) {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        if (null != initPermission) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            PrincipalSid sid = new PrincipalSid(auth);
            acl = this.grant(ae, initPermission, (Sid)sid);
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl grant(AclEntity ae, Permission permission, Sid sid) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (permission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        if (sid == null) {
            throw new BadRequestException(msg.getSID_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException e) {
            acl = (MutableAcl)this.init(ae, null);
        }
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!ace.getSid().equals((Object)sid)) continue;
            indexOfAce = i;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            acl.updateAce(indexOfAce, permission);
        } else {
            acl.insertAce(acl.getEntries().size(), permission, sid, true);
        }
        acl = this.aclService.updateAcl(acl);
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl update(AclEntity ae, Long accessEntryId, Permission newPermission) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (accessEntryId == null) {
            throw new BadRequestException(msg.getACE_ID_REQUIRED());
        }
        if (newPermission == null) {
            throw new BadRequestException(msg.getACL_PERMISSION_REQUIRED());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        int indexOfAce = -1;
        for (int i = 0; i < acl.getEntries().size(); ++i) {
            AccessControlEntry ace = (AccessControlEntry)acl.getEntries().get(i);
            if (!ace.getId().equals(accessEntryId)) continue;
            indexOfAce = i;
            break;
        }
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            try {
                acl.updateAce(indexOfAce, newPermission);
                acl = this.aclService.updateAcl(acl);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return acl;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public Acl revoke(AclEntity ae, Long accessEntryId) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (accessEntryId == null) {
            throw new BadRequestException(msg.getACE_ID_REQUIRED());
        }
        MutableAcl acl = (MutableAcl)this.getAcl(ae);
        int indexOfAce = this.getIndexOfAce(accessEntryId, acl);
        acl = this.deleteAndUpdate(acl, indexOfAce);
        return acl;
    }

    private int getIndexOfAce(Long accessEntryId, MutableAcl acl) {
        int indexOfAce = -1;
        List aces = acl.getEntries();
        for (int i = 0; i < aces.size(); ++i) {
            if (!((AccessControlEntry)aces.get(i)).getId().equals(accessEntryId)) continue;
            indexOfAce = i;
            break;
        }
        return indexOfAce;
    }

    private MutableAcl deleteAndUpdate(MutableAcl acl, int indexOfAce) {
        if (indexOfAce != -1) {
            this.secureOwner(acl, indexOfAce);
            try {
                acl.deleteAce(indexOfAce);
                acl = this.aclService.updateAcl(acl);
            }
            catch (NotFoundException e) {
                throw new RuntimeException("Revoke acl fail." + e.getMessage());
            }
        }
        return acl;
    }

    @Deprecated
    @Transactional
    public void inherit(AclEntity ae, AclEntity parentAe) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (parentAe == null) {
            throw new BadRequestException(msg.getPARENT_ACL_NOT_FOUND());
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException e) {
            acl = (MutableAcl)this.init(ae, null);
        }
        ObjectIdentityImpl parentObjectIdentity = new ObjectIdentityImpl(parentAe.getClass(), (Serializable)((Object)parentAe.getId()));
        MutableAcl parentAcl = null;
        try {
            parentAcl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)parentObjectIdentity);
        }
        catch (NotFoundException e) {
            parentAcl = (MutableAcl)this.init(parentAe, null);
        }
        if (null == acl || null == parentAcl) {
            return;
        }
        acl.setEntriesInheriting(true);
        acl.setParent((Acl)parentAcl);
        this.aclService.updateAcl(acl);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION')")
    public void clean(AclEntity ae, boolean deleteChildren) {
        Message msg = MsgPicker.getMsg();
        if (ae == null) {
            throw new BadRequestException(msg.getACL_DOMAIN_NOT_FOUND());
        }
        if (ae.getId() == null) {
            return;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        try {
            this.aclService.deleteAcl((ObjectIdentity)objectIdentity, deleteChildren);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public RootPersistentEntity getAclEntity(String entityType, String uuid) {
        if (null == uuid) {
            return null;
        }
        return AclEntityFactory.createAclEntity(entityType, uuid);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#ae, 'ADMINISTRATION') or hasPermission(#ae, 'MANAGEMENT') or hasPermission(#ae, 'OPERATION') or hasPermission(#ae, 'READ')")
    public Acl getAcl(AclEntity ae) {
        if (null == ae) {
            return null;
        }
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(ae.getClass(), (Serializable)((Object)ae.getId()));
        MutableAcl acl = null;
        try {
            acl = (MutableAcl)this.aclService.readAclById((ObjectIdentity)objectIdentity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return acl;
    }

    public Sid getSid(String sid, boolean isPrincepal) {
        if (isPrincepal) {
            return new PrincipalSid(sid);
        }
        return new GrantedAuthoritySid(sid);
    }

    public List<AccessEntryResponse> generateAceResponsesByFuzzMatching(Acl acl, String nameSeg, boolean isCaseSensitive) {
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        for (AccessControlEntry ace : acl.getEntries()) {
            if (nameSeg != null && !this.needAdd(nameSeg, isCaseSensitive, AccessService.getName(ace.getSid()))) continue;
            result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
        }
        return result;
    }

    private boolean needAdd(String nameSeg, boolean isCaseSensitive, String name) {
        return isCaseSensitive && StringUtils.contains((String)name, (String)nameSeg) || !isCaseSensitive && StringUtils.containsIgnoreCase((String)name, (String)nameSeg);
    }

    private static String getName(Sid sid) {
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        return ((GrantedAuthoritySid)sid).getGrantedAuthority();
    }

    public List<AccessEntryResponse> generateAceResponses(Acl acl) {
        return this.generateAceResponsesByFuzzMatching(acl, null, false);
    }

    public List<String> getAllAclSids(Acl acl, String type) {
        if (null == acl) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            String name = null;
            if (type.equalsIgnoreCase("user") && ace.getSid() instanceof PrincipalSid) {
                name = ((PrincipalSid)ace.getSid()).getPrincipal();
            }
            if (type.equalsIgnoreCase("group") && ace.getSid() instanceof GrantedAuthoritySid) {
                name = ((GrantedAuthoritySid)ace.getSid()).getGrantedAuthority();
            }
            if (StringUtils.isBlank(name)) continue;
            result.add(name);
        }
        return result;
    }

    private void secureOwner(MutableAcl acl, int indexOfAce) {
        Message msg = MsgPicker.getMsg();
        if (acl.getOwner().equals((Object)((AccessControlEntry)acl.getEntries().get(indexOfAce)).getSid()) && BasePermission.ADMINISTRATION.equals(((AccessControlEntry)acl.getEntries().get(indexOfAce)).getPermission())) {
            throw new ForbiddenException(msg.getREVOKE_ADMIN_PERMISSION());
        }
    }

    public Object generateAllAceResponses(Acl acl) {
        ArrayList<AccessEntryResponse> result = new ArrayList<AccessEntryResponse>();
        while (acl != null) {
            for (AccessControlEntry ace : acl.getEntries()) {
                result.add(new AccessEntryResponse(ace.getId(), ace.getSid(), ace.getPermission(), ace.isGranting()));
            }
            acl = acl.getParentAcl();
        }
        return result;
    }

    public void revokeProjectPermission(String name, String type) {
        List projectInstances = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        for (ProjectInstance pi : projectInstances) {
            RootPersistentEntity ae = this.getAclEntity("ProjectInstance", pi.getUuid());
            MutableAcl acl = (MutableAcl)this.getAcl((AclEntity)ae);
            if (acl == null) {
                return;
            }
            List aces = acl.getEntries();
            if (aces == null) {
                return;
            }
            int indexOfAce = -1;
            for (int i = 0; i < aces.size(); ++i) {
                if (!this.needRevoke(((AccessControlEntry)aces.get(i)).getSid(), name, type)) continue;
                indexOfAce = i;
                break;
            }
            this.deleteAndUpdate(acl, indexOfAce);
        }
    }

    public String getUserPermissionInPrj(String project) {
        String grantedPermission = "";
        List<String> groups = this.getGroupsFromCurrentUser();
        if (groups.contains("ROLE_ADMIN")) {
            return "GLOBAL_ADMIN";
        }
        Map<String, Integer> projectPermissions = this.getProjectPermission(project);
        Integer greaterPermission = projectPermissions.get(SecurityContextHolder.getContext().getAuthentication().getName());
        for (String group : groups) {
            Integer groupPerm = projectPermissions.get(group);
            greaterPermission = (Integer)Preconditions.checkNotNull((Object)this.getGreaterPerm(groupPerm, greaterPermission));
        }
        switch (greaterPermission) {
            case 16: {
                grantedPermission = "ADMINISTRATION";
                break;
            }
            case 32: {
                grantedPermission = "MANAGEMENT";
                break;
            }
            case 64: {
                grantedPermission = "OPERATION";
                break;
            }
            case 1: {
                grantedPermission = "READ";
                break;
            }
            case 0: {
                grantedPermission = "EMPTY";
                break;
            }
            default: {
                throw new RuntimeException("invalid permission state:" + greaterPermission);
            }
        }
        return grantedPermission;
    }

    private Map<String, Integer> getProjectPermission(String project) {
        HashMap<String, Integer> SidWithPermission = new HashMap<String, Integer>();
        String uuid = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getUuid();
        RootPersistentEntity ae = this.getAclEntity("ProjectInstance", uuid);
        Acl acl = this.getAcl((AclEntity)ae);
        if (acl != null && acl.getEntries() != null) {
            List aces = acl.getEntries();
            for (AccessControlEntry ace : aces) {
                Sid sid = ace.getSid();
                if (sid instanceof PrincipalSid) {
                    String principal = ((PrincipalSid)sid).getPrincipal();
                    SidWithPermission.put(principal, ace.getPermission().getMask());
                }
                if (!(sid instanceof GrantedAuthoritySid)) continue;
                String grantedAuthority = ((GrantedAuthoritySid)sid).getGrantedAuthority();
                SidWithPermission.put(grantedAuthority, ace.getPermission().getMask());
            }
        }
        return SidWithPermission;
    }

    private List<String> getGroupsFromCurrentUser() {
        ArrayList<String> groups = new ArrayList<String>();
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        for (GrantedAuthority auth : authorities) {
            groups.add(auth.getAuthority());
        }
        return groups;
    }

    private Integer getGreaterPerm(Integer mask1, Integer mask2) {
        if (mask1 == null && mask2 == null) {
            return 0;
        }
        if (mask1 != null && mask2 == null) {
            return mask1;
        }
        if (mask1 == null && mask2 != null) {
            return mask2;
        }
        if (mask1 == 16 || mask2 == 16) {
            return 16;
        }
        if (mask1 == 32 || mask2 == 32) {
            return 32;
        }
        if (mask1 == 64 || mask2 == 64) {
            return 64;
        }
        if (mask1 == 1 || mask2 == 1) {
            return 1;
        }
        return null;
    }

    private boolean needRevoke(Sid sid, String name, String type) {
        if (type.equals("user") && sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal().equals(name);
        }
        if (type.equals("group") && sid instanceof GrantedAuthoritySid) {
            return ((GrantedAuthoritySid)sid).getGrantedAuthority().equals(name);
        }
        return false;
    }
}

