/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.KafkaConfigService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.StreamingService;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.HiveSourceTableLoader;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityJob;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityUpdateJob;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="tableService")
public class TableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StreamingService streamingService;
    @Autowired
    private KafkaConfigService kafkaConfigService;

    public List<TableDesc> getTableDescByProject(String project, boolean withExt) throws IOException {
        List<TableDesc> tables = this.getProjectManager().listDefinedTables(project);
        if (null == tables) {
            return Collections.emptyList();
        }
        if (withExt) {
            tables = this.cloneTableDesc(tables);
        }
        return tables;
    }

    public TableDesc getTableDescByName(String tableName, boolean withExt) {
        TableDesc table = this.getMetadataManager().getTableDesc(tableName);
        if (withExt) {
            table = this.cloneTableDesc(table);
        }
        return table;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String[] loadHiveTablesToProject(String[] tables, String project) throws IOException {
        Set loaded = HiveSourceTableLoader.loadHiveTables((String[])tables, (KylinConfig)this.getConfig());
        String[] result = loaded.toArray(new String[loaded.size()]);
        this.syncTableToProject(result, project);
        return result;
    }

    private void unLoadHiveTable(String tableName) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        MetadataManager metaMgr = MetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        metaMgr.removeSourceTable(tableName);
        metaMgr.removeTableExt(tableName);
    }

    private void syncTableToProject(String[] tables, String project) throws IOException {
        this.getProjectManager().addTableDescToProject(tables, project);
    }

    private void removeTableFromProject(String tableName, String projectName) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        this.getProjectManager().removeTableDescFromProject(tableName, projectName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean unLoadHiveTable(String tableName, String project) {
        boolean rtn = false;
        int tableType = 0;
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc desc = this.getMetadataManager().getTableDesc(tableName);
        if (desc == null) {
            return false;
        }
        tableType = desc.getSourceType();
        try {
            if (this.modelService.isTableInModel(tableName, project)) {
                List<String> models = this.modelService.getModelsUsingTable(tableName, project);
                throw new InternalErrorException("Table is already in use by models " + models);
            }
            this.removeTableFromProject(tableName, project);
            rtn = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!this.projectService.isTableInAnyProject(tableName) && !this.modelService.isTableInAnyModel(tableName)) {
            try {
                this.unLoadHiveTable(tableName);
                rtn = true;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                rtn = false;
            }
        }
        if (tableType == 1 && !this.projectService.isTableInAnyProject(tableName) && !this.modelService.isTableInAnyModel(tableName)) {
            StreamingConfig config = null;
            KafkaConfig kafkaConfig = null;
            try {
                config = this.streamingService.getStreamingManager().getStreamingConfig(tableName);
                kafkaConfig = this.kafkaConfigService.getKafkaConfig(tableName);
                this.streamingService.dropStreamingConfig(config);
                this.kafkaConfigService.dropKafkaConfig(kafkaConfig);
                rtn = true;
            }
            catch (Exception e) {
                rtn = false;
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return rtn;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addStreamingTable(TableDesc desc, String project) throws IOException {
        desc.setUuid(UUID.randomUUID().toString());
        this.getMetadataManager().saveSourceTable(desc);
        this.syncTableToProject(new String[]{desc.getIdentity()}, project);
    }

    public List<String> getHiveDbNames() throws Exception {
        IHiveClient hiveClient = HiveClientFactory.getHiveClient();
        List results = hiveClient.getHiveDbNames();
        return results;
    }

    public List<String> getHiveTableNames(String database) throws Exception {
        IHiveClient hiveClient = HiveClientFactory.getHiveClient();
        List results = hiveClient.getHiveTableNames(database);
        return results;
    }

    private TableDescResponse cloneTableDesc(TableDesc table) {
        TableExtDesc tableExtDesc = this.getMetadataManager().getTableExt(table.getIdentity());
        TableDescResponse rtableDesc = new TableDescResponse(table);
        HashMap<String, Long> cardinality = new HashMap<String, Long>();
        HashMap<String, String> dataSourceProp = new HashMap<String, String>();
        String scard = tableExtDesc.getCardinality();
        if (!StringUtils.isEmpty((String)scard)) {
            String[] cards = StringUtils.split((String)scard, (String)",");
            ColumnDesc[] cdescs = rtableDesc.getColumns();
            for (int i = 0; i < cdescs.length; ++i) {
                ColumnDesc columnDesc = cdescs[i];
                if (cards.length <= i) {
                    logger.error("The result cardinality is not identical with hive table metadata, cardinality : " + scard + " column array length: " + cdescs.length);
                    break;
                }
                cardinality.put(columnDesc.getName(), Long.parseLong(cards[i]));
            }
            rtableDesc.setCardinality(cardinality);
        }
        dataSourceProp.putAll(tableExtDesc.getDataSourceProp());
        rtableDesc.setDescExd(dataSourceProp);
        return rtableDesc;
    }

    private List<TableDesc> cloneTableDesc(List<TableDesc> tables) throws IOException {
        ArrayList<TableDesc> descs = new ArrayList<TableDesc>();
        for (TableDesc table : tables) {
            TableDescResponse rtableDesc = this.cloneTableDesc(table);
            descs.add(rtableDesc);
        }
        return descs;
    }

    @PreAuthorize(value="hasRole('ROLE_MODELER') or hasRole('ROLE_ADMIN')")
    public void calculateCardinalityIfNotPresent(String[] tables, String submitter) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        ExecutableManager exeMgt = ExecutableManager.getInstance((KylinConfig)this.getConfig());
        for (String table : tables) {
            TableExtDesc tableExtDesc = metaMgr.getTableExt(table);
            String jobID = tableExtDesc.getJodID();
            if (null != jobID && ExecutableState.RUNNING == exeMgt.getOutput(jobID).getState()) continue;
            this.calculateCardinality(table, submitter);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_MODELER') or hasRole('ROLE_ADMIN')")
    public void calculateCardinality(String tableName, String submitter) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc table = this.getMetadataManager().getTableDesc(tableName);
        TableExtDesc tableExt = this.getMetadataManager().getTableExt(tableName);
        if (table == null) {
            IllegalArgumentException e = new IllegalArgumentException("Cannot find table descriptor " + tableName);
            logger.error("Cannot find table descriptor " + tableName, (Throwable)e);
            throw e;
        }
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        job.setParam("segmentId", tableName);
        job.setName("Hive Column Cardinality calculation for table '" + tableName + "'");
        job.setSubmitter(submitter);
        String outPath = this.getConfig().getHdfsWorkingDirectory() + "cardinality/" + job.getId() + "/" + tableName;
        String param = "-table " + tableName + " -output " + outPath;
        MapReduceExecutable step1 = new MapReduceExecutable();
        step1.setMapReduceJobClass(HiveColumnCardinalityJob.class);
        step1.setMapReduceParams(param);
        step1.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step1);
        HadoopShellExecutable step2 = new HadoopShellExecutable();
        step2.setJobClass(HiveColumnCardinalityUpdateJob.class);
        step2.setJobParams(param);
        step2.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step2);
        tableExt.setJodID(job.getId());
        this.getMetadataManager().saveTableExt(tableExt);
        this.getExecutableManager().addJob((AbstractExecutable)job);
    }

    public String normalizeHiveTableName(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        return (dbTableName[0] + "." + dbTableName[1]).toUpperCase();
    }
}

