/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.service.BasicService;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.stereotype.Component;

@Component(value="streamingMgmtService")
public class StreamingService
extends BasicService {
    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<StreamingConfig> listAllStreamingConfigs(String table) throws IOException {
        ArrayList<StreamingConfig> streamingConfigs = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)table)) {
            streamingConfigs = this.getStreamingManager().listAllStreaming();
        } else {
            StreamingConfig config = this.getStreamingManager().getConfig(table);
            if (config != null) {
                streamingConfigs.add(config);
            }
        }
        return streamingConfigs;
    }

    public List<StreamingConfig> getStreamingConfigs(String table, Integer limit, Integer offset) throws IOException {
        List<StreamingConfig> streamingConfigs = this.listAllStreamingConfigs(table);
        if (limit == null || offset == null) {
            return streamingConfigs;
        }
        if (streamingConfigs.size() - offset < limit) {
            return streamingConfigs.subList(offset, streamingConfigs.size());
        }
        return streamingConfigs.subList(offset, offset + limit);
    }

    public StreamingConfig createStreamingConfig(StreamingConfig config) throws IOException {
        if (this.getStreamingManager().getStreamingConfig(config.getName()) != null) {
            throw new InternalErrorException("The streamingConfig named " + config.getName() + " already exists");
        }
        StreamingConfig streamingConfig = this.getStreamingManager().saveStreamingConfig(config);
        return streamingConfig;
    }

    public StreamingConfig updateStreamingConfig(StreamingConfig config) throws IOException {
        return this.getStreamingManager().updateStreamingConfig(config);
    }

    public void dropStreamingConfig(StreamingConfig config) throws IOException {
        this.getStreamingManager().removeStreamingConfig(config);
    }
}

