/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class KylinAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(KylinAuthenticationProvider.class);
    @Autowired
    UserService userService;
    @Autowired
    private CacheManager cacheManager;
    private AuthenticationProvider authenticationProvider;
    MessageDigest md = null;

    public KylinAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"The embedded authenticationProvider should not be null.");
        this.authenticationProvider = authenticationProvider;
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to init Message Digest ", e);
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authed = null;
        Cache userCache = this.cacheManager.getCache("UserCache");
        this.md.reset();
        byte[] hashKey = this.md.digest((authentication.getName() + authentication.getCredentials()).getBytes());
        String userKey = Arrays.toString(hashKey);
        Element authedUser = userCache.get((Serializable)((Object)userKey));
        if (null != authedUser) {
            authed = (Authentication)authedUser.getObjectValue();
            SecurityContextHolder.getContext().setAuthentication(authed);
        } else {
            try {
                authed = this.authenticationProvider.authenticate(authentication);
                userCache.put(new Element((Serializable)((Object)userKey), (Serializable)authed));
            }
            catch (AuthenticationException e) {
                logger.error("Failed to auth user: " + authentication.getName(), (Throwable)e);
                throw e;
            }
            logger.debug("Authenticated user " + authed.toString());
            if (authed.getDetails() == null) {
                throw new UsernameNotFoundException("User not found in LDAP, check whether he/she has been added to the groups.");
            }
            Object user = authed.getDetails() instanceof UserDetails ? (UserDetails)authed.getDetails() : new User(authentication.getName(), "skippped-ldap", authed.getAuthorities());
            Assert.notNull((Object)user, (String)"The UserDetail is null.");
            logger.debug("User authorities :" + user.getAuthorities());
            if (!this.userService.userExists(user.getUsername())) {
                this.userService.createUser((UserDetails)user);
            } else {
                this.userService.updateUser((UserDetails)user);
            }
        }
        return authed;
    }

    public boolean supports(Class<?> authentication) {
        return this.authenticationProvider.supports(authentication);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

