/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.metrics.QueryMetrics;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryMetricsFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetricsFacade.class);
    private static boolean enabled = false;
    private static ConcurrentHashMap<String, QueryMetrics> metricsMap = new ConcurrentHashMap();

    public static void init() {
        enabled = KylinConfig.getInstanceFromEnv().getQueryMetricsEnabled();
        if (!enabled) {
            return;
        }
        DefaultMetricsSystem.initialize((String)"Kylin");
    }

    public static void updateMetrics(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!enabled) {
            return;
        }
        String projectName = sqlRequest.getProject();
        String cubeName = sqlResponse.getCube();
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics("Server_Total"), sqlResponse);
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(projectName), sqlResponse);
        String cubeMetricName = projectName + ",sub=" + cubeName;
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(cubeMetricName), sqlResponse);
    }

    private static void update(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        try {
            QueryMetricsFacade.incrQueryCount(queryMetrics, sqlResponse);
            QueryMetricsFacade.incrCacheHitCount(queryMetrics, sqlResponse);
            if (!sqlResponse.getIsException()) {
                queryMetrics.addQueryLatency(sqlResponse.getDuration());
                queryMetrics.addScanRowCount(sqlResponse.getTotalScanCount());
                queryMetrics.addResultRowCount(sqlResponse.getResults().size());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void incrQueryCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (!sqlResponse.isHitExceptionCache() && !sqlResponse.getIsException()) {
            queryMetrics.incrQuerySuccessCount();
        } else {
            queryMetrics.incrQueryFailCount();
        }
        queryMetrics.incrQueryCount();
    }

    private static void incrCacheHitCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (sqlResponse.isStorageCacheUsed()) {
            queryMetrics.addCacheHitCount(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryMetrics getQueryMetrics(String name) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] intervals = config.getQueryMetricsPercentilesIntervals();
        QueryMetrics queryMetrics = metricsMap.get(name);
        if (queryMetrics != null) {
            return queryMetrics;
        }
        Class<QueryMetricsFacade> clazz = QueryMetricsFacade.class;
        synchronized (QueryMetricsFacade.class) {
            queryMetrics = metricsMap.get(name);
            if (queryMetrics != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            try {
                queryMetrics = new QueryMetrics(intervals).registerWith(name);
                metricsMap.put(name, queryMetrics);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            catch (MetricsException e) {
                logger.warn(name + " register error: ", (Throwable)e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return queryMetrics;
        }
    }
}

