/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.EncodingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/encodings"})
public class EncodingController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(EncodingController.class);
    @Autowired
    private EncodingService encodingService;

    @RequestMapping(value={"valid_encodings"}, method={RequestMethod.GET})
    @ResponseBody
    public EnvelopeResponse getValidEncodings() {
        HashSet allDatatypes = Sets.newHashSet();
        allDatatypes.addAll(DataType.DATETIME_FAMILY);
        allDatatypes.addAll(DataType.INTEGER_FAMILY);
        allDatatypes.addAll(DataType.NUMBER_FAMILY);
        allDatatypes.addAll(DataType.STRING_FAMILY);
        HashMap datatypeValidEncodings = Maps.newHashMap();
        for (String dataTypeStr : allDatatypes) {
            datatypeValidEncodings.put(dataTypeStr, this.encodingService.getValidEncodings(DataType.getType((String)dataTypeStr)));
        }
        return new EnvelopeResponse("000", datatypeValidEncodings, "");
    }
}

