/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.request.CubeRequest;
import org.apache.kylin.rest.request.JobBuildRequest;
import org.apache.kylin.rest.request.JobBuildRequest2;
import org.apache.kylin.rest.response.GeneralResponse;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.source.kafka.util.KafkaClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cubes"})
public class CubeController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(CubeController.class);
    private static final char[] VALID_CUBENAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_".toCharArray();
    @Autowired
    private CubeService cubeService;
    @Autowired
    private JobService jobService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public List<CubeInstance> getCubes(@RequestParam(value="cubeName", required=false) String cubeName, @RequestParam(value="modelName", required=false) String modelName, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        int coffset;
        List<CubeInstance> cubes = this.cubeService.listAllCubes(cubeName, projectName, modelName);
        int climit = null == limit ? cubes.size() : limit.intValue();
        int n = coffset = null == offset ? 0 : offset;
        if (cubes.size() <= coffset) {
            return Collections.emptyList();
        }
        if (cubes.size() - coffset < climit) {
            return cubes.subList(coffset, cubes.size());
        }
        return cubes.subList(coffset, coffset + climit);
    }

    @RequestMapping(value={"validEncodings"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Integer> getValidEncodings() {
        Map encodings;
        try {
            encodings = DimensionEncodingFactory.getValidEncodings();
        }
        catch (Exception e) {
            logger.error("Error when getting valid encodings", (Throwable)e);
            return Maps.newHashMap();
        }
        return encodings;
    }

    @RequestMapping(value={"/{cubeName}"}, method={RequestMethod.GET})
    @ResponseBody
    public CubeInstance getCube(@PathVariable String cubeName) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube == null) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        return cube;
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}/sql"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralResponse getSql(@PathVariable String cubeName, @PathVariable String segmentName) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        IJoinedFlatTableDesc flatTableDesc = EngineFactory.getJoinedFlatTableDesc((CubeDesc)cube.getDescriptor());
        String sql = JoinedFlatTable.generateSelectDataStatement((IJoinedFlatTableDesc)flatTableDesc);
        GeneralResponse repsonse = new GeneralResponse();
        repsonse.setProperty("sql", sql);
        return repsonse;
    }

    @RequestMapping(value={"/{cubeName}/notify_list"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateNotifyList(@PathVariable String cubeName, @RequestBody List<String> notifyList) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube == null) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        try {
            this.cubeService.updateCubeNotifyList(cube, notifyList);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{cubeName}/cost"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance updateCubeCost(@PathVariable String cubeName, @RequestParam(value="cost") int cost) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube == null) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        try {
            return this.cubeService.updateCubeCost(cube, cost);
        }
        catch (Exception e) {
            String message = "Failed to update cube cost: " + cubeName + " : " + cost;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}/refresh_lookup"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance rebuildLookupSnapshot(@PathVariable String cubeName, @PathVariable String segmentName, @RequestParam(value="lookupTable") String lookupTable) {
        try {
            CubeManager cubeMgr = this.cubeService.getCubeManager();
            CubeInstance cube = cubeMgr.getCube(cubeName);
            return this.cubeService.rebuildLookupSnapshot(cube, segmentName, lookupTable);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public CubeInstance deleteSegment(@PathVariable String cubeName, @PathVariable String segmentName) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube == null) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        CubeSegment segment = cube.getSegment(segmentName, null);
        if (segment == null) {
            throw new InternalErrorException("Cannot find segment '" + segmentName + "'");
        }
        try {
            return this.cubeService.deleteSegment(cube, segmentName);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{cubeName}/build"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance build(@PathVariable String cubeName, @RequestBody JobBuildRequest req) {
        return this.rebuild(cubeName, req);
    }

    @RequestMapping(value={"/{cubeName}/rebuild"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance rebuild(@PathVariable String cubeName, @RequestBody JobBuildRequest req) {
        return this.buildInternal(cubeName, req.getStartTime(), req.getEndTime(), 0L, 0L, null, null, req.getBuildType(), req.isForce() || req.isForceMergeEmptySegment());
    }

    @RequestMapping(value={"/{cubeName}/build2"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance build2(@PathVariable String cubeName, @RequestBody JobBuildRequest2 req) {
        boolean existKafkaClient = false;
        try {
            Class<?> clazz = Class.forName("org.apache.kafka.clients.consumer.KafkaConsumer");
            if (clazz != null) {
                existKafkaClient = true;
            }
        }
        catch (ClassNotFoundException e) {
            existKafkaClient = false;
        }
        if (!existKafkaClient) {
            throw new InternalErrorException("Could not find Kafka dependency");
        }
        return this.rebuild2(cubeName, req);
    }

    @RequestMapping(value={"/{cubeName}/rebuild2"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance rebuild2(@PathVariable String cubeName, @RequestBody JobBuildRequest2 req) {
        return this.buildInternal(cubeName, 0L, 0L, req.getSourceOffsetStart(), req.getSourceOffsetEnd(), req.getSourcePartitionOffsetStart(), req.getSourcePartitionOffsetEnd(), req.getBuildType(), req.isForce());
    }

    private JobInstance buildInternal(String cubeName, long startTime, long endTime, long startOffset, long endOffset, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, String buildType, boolean force) {
        try {
            String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
            CubeInstance cube = this.jobService.getCubeManager().getCube(cubeName);
            if (cube == null) {
                throw new InternalErrorException("Cannot find cube " + cubeName);
            }
            return this.jobService.submitJob(cube, startTime, endTime, startOffset, endOffset, sourcePartitionOffsetStart, sourcePartitionOffsetEnd, CubeBuildTypeEnum.valueOf((String)buildType), force, submitter);
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{cubeName}/disable"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance disableCube(@PathVariable String cubeName) {
        try {
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            if (cube == null) {
                throw new InternalErrorException("Cannot find cube " + cubeName);
            }
            return this.cubeService.disableCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to disable cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/purge"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance purgeCube(@PathVariable String cubeName) {
        try {
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            if (cube == null) {
                throw new InternalErrorException("Cannot find cube '" + cubeName + "'");
            }
            return this.cubeService.purgeCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to purge cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/clone"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance cloneCube(@PathVariable String cubeName, @RequestBody CubeRequest cubeRequest) {
        CubeInstance newCube;
        String newCubeName = cubeRequest.getCubeName();
        String project = cubeRequest.getProject();
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube == null) {
            throw new BadRequestException("Cannot find cube " + cubeName);
        }
        if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
            throw new BadRequestException("Broken cube can't be cloned");
        }
        if (!StringUtils.containsOnly((String)newCubeName, (char[])VALID_CUBENAME)) {
            logger.info("Invalid Cube name {}, only letters, numbers and underline supported.", (Object)newCubeName);
            throw new BadRequestException("Invalid Cube name, only letters, numbers and underline supported.");
        }
        CubeDesc cubeDesc = cube.getDescriptor();
        CubeDesc newCubeDesc = CubeDesc.getCopyOf((CubeDesc)cubeDesc);
        newCubeDesc.setName(newCubeName);
        try {
            newCube = this.cubeService.createCubeAndDesc(newCubeName, project, newCubeDesc);
            this.cubeService.getCubeDescManager().reloadCubeDescLocal(newCubeName);
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to clone cube ", e);
        }
        return newCube;
    }

    @RequestMapping(value={"/{cubeName}/enable"}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeInstance enableCube(@PathVariable String cubeName) {
        try {
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            if (null == cube) {
                throw new InternalErrorException("Cannot find cube " + cubeName);
            }
            return this.cubeService.enableCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to enable cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteCube(@PathVariable String cubeName) {
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (null == cube) {
            throw new NotFoundException("Cube with name " + cubeName + " not found..");
        }
        try {
            this.cubeService.deleteCube(cube);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to delete cube.  Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public CubeRequest saveCubeDesc(@RequestBody CubeRequest cubeRequest) {
        CubeDesc desc = this.deserializeCubeDesc(cubeRequest);
        if (desc == null) {
            cubeRequest.setMessage("CubeDesc is null.");
            return cubeRequest;
        }
        String name = desc.getName();
        if (StringUtils.isEmpty((String)name)) {
            logger.info("Cube name should not be empty.");
            throw new BadRequestException("Cube name should not be empty.");
        }
        if (!StringUtils.containsOnly((String)name, (char[])VALID_CUBENAME)) {
            logger.info("Invalid Cube name {}, only letters, numbers and underline supported.", (Object)name);
            throw new BadRequestException("Invalid Cube name, only letters, numbers and underline supported.");
        }
        try {
            desc.setUuid(UUID.randomUUID().toString());
            String projectName = null == cubeRequest.getProject() ? "DEFAULT" : cubeRequest.getProject();
            this.cubeService.createCubeAndDesc(name, projectName, desc);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        cubeRequest.setUuid(desc.getUuid());
        cubeRequest.setSuccessful(true);
        return cubeRequest;
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT})
    @ResponseBody
    public CubeRequest updateCubeDesc(@RequestBody CubeRequest cubeRequest) throws JsonProcessingException {
        CubeDesc desc = this.deserializeCubeDesc(cubeRequest);
        if (desc == null) {
            return cubeRequest;
        }
        String projectName = null == cubeRequest.getProject() ? "DEFAULT" : cubeRequest.getProject();
        try {
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeRequest.getCubeName());
            if (cube == null) {
                String error = "The cube named " + cubeRequest.getCubeName() + " does not exist ";
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            if (!cube.getDescriptor().getName().equalsIgnoreCase(desc.getName())) {
                String error = "Cube Desc renaming is not allowed: desc.getName(): " + desc.getName() + ", cubeRequest.getCubeName(): " + cubeRequest.getCubeName();
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            if (cube.getSegments().size() != 0 && !cube.getDescriptor().consistentWith(desc)) {
                String error = "CubeDesc " + desc.getName() + " is inconsistent with existing. Try purge that cube first or avoid updating key cube desc fields.";
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            desc = this.cubeService.updateCubeAndDesc(cube, desc, projectName, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException("You don't have right to update this cube.");
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request:" + e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request: " + e.getLocalizedMessage());
        }
        if (!desc.getError().isEmpty()) {
            this.updateRequest(cubeRequest, false, Joiner.on((String)"\n").join((Iterable)desc.getError()));
            return cubeRequest;
        }
        String descData = JsonUtil.writeValueAsIndentString((Object)desc);
        cubeRequest.setCubeDescData(descData);
        cubeRequest.setSuccessful(true);
        return cubeRequest;
    }

    @RequestMapping(value={"/{cubeName}/hbase"}, method={RequestMethod.GET})
    @ResponseBody
    public List<HBaseResponse> getHBaseInfo(@PathVariable String cubeName) {
        ArrayList<HBaseResponse> hbase = new ArrayList<HBaseResponse>();
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (null == cube) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        Segments segments = cube.getSegments();
        for (CubeSegment segment : segments) {
            String tableName = segment.getStorageLocationIdentifier();
            HBaseResponse hr = null;
            try {
                hr = this.cubeService.getHTableInfo(tableName);
            }
            catch (IOException e) {
                logger.error("Failed to calcuate size of HTable \"" + tableName + "\".", (Throwable)e);
            }
            if (null == hr) {
                logger.info("Failed to calcuate size of HTable \"" + tableName + "\".");
                hr = new HBaseResponse();
            }
            hr.setTableName(tableName);
            hr.setDateRangeStart(segment.getDateRangeStart());
            hr.setDateRangeEnd(segment.getDateRangeEnd());
            hr.setSegmentName(segment.getName());
            hr.setSegmentStatus(segment.getStatus().toString());
            hr.setSourceCount(segment.getInputRecords());
            if (segment.isSourceOffsetsOn()) {
                hr.setSourceOffsetStart(segment.getSourceOffsetStart());
                hr.setSourceOffsetEnd(segment.getSourceOffsetEnd());
            }
            hbase.add(hr);
        }
        return hbase;
    }

    @RequestMapping(value={"/{cubeName}/holes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CubeSegment> getHoles(@PathVariable String cubeName) {
        this.checkCubeName(cubeName);
        return this.cubeService.getCubeManager().calculateHoles(cubeName);
    }

    @RequestMapping(value={"/{cubeName}/holes"}, method={RequestMethod.PUT})
    @ResponseBody
    public List<JobInstance> fillHoles(@PathVariable String cubeName) {
        this.checkCubeName(cubeName);
        ArrayList jobs = Lists.newArrayList();
        List holes = this.cubeService.getCubeManager().calculateHoles(cubeName);
        if (holes.size() == 0) {
            logger.info("No hole detected for cube '" + cubeName + "'");
            return jobs;
        }
        boolean isOffsetOn = ((CubeSegment)holes.get(0)).isSourceOffsetsOn();
        for (CubeSegment hole : holes) {
            JobInstance job;
            Object request;
            if (isOffsetOn) {
                request = new JobBuildRequest2();
                ((JobBuildRequest2)request).setBuildType(CubeBuildTypeEnum.BUILD.toString());
                ((JobBuildRequest2)request).setSourceOffsetStart(hole.getSourceOffsetStart());
                ((JobBuildRequest2)request).setSourcePartitionOffsetStart(hole.getSourcePartitionOffsetStart());
                ((JobBuildRequest2)request).setSourceOffsetEnd(hole.getSourceOffsetEnd());
                ((JobBuildRequest2)request).setSourcePartitionOffsetEnd(hole.getSourcePartitionOffsetEnd());
                try {
                    job = this.build2(cubeName, (JobBuildRequest2)request);
                    jobs.add(job);
                }
                catch (Exception e) {
                    logger.info("Error to submit job for hole '" + hole.toString() + "', skip it now.", (Throwable)e);
                }
                continue;
            }
            request = new JobBuildRequest();
            ((JobBuildRequest)request).setBuildType(CubeBuildTypeEnum.BUILD.toString());
            ((JobBuildRequest)request).setStartTime(hole.getDateRangeStart());
            ((JobBuildRequest)request).setEndTime(hole.getDateRangeEnd());
            try {
                job = this.build(cubeName, (JobBuildRequest)request);
                jobs.add(job);
            }
            catch (Exception e) {
                logger.info("Error to submit job for hole '" + hole.toString() + "', skip it now.", (Throwable)e);
            }
        }
        return jobs;
    }

    @RequestMapping(value={"/{cubeName}/init_start_offsets"}, method={RequestMethod.PUT})
    @ResponseBody
    public GeneralResponse initStartOffsets(@PathVariable String cubeName) {
        this.checkCubeName(cubeName);
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance.getSourceType() != 1) {
            String msg = "Cube '" + cubeName + "' is not a Streaming Cube.";
            throw new IllegalArgumentException(msg);
        }
        GeneralResponse response = new GeneralResponse();
        try {
            Map startOffsets = KafkaClient.getLatestOffsets((CubeInstance)cubeInstance);
            CubeDesc desc = cubeInstance.getDescriptor();
            desc.setPartitionOffsetStart(startOffsets);
            this.cubeService.getCubeDescManager().updateCubeDesc(desc);
            response.setProperty("result", "success");
            response.setProperty("offsets", startOffsets.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    @RequestMapping(value={"aggregationgroups/cuboid"}, method={RequestMethod.POST})
    @ResponseBody
    public long calculateCuboidCombination(@RequestBody String aggregationGroupStr) {
        AggregationGroup aggregationGroup = this.deserializeAggregationGroup(aggregationGroupStr);
        if (aggregationGroup != null) {
            return aggregationGroup.calculateCuboidCombination();
        }
        return -1L;
    }

    private CubeDesc deserializeCubeDesc(CubeRequest cubeRequest) {
        CubeDesc desc = null;
        try {
            logger.debug("Saving cube " + cubeRequest.getCubeDescData());
            desc = (CubeDesc)JsonUtil.readValue((String)cubeRequest.getCubeDescData(), CubeDesc.class);
        }
        catch (JsonParseException e) {
            logger.error("The cube definition is not valid.", (Throwable)e);
            this.updateRequest(cubeRequest, false, e.getMessage());
        }
        catch (JsonMappingException e) {
            logger.error("The cube definition is not valid.", (Throwable)e);
            this.updateRequest(cubeRequest, false, e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return desc;
    }

    private AggregationGroup deserializeAggregationGroup(String aggregationGroupStr) {
        AggregationGroup aggreationGroup = null;
        try {
            logger.debug("Parsing AggregationGroup " + aggregationGroupStr);
            aggreationGroup = (AggregationGroup)JsonUtil.readValue((String)aggregationGroupStr, AggregationGroup.class);
        }
        catch (JsonParseException e) {
            logger.error("The AggregationGroup definition is not valid.", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("The AggregationGroup definition is not valid.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return aggreationGroup;
    }

    private void updateRequest(CubeRequest request, boolean success, String message) {
        request.setCubeDescData("");
        request.setSuccessful(success);
        request.setMessage(message);
    }

    private void checkCubeName(String cubeName) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        String msg = "";
        if (cubeInstance == null) {
            msg = "Cube '" + cubeName + "' not found.";
            throw new IllegalArgumentException(msg);
        }
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

