/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.List;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.service.AccessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/access"})
public class AccessController
extends BasicController {
    @Autowired
    private AccessService accessService;

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AccessEntryResponse> getAccessEntities(@PathVariable String type, @PathVariable String uuid) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Acl acl = this.accessService.getAcl((AclEntity)ae);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AccessEntryResponse> grant(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Sid sid = this.accessService.getSid(accessRequest.getSid(), accessRequest.isPrincipal());
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        Acl acl = this.accessService.grant((AclEntity)ae, permission, sid);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.PUT})
    @ResponseBody
    public List<AccessEntryResponse> update(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        Acl acl = this.accessService.update((AclEntity)ae, accessRequest.getAccessEntryId(), permission);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.DELETE})
    public List<AccessEntryResponse> revoke(@PathVariable String type, @PathVariable String uuid, AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Acl acl = this.accessService.revoke((AclEntity)ae, accessRequest.getAccessEntryId());
        return this.accessService.generateAceResponses(acl);
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }
}

