/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.QueryModelPriorities;

public class ModelTree {
    private final Collection<OlapContext> olapContexts;
    private final Map<String, JoinTableDesc> joins;
    private final Map<TableRef, String> tableRefAliasMap;
    private final TableDesc rootFactTable;
    private final boolean hasModelPropertiesHint;

    public ModelTree(TableDesc rootFactTable, Collection<OlapContext> contexts, Map<String, JoinTableDesc> joins, Map<TableRef, String> tableRefAliasMap) {
        this.rootFactTable = rootFactTable;
        this.olapContexts = contexts;
        this.joins = joins;
        this.tableRefAliasMap = tableRefAliasMap;
        this.hasModelPropertiesHint = this.hasModelPropertiesHint(contexts);
    }

    public ModelTree(TableDesc rootFactTable, Collection<OlapContext> contexts, Map<String, JoinTableDesc> joins) {
        this.rootFactTable = rootFactTable;
        this.olapContexts = contexts;
        this.joins = joins;
        this.tableRefAliasMap = Maps.newHashMap();
        this.hasModelPropertiesHint = this.hasModelPropertiesHint(contexts);
    }

    public JoinsGraph getJoinGraph(TableRef defaultFactTable) {
        ArrayList modelTreeJoins = Lists.newArrayListWithExpectedSize((int)this.joins.size());
        TableRef factTblRef = null;
        if (this.joins.isEmpty()) {
            factTblRef = defaultFactTable;
        } else {
            HashMap joinMap = Maps.newHashMap();
            this.joins.values().forEach(joinTableDesc -> {
                modelTreeJoins.add(joinTableDesc.getJoin());
                joinMap.put(joinTableDesc.getJoin().getPKSide(), joinTableDesc.getJoin().getFKSide());
            });
            for (Map.Entry joinEntry : joinMap.entrySet()) {
                if (joinMap.containsKey(joinEntry.getValue())) continue;
                factTblRef = (TableRef)joinEntry.getValue();
                break;
            }
        }
        return new JoinsGraph(factTblRef, (List)modelTreeJoins);
    }

    private boolean hasSameRootFactTable(TableRef tableRef) {
        return tableRef.getTableIdentity().equals(this.rootFactTable.getIdentity());
    }

    public boolean isExactlyMatch(NDataModel dataModel, boolean partialMatch, boolean partialMatchNonEqui) {
        TableRef tableRef = dataModel.getRootFactTable();
        return this.hasSameRootFactTable(tableRef) && this.getJoinGraph(tableRef).match(dataModel.getJoinsGraph(), (Map)Maps.newHashMap(), partialMatch, partialMatchNonEqui);
    }

    public boolean hasSameSubGraph(NDataModel dataModel) {
        TableRef tableRef = dataModel.getRootFactTable();
        JoinsGraph joinsGraph = this.getJoinGraph(tableRef);
        return this.hasSameRootFactTable(tableRef) && (dataModel.getJoinsGraph().match(joinsGraph, (Map)Maps.newHashMap()) || joinsGraph.match(dataModel.getJoinsGraph(), (Map)Maps.newHashMap()));
    }

    private boolean hasModelPropertiesHint(Collection<OlapContext> olapContexts) {
        for (OlapContext sqlContext : olapContexts) {
            Object[] modelPriorities = QueryModelPriorities.getModelPrioritiesFromComment((String)sqlContext.getSql());
            if (StringUtils.join((Object[])modelPriorities).equals("")) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        HashSet<Object> othTableRefAliasSet;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModelTree)) {
            return false;
        }
        ModelTree other = (ModelTree)obj;
        if (!this.hasModelPropertiesHint || !other.hasModelPropertiesHint) {
            return false;
        }
        if (this.olapContexts.size() != other.olapContexts.size()) {
            return false;
        }
        OlapContext[] contextsArray = this.olapContexts.toArray(new OlapContext[0]);
        OlapContext[] othContextsArray = other.olapContexts.toArray(new OlapContext[0]);
        for (int i = 0; i < contextsArray.length; ++i) {
            if (contextsArray[i].getSQLDigest().equalsWithoutAlias(othContextsArray[i].getSQLDigest())) continue;
            return false;
        }
        if (!this.joins.equals(other.joins)) {
            return false;
        }
        if (this.tableRefAliasMap.size() != other.tableRefAliasMap.size()) {
            return false;
        }
        HashSet<Object> tableRefAliasSet = new HashSet<Object>(Arrays.asList(this.tableRefAliasMap.values().toArray()));
        if (!tableRefAliasSet.equals(othTableRefAliasSet = new HashSet<Object>(Arrays.asList(other.tableRefAliasMap.values().toArray())))) {
            return false;
        }
        return this.rootFactTable.equals((Object)other.rootFactTable);
    }

    public int hashCode() {
        return Objects.hash(this.olapContexts.size(), this.joins, this.tableRefAliasMap.size(), this.rootFactTable, this.hasModelPropertiesHint);
    }

    @Generated
    public Collection<OlapContext> getOlapContexts() {
        return this.olapContexts;
    }

    @Generated
    public Map<String, JoinTableDesc> getJoins() {
        return this.joins;
    }

    @Generated
    public Map<TableRef, String> getTableRefAliasMap() {
        return this.tableRefAliasMap;
    }

    @Generated
    public TableDesc getRootFactTable() {
        return this.rootFactTable;
    }

    @Generated
    public boolean isHasModelPropertiesHint() {
        return this.hasModelPropertiesHint;
    }
}

