/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.aspect.WaitForSyncBeforeRPC;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.OpenBatchApproveRecItemsRequest;
import org.apache.kylin.rest.request.OpenSqlAccelerateRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OpenAccSqlResponse;
import org.apache.kylin.rest.response.OpenRecApproveResponse;
import org.apache.kylin.rest.response.OpenSuggestionResponse;
import org.apache.kylin.rest.service.ModelRecService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.OptRecApproveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenModelRecController
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger(OpenModelRecController.class);
    @Autowired
    private ModelRecService modelRecService;
    @Autowired
    private OptRecApproveService optRecApproveService;
    @Autowired
    private ModelService modelService;

    protected Logger getLogger() {
        return logger;
    }

    @ApiOperation(value="batchApproveRecommendations", tags={"AI"})
    @PutMapping(value={"/recommendations/batch"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OpenRecApproveResponse> batchApproveRecommendations(@RequestBody OpenBatchApproveRecItemsRequest request) {
        this.checkRequiredArg("filter_by_models", request.isFilterByModes());
        String projectName = this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(projectName);
        boolean filterByModels = request.isFilterByModes();
        if (request.getRecActionType() == null || StringUtils.isEmpty((CharSequence)request.getRecActionType().trim())) {
            request.setRecActionType("all");
        }
        ArrayList modelIds = Lists.newArrayList();
        if (filterByModels) {
            if (CollectionUtils.isEmpty((Collection)request.getModelNames())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_EMPTY, new Object[0]);
            }
            for (String modelName : request.getModelNames()) {
                modelIds.add(this.modelService.getModel(modelName, projectName).getUuid());
            }
        }
        List approvedModelIndexes = this.optRecApproveService.batchApprove(projectName, (List)modelIds, request.getRecActionType(), filterByModels, request.isDiscardTableIndex());
        return new EnvelopeResponse("000", (Object)new OpenRecApproveResponse(projectName, approvedModelIndexes), "");
    }

    @ApiOperation(value="suggestModels", tags={"AI"})
    @PostMapping(value={"/model_suggestion"})
    @ResponseBody
    public EnvelopeResponse<OpenSuggestionResponse> suggestModels(@RequestBody OpenSqlAccelerateRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        OpenModelRecController.checkSqlIsNotNull((List)request.getSqls());
        if (request.isWithModelOnline() && !request.isWithEmptySegment()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NOT_EXIST_SEGMENTS, new Object[0]);
        }
        request.setProject(projectName);
        this.checkProjectNotSemiAuto(request.getProject());
        request.setForce2CreateNewModel(Boolean.valueOf(true));
        request.setAcceptRecommendation(true);
        return new EnvelopeResponse("000", (Object)this.modelRecService.suggestOrOptimizeModels(request), "");
    }

    @ApiOperation(value="optimizeModels", tags={"AI"})
    @PostMapping(value={"/model_optimization"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OpenSuggestionResponse> optimizeModels(@RequestBody OpenSqlAccelerateRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        OpenModelRecController.checkSqlIsNotNull((List)request.getSqls());
        request.setProject(projectName);
        this.checkProjectNotSemiAuto(request.getProject());
        OpenModelRecController.checkNotEmpty((List)request.getSqls());
        request.setForce2CreateNewModel(Boolean.valueOf(false));
        request.setWithOptimalModel(true);
        return new EnvelopeResponse("000", (Object)this.modelRecService.suggestOrOptimizeModels(request), "");
    }

    @ApiOperation(value="/accelerateSql", tags={"AI"})
    @PostMapping(value={"/accelerate_sqls", "/sql_acceleration"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OpenAccSqlResponse> accelerateSqls(@RequestBody OpenSqlAccelerateRequest request) {
        String projectName = this.checkProjectName(request.getProject());
        OpenModelRecController.checkSqlIsNotNull((List)request.getSqls());
        request.setProject(projectName);
        request.setForce2CreateNewModel(Boolean.valueOf(false));
        request.setWithOptimalModel(true);
        this.checkProjectNotSemiAuto(request.getProject());
        return new EnvelopeResponse("000", (Object)this.modelRecService.suggestAndOptimizeModels(request), "");
    }
}

