/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.sql.SQLException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.util.CalcitePlanRouterVisitor;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;

public class QueryHelper {
    static final String RUN_CONSTANT_QUERY_LOCALLY = "kylin.query.engine.run-constant-query-locally";

    private QueryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset<Row> singleQuery(String sql, String project) throws SQLException {
        String prevRunLocalConf = Unsafe.setProperty((String)RUN_CONSTANT_QUERY_LOCALLY, (String)"FALSE");
        try {
            KylinConfigExt projectKylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getConfig();
            QueryExec queryExec = new QueryExec(project, (KylinConfig)projectKylinConfig);
            QueryParams queryParams = new QueryParams(NProjectManager.getProjectConfig((String)project), sql, project, 0, 0, queryExec.getDefaultSchemaName(), true);
            String convertedSql = QueryUtil.massageSql((QueryParams)queryParams);
            queryExec.executeQuery(convertedSql);
        }
        finally {
            if (prevRunLocalConf == null) {
                Unsafe.clearProperty((String)RUN_CONSTANT_QUERY_LOCALLY);
            } else {
                Unsafe.setProperty((String)RUN_CONSTANT_QUERY_LOCALLY, (String)prevRunLocalConf);
            }
        }
        return SparderEnv.getDF();
    }

    public static Dataset<Row> sql(SparkSession session, String project, String sqlText) {
        try {
            return QueryHelper.singleQuery(sqlText, project);
        }
        catch (SQLException e) {
            return session.sql(sqlText);
        }
    }

    public static boolean isConstantQueryAndCalciteEngineCapable(RelNode rel) {
        return QueryHelper.isConstantQuery(rel) && QueryHelper.isCalciteEngineCapable(rel);
    }

    public static boolean isConstantQuery(RelNode rel) {
        if (TableScan.class.isAssignableFrom(rel.getClass())) {
            return false;
        }
        for (RelNode input : rel.getInputs()) {
            if (QueryHelper.isConstantQuery(input)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCalciteEngineCapable(RelNode rel) {
        if (rel instanceof Project) {
            Project projectRelNode = (Project)rel;
            if (projectRelNode.getProjects().stream().filter(RexCall.class::isInstance).anyMatch(pRelNode -> (Boolean)pRelNode.accept((RexVisitor)new CalcitePlanRouterVisitor()))) {
                return false;
            }
            if (projectRelNode.getProjects() != null && projectRelNode.getProjects().stream().anyMatch(QueryHelper::isPlusString)) {
                return false;
            }
        }
        if (rel instanceof OlapAggregateRel) {
            OlapAggregateRel aggregateRel = (OlapAggregateRel)rel;
            if (aggregateRel.getAggCallList().stream().anyMatch(aggCall -> "BITMAP_BUILD".equalsIgnoreCase(aggCall.getAggregation().getName()))) {
                return false;
            }
            if (aggregateRel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct)) {
                return false;
            }
        }
        return rel.getInputs().stream().allMatch(QueryHelper::isCalciteEngineCapable);
    }

    private static boolean isPlusString(RexNode node) {
        if (node instanceof RexCall) {
            RexCall rexCall = (RexCall)node;
            if ("plus".equals(rexCall.getOperator().getKind().lowerName)) {
                for (RexNode operand : rexCall.operands) {
                    if (operand.getType().getFamily() != SqlTypeFamily.STRING && operand.getType().getFamily() != SqlTypeFamily.CHARACTER) continue;
                    return true;
                }
            }
            return rexCall.getOperands().stream().anyMatch(QueryHelper::isPlusString);
        }
        return false;
    }
}

