/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapNonEquiJoinRel;
import org.apache.kylin.query.relnode.OlapRel;

public class OlapJoinRule
extends ConverterRule {
    private static final Set<Set<SqlOperator>> ALLOWED_PAIRS = ImmutableSet.of((Object)ImmutableSet.of((Object)SqlStdOperatorTable.GREATER_THAN, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL), (Object)ImmutableSet.of((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL), (Object)ImmutableSet.of((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.LESS_THAN));
    public static final ConverterRule INSTANCE = new OlapJoinRule();
    public static final ConverterRule NON_EQUI_INSTANCE = new OlapJoinRule(true, false);
    public static final ConverterRule EQUAL_NULL_SAFE_INSTANT = new OlapJoinRule(false, true);
    private static final ImmutableSet<SqlKind> SCD2_KINDS = ImmutableSet.of((Object)SqlKind.GREATER_THAN, (Object)SqlKind.LESS_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)SqlKind.LESS_THAN_OR_EQUAL);
    private final boolean isScd2Enabled;
    private final boolean joinCondEqualNullSafe;

    private SqlOperator inverse(SqlOperator operator) {
        if (operator.equals((Object)SqlStdOperatorTable.GREATER_THAN)) {
            return SqlStdOperatorTable.LESS_THAN;
        }
        if (operator.equals((Object)SqlStdOperatorTable.LESS_THAN)) {
            return SqlStdOperatorTable.GREATER_THAN;
        }
        if (operator.equals((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL)) {
            return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        }
        if (operator.equals((Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL)) {
            return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        }
        return null;
    }

    public OlapJoinRule() {
        this(false, false);
    }

    public OlapJoinRule(boolean isScd2Enabled, boolean joinCondEqualNullSafe) {
        super(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)OlapRel.CONVENTION, "OlapJoinRule");
        this.isScd2Enabled = isScd2Enabled;
        this.joinCondEqualNullSafe = joinCondEqualNullSafe;
    }

    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)OlapRel.CONVENTION);
        JoinInfo info = JoinInfo.of((RelNode)(left = left instanceof HepRelVertex ? left : OlapJoinRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().replace((RelTrait)OlapRel.CONVENTION))), (RelNode)(right = right instanceof HepRelVertex ? right : OlapJoinRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().replace((RelTrait)OlapRel.CONVENTION))), (RexNode)join.getCondition());
        Join tmpJoin = this.transformJoinCondition(join, info, traitSet, left, right);
        if (tmpJoin instanceof OlapJoinRel) {
            return tmpJoin;
        }
        try {
            RexBuilder rexBuilder = join.getCluster().getRexBuilder();
            RexNode cnfCondition = RexUtil.toCnf((RexBuilder)rexBuilder, (RexNode)join.getCondition());
            info = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)cnfCondition);
            boolean isSpecialNonEquivJoin = OlapJoinRule.isSpecialNonEquivJoin(join);
            if (!info.isEqui() || isSpecialNonEquivJoin) {
                boolean isScd2Rel;
                ArrayList scd2Refs = Lists.newArrayList();
                boolean bl = isScd2Rel = this.isScd2Enabled && this.isScd2JoinCondition(info, join, scd2Refs);
                if (!isSpecialNonEquivJoin && join.getJoinType() == JoinRelType.INNER && !isScd2Rel && this.hasEqualJoinPart(left, right, join.getCondition())) {
                    OlapJoinRel joinRel = new OlapJoinRel(join.getCluster(), traitSet, left, right, info.getEquiCondition(left, right, rexBuilder), join.getVariablesSet(), join.getJoinType());
                    joinRel.setJoinCondEqualNullSafe(this.joinCondEqualNullSafe);
                    RexNode rexNode = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)info.nonEquiConditions);
                    return rexNode.isAlwaysTrue() ? joinRel : new OlapFilterRel(join.getCluster(), joinRel.getTraitSet(), (RelNode)joinRel, rexNode);
                }
                RexNode joinCondition = this.normalizeCondition(rexBuilder, join.getCondition(), scd2Refs);
                return new OlapNonEquiJoinRel(join.getCluster(), traitSet, left, right, joinCondition, join.getVariablesSet(), join.getJoinType(), isScd2Rel);
            }
            OlapJoinRel joinRel = new OlapJoinRel(join.getCluster(), traitSet, left, right, info.getEquiCondition(left, right, rexBuilder), join.getVariablesSet(), join.getJoinType());
            joinRel.setJoinCondEqualNullSafe(this.joinCondEqualNullSafe);
            return joinRel;
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isSpecialNonEquivJoin(LogicalJoin join) {
        return RexUtil.findOperatorCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, (RexNode)join.getCondition()) != null;
    }

    private RexNode normalizeCondition(RexBuilder rexBuilder, RexNode cnfCondition, List<RexInputRef> scd2Refs) {
        if (scd2Refs.isEmpty() || !(cnfCondition instanceof RexCall)) {
            return cnfCondition;
        }
        ArrayList newNodes = Lists.newArrayList();
        List oriNodes = ((RexCall)cnfCondition).getOperands();
        Iterator iterator = oriNodes.iterator();
        while (iterator.hasNext()) {
            RexNode rexNode;
            RexNode invert = rexNode = (RexNode)iterator.next();
            if (SCD2_KINDS.contains((Object)rexNode.getKind())) {
                RexNode left = (RexNode)((RexCall)invert).getOperands().get(0);
                RexInputRef rexInputRef = this.extractInputRef(left);
                if (!scd2Refs.contains(rexInputRef)) {
                    invert = RexUtil.invert((RexBuilder)rexBuilder, (RexCall)((RexCall)rexNode));
                }
            } else {
                invert = this.normalizeCondition(rexBuilder, rexNode, scd2Refs);
            }
            if (invert == null) {
                invert = rexNode;
            }
            newNodes.add(invert);
        }
        if (!Objects.equals(((Object)newNodes).toString(), oriNodes.toString())) {
            return rexBuilder.makeCall(cnfCondition.getType(), ((RexCall)cnfCondition).getOperator(), (List)newNodes);
        }
        return cnfCondition;
    }

    private boolean hasEqualJoinPart(RelNode left, RelNode right, RexNode condition) {
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        ArrayList filterNulls = new ArrayList();
        RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, leftKeys, rightKeys, filterNulls);
        return !leftKeys.isEmpty() && !rightKeys.isEmpty();
    }

    private Join transformJoinCondition(LogicalJoin join, JoinInfo info, RelTraitSet traitSet, RelNode left, RelNode right) {
        List<RexInputRef> refs = this.isPowerBiInnerJoin(info, left.getCluster().getRexBuilder());
        if (refs.isEmpty()) {
            return join;
        }
        RelOptCluster cluster = join.getCluster();
        int index1 = refs.get(0).getIndex();
        int index2 = refs.get(1).getIndex();
        int leftIndex = Math.min(index1, index2);
        int rightIndex = Math.max(index1, index2);
        JoinInfo newInfo = JoinInfo.of((ImmutableIntList)ImmutableIntList.of((int[])new int[]{leftIndex}), (ImmutableIntList)ImmutableIntList.of((int[])new int[]{rightIndex -= left.getRowType().getFieldCount()}));
        try {
            return new OlapJoinRel(cluster, traitSet, left, right, newInfo.getEquiCondition(left, right, cluster.getRexBuilder()), join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<RexInputRef> isPowerBiInnerJoin(JoinInfo info, RexBuilder rexBuilder) {
        RexCall notNull2;
        RexCall notNull1;
        RexCall equalCall;
        RexCall notNullCall;
        RexCall twoNullCall;
        if (info.isEqui()) {
            return Collections.emptyList();
        }
        RexNode root = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)info.nonEquiConditions);
        if (!(root instanceof RexCall) || root.getKind() != SqlKind.OR) {
            return Collections.emptyList();
        }
        RexCall rootCall = (RexCall)root;
        if (rootCall.operands.size() != 2) {
            return Collections.emptyList();
        }
        if (!this.isOperandSqlAnd(rootCall, 0) || !this.isOperandSqlAnd(rootCall, 1)) {
            return Collections.emptyList();
        }
        RexCall leftCall = (RexCall)rootCall.operands.get(0);
        RexCall rightCall = (RexCall)rootCall.operands.get(1);
        if (this.isOperandSqlIsNull(leftCall, 0) && this.isOperandSqlIsNull(leftCall, 1)) {
            twoNullCall = leftCall;
            notNullCall = rightCall;
        } else if (this.isOperandSqlIsNull(rightCall, 0) && this.isOperandSqlIsNull(rightCall, 1)) {
            twoNullCall = rightCall;
            notNullCall = leftCall;
        } else {
            return Collections.emptyList();
        }
        RexCall isNull1 = (RexCall)twoNullCall.operands.get(0);
        RexCall isNull2 = (RexCall)twoNullCall.operands.get(1);
        if (!this.isOperandInputRef(isNull1, 0) || !this.isOperandInputRef(isNull2, 0)) {
            return Collections.emptyList();
        }
        HashSet refs = Sets.newHashSet((Object[])new RexInputRef[]{(RexInputRef)isNull1.operands.get(0), (RexInputRef)isNull2.operands.get(0)});
        if (refs.size() != 2) {
            return Collections.emptyList();
        }
        if (notNullCall.operands.size() != 3) {
            return Collections.emptyList();
        }
        if (this.isOperandSqlEq(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 1) && this.isOperandSqlIsNotNull(notNullCall, 2)) {
            equalCall = (RexCall)notNullCall.operands.get(0);
            notNull1 = (RexCall)notNullCall.operands.get(1);
            notNull2 = (RexCall)notNullCall.operands.get(2);
        } else if (this.isOperandSqlEq(notNullCall, 1) && this.isOperandSqlIsNotNull(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 2)) {
            equalCall = (RexCall)notNullCall.operands.get(1);
            notNull1 = (RexCall)notNullCall.operands.get(0);
            notNull2 = (RexCall)notNullCall.operands.get(2);
        } else if (this.isOperandSqlEq(notNullCall, 2) && this.isOperandSqlIsNotNull(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 1)) {
            equalCall = (RexCall)notNullCall.operands.get(2);
            notNull1 = (RexCall)notNullCall.operands.get(0);
            notNull2 = (RexCall)notNullCall.operands.get(1);
        } else {
            return Collections.emptyList();
        }
        if (((RexNode)equalCall.operands.get(0)).equals(equalCall.operands.get(1))) {
            return Collections.emptyList();
        }
        if (!refs.contains(equalCall.operands.get(0)) || !refs.contains(equalCall.operands.get(1))) {
            return Collections.emptyList();
        }
        if (((RexNode)notNull1.operands.get(0)).equals(notNull2.operands.get(0))) {
            return Collections.emptyList();
        }
        if (!refs.contains(notNull1.operands.get(0)) || !refs.contains(notNull2.operands.get(0))) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)refs);
    }

    private boolean isOperandInputRef(RexCall call, int ordinal) {
        return call.operands.get(ordinal) instanceof RexInputRef;
    }

    private boolean isOperandSqlEq(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.EQUALS);
    }

    private boolean isOperandSqlAnd(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.AND);
    }

    private boolean isOperandSqlIsNull(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.IS_NULL);
    }

    private boolean isOperandSqlIsNotNull(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.IS_NOT_NULL);
    }

    private boolean isOperandSqlKind(RexCall call, int ordinal, SqlKind kind) {
        return this.isOperandRexCall(call, ordinal) && ((RexNode)call.operands.get(ordinal)).getKind() == kind;
    }

    private boolean isOperandRexCall(RexCall call, int ordinal) {
        return call.operands.get(ordinal) instanceof RexCall;
    }

    private boolean isScd2JoinCondition(JoinInfo joinInfo, LogicalJoin join, List<RexInputRef> scd2Refs) {
        boolean isScd2;
        if (joinInfo.isEqui() || !this.isScd2Enabled) {
            return false;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RexNode remaining = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)joinInfo.nonEquiConditions);
        if (remaining == null) {
            return false;
        }
        RexNode cnf = RexUtil.toCnf((RexBuilder)rexBuilder, (RexNode)remaining);
        if (!(cnf instanceof RexCall) || cnf.getKind() != SqlKind.AND) {
            return false;
        }
        List nodeList = ((RexCall)cnf).getOperands();
        if (nodeList.size() % 2 != 0) {
            return false;
        }
        HashMap refOpMap = Maps.newHashMap();
        for (RexNode rexNode : nodeList) {
            if (!rexNode.isA(SCD2_KINDS)) {
                return false;
            }
            RexCall call = (RexCall)rexNode;
            RexInputRef left = this.extractInputRef((RexNode)call.getOperands().get(0));
            RexInputRef right = this.extractInputRef((RexNode)call.getOperands().get(1));
            if (left == null || right == null) {
                return false;
            }
            refOpMap.putIfAbsent(left, Lists.newArrayList());
            refOpMap.putIfAbsent(right, Lists.newArrayList());
            ((List)refOpMap.get(left)).add((RexCall)rexBuilder.makeCall(call.getOperator(), new RexNode[]{left, right}));
            ((List)refOpMap.get(right)).add((RexCall)rexBuilder.makeCall(this.inverse(call.getOperator()), new RexNode[]{right, left}));
        }
        refOpMap.entrySet().removeIf(entry -> ((List)entry.getValue()).size() != 2);
        AtomicInteger allSize = new AtomicInteger();
        refOpMap.forEach((k, pairs) -> {
            SqlOperator second;
            SqlOperator first = ((RexCall)pairs.get(0)).getOperator();
            if (!first.equals((Object)(second = ((RexCall)pairs.get(1)).getOperator())) && ALLOWED_PAIRS.contains(ImmutableSet.of((Object)first, (Object)second))) {
                allSize.getAndAdd(2);
            }
        });
        boolean bl = isScd2 = allSize.get() == nodeList.size();
        if (isScd2) {
            scd2Refs.addAll(refOpMap.keySet());
        }
        return isScd2;
    }

    private RexInputRef extractInputRef(RexNode node) {
        if (node.isA(SqlKind.INPUT_REF)) {
            return (RexInputRef)node;
        }
        if (node.isA(SqlKind.CAST) && node instanceof RexCall) {
            RexCall call = (RexCall)node;
            if (call.operands.size() == 1) {
                RexNode rexNode = (RexNode)call.operands.get(0);
                return rexNode.isA(SqlKind.INPUT_REF) ? (RexInputRef)rexNode : null;
            }
        }
        return null;
    }
}

