/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.exec;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.engine.exec.CalcitePlanExec;
import org.apache.kylin.query.engine.exec.ExecuteResult;
import org.apache.kylin.query.engine.exec.QueryPlanExec;
import org.apache.kylin.query.engine.exec.sparder.QueryEngine;
import org.apache.kylin.query.engine.meta.MutableDataContext;
import org.apache.kylin.query.engine.meta.SimpleDataContext;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.runtime.SparkEngine;
import org.apache.kylin.query.util.QueryContextCutter;
import org.apache.kylin.query.util.QueryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparderPlanExec
implements QueryPlanExec {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparderPlanExec.class);
    private KylinConfig kylinConfig;

    public SparderPlanExec(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    @Override
    public List<List<String>> execute(RelNode rel, MutableDataContext dataContext) {
        return ImmutableList.copyOf((Iterable)this.executeToIterable(rel, dataContext).getRows());
    }

    @Override
    public ExecuteResult executeToIterable(RelNode rel, MutableDataContext dataContext) {
        ContextUtil.dumpCalcitePlan((String)"Calcite PLAN BEFORE SELECT REALIZATION:", (RelNode)rel, (Logger)log);
        QueryContext.current().record("end_plan");
        QueryContext.current().getQueryTagInfo().setWithoutSyntaxError(true);
        QueryContext.currentTrace().startSpan("MODEL_MATCHING");
        QueryContextCutter.selectRealization(QueryContext.current().getProject(), rel, QueryContext.current().isForModeling());
        QueryContext.current().getQueryPlan().setCalcitePlan(RelOptUtil.toString((RelNode)rel));
        ContextUtil.dumpCalcitePlan((String)"Calcite PLAN AFTER SELECT REALIZATION:", (RelNode)rel, (Logger)log);
        if (NProjectManager.getProjectConfig((String)QueryContext.current().getProject()).isPrintQueryPlanEnabled()) {
            log.info(QueryContext.current().getQueryPlan().getCalcitePlan());
        }
        List contexts = ContextUtil.listContexts();
        if (KapConfig.wrap((KylinConfig)this.kylinConfig).runConstantQueryLocally() && this.checkNotAsyncQueryAndCalciteEngineCapable(rel) && contexts.stream().allMatch(context -> this.hasEmptyRealization((OlapContext)context))) {
            return new CalcitePlanExec().executeToIterable(rel, dataContext);
        }
        if (!(dataContext instanceof SimpleDataContext) || !((SimpleDataContext)dataContext).isContentQuery() || KapConfig.wrap((KylinConfig)((SimpleDataContext)dataContext).getKylinConfig()).runConstantQueryLocally()) {
            for (OlapContext context2 : contexts) {
                if (context2.getOlapSchema() == null || !context2.getStorageContext().isDataSkipped()) continue;
                QueryContext.current().setOutOfSegmentRange(true);
                if (QueryContext.current().getQueryTagInfo().isAsyncQuery() || context2.isHasAgg()) continue;
                QueryContext.fillEmptyResultSetMetrics();
                return new ExecuteResult((Iterable)Lists.newArrayList(), 0);
            }
        }
        this.rewrite(rel);
        if (QueryContext.current().getQueryTagInfo().isQueryDetect()) {
            return new ExecuteResult((Iterable)Lists.newArrayList(), 0);
        }
        if (this.checkNotAsyncQueryAndCalciteEngineCapable(rel) && this.isAllOlapContextCanBeAnsweredLocally(contexts)) {
            return new CalcitePlanExec().executeToIterable(rel, dataContext);
        }
        return this.internalCompute((QueryEngine)new SparkEngine(), dataContext, rel.getInput(0));
    }

    private boolean checkNotAsyncQueryAndCalciteEngineCapable(RelNode rel) {
        return !QueryContext.current().getQueryTagInfo().isAsyncQuery() && QueryHelper.isCalciteEngineCapable(rel);
    }

    private boolean isAllOlapContextCanBeAnsweredLocally(List<OlapContext> olapContexts) {
        boolean runConstantQueryLocally = KapConfig.wrap((KylinConfig)this.kylinConfig).runConstantQueryLocally();
        boolean runQueryLocallyWhenRouteToMetadata = this.kylinConfig.runQueryLocallyWhenRouteToMetadata();
        for (OlapContext olapContext : olapContexts) {
            if (this.isOlapContextCanBeAnsweredLocally(olapContext, runConstantQueryLocally, runQueryLocallyWhenRouteToMetadata)) continue;
            return false;
        }
        return true;
    }

    private boolean isOlapContextCanBeAnsweredLocally(OlapContext olapContext, boolean runConstantQueryLocally, boolean runQueryLocallyWhenRouteToMetadata) {
        if (!runConstantQueryLocally && !runQueryLocallyWhenRouteToMetadata) {
            return false;
        }
        OlapRel topNode = olapContext.getTopNode();
        if (runConstantQueryLocally && QueryHelper.isConstantQueryAndCalciteEngineCapable((RelNode)topNode)) {
            return true;
        }
        if (runConstantQueryLocally && this.hasEmptyRealization(olapContext)) {
            return true;
        }
        return runQueryLocallyWhenRouteToMetadata && olapContext.checkOlapContextAnsweredByMetadata();
    }

    private boolean hasEmptyRealization(OlapContext context) {
        return context.getRealization() == null && context.isConstantQueryWithAggregations();
    }

    protected ExecuteResult internalCompute(QueryEngine queryEngine, DataContext dataContext, RelNode rel) {
        return queryEngine.computeToIterable(dataContext, rel);
    }

    private void rewrite(RelNode rel) {
        OlapRel.RewriteImpl rewriteImpl = new OlapRel.RewriteImpl();
        rewriteImpl.visitChild(rel, rel.getInput(0));
        ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER REWRITE", (RelNode)rel, (Logger)log);
        QueryContext.current().getQueryTagInfo().setSparderUsed(true);
        boolean exactlyMatch = ContextUtil.listContextsHavingScan().stream().noneMatch(this::isAggImperfectMatch);
        QueryContext.current().getMetrics().setExactlyMatch(exactlyMatch);
        ContextUtil.setOlapRel((OlapRel)((OlapRel)rel.getInput(0)));
        ContextUtil.setRowType((RelDataType)rel.getRowType());
        QueryContext.current().record("end_rewrite");
    }

    private boolean isAggImperfectMatch(OlapContext ctx) {
        NLayoutCandidate candidate = ctx.getStorageContext().getBatchCandidate();
        long layoutId = candidate.getLayoutEntity().getId();
        return layoutId < 0L || IndexEntity.isAggIndex((long)layoutId) && !ctx.isExactlyAggregate() || IndexEntity.isTableIndex((long)layoutId) && ctx.isHasAgg();
    }
}

