/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.response.MetricsResponse;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.query.exception.UnsupportedQueryException;
import org.apache.kylin.rest.response.JobStatisticsResponse;
import org.apache.kylin.rest.response.NDataModelOldParams;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.QueryStatisticsResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.QueryHistoryService;
import org.apache.kylin.rest.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="dashboardService")
public class DashboardService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);
    public static final Logger logger = LoggerFactory.getLogger(DashboardService.class);
    public static final String DAY = "day";
    public static final String AVG_QUERY_LATENCY = "AVG_QUERY_LATENCY";
    public static final String JOB = "JOB";
    public static final String AVG_JOB_BUILD_TIME = "AVG_JOB_BUILD_TIME";
    private static final String QUERY = "QUERY";
    private static final String QUERY_COUNT = "QUERY_COUNT";
    private static final String JOB_COUNT = "JOB_COUNT";
    @Autowired
    ModelService modelService;
    @Autowired
    QueryHistoryService queryHistoryService;
    @Autowired
    JobService jobService;

    public MetricsResponse getModelMetrics(String projectName, String modelName) {
        MetricsResponse modelMetrics = new MetricsResponse();
        long totalModelSize = 0L;
        long totalRecordSize = 0L;
        List models = this.modelService.getCubes0(modelName, projectName);
        int totalModel = models.size();
        ProjectInstance project = this.getProjectManager().getProject(projectName);
        modelMetrics.increase("totalModel", Float.valueOf(totalModel += project.getRealizationCount("HYBRID")));
        float minModelExpansion = Float.POSITIVE_INFINITY;
        float maxModelExpansion = Float.NEGATIVE_INFINITY;
        for (NDataModelResponse dataModel : models) {
            NDataModelOldParams params = dataModel.getOldParams();
            if (params.getInputRecordSizeBytes() <= 0L) continue;
            totalModelSize += params.getSizeKB() * 1024L;
            totalRecordSize += params.getInputRecordSizeBytes();
            float modelExpansion = Float.parseFloat(dataModel.getExpansionrate());
            if (modelExpansion > maxModelExpansion) {
                maxModelExpansion = modelExpansion;
            }
            if (!(modelExpansion < minModelExpansion)) continue;
            minModelExpansion = modelExpansion;
        }
        float avgModelExpansion = 0.0f;
        if (totalRecordSize != 0L) {
            avgModelExpansion = Float.parseFloat(ModelUtils.computeExpansionRate((long)totalModelSize, (long)totalRecordSize));
        }
        modelMetrics.increase("avgModelExpansion", Float.valueOf(avgModelExpansion));
        modelMetrics.increase("maxModelExpansion", Float.valueOf(maxModelExpansion));
        modelMetrics.increase("minModelExpansion", Float.valueOf(minModelExpansion));
        return modelMetrics;
    }

    public MetricsResponse getQueryMetrics(String projectName, String startTime, String endTime) {
        MetricsResponse queryMetrics = new MetricsResponse();
        QueryStatisticsResponse queryStatistics = this.queryHistoryService.getQueryStatisticsByRealization(projectName, this.convertToTimestamp(startTime), this.convertToTimestamp(endTime));
        Float queryCount = Float.valueOf(queryStatistics.getCount());
        Float avgQueryLatency = Float.valueOf((float)queryStatistics.getMean());
        queryMetrics.increase("queryCount", queryCount);
        queryMetrics.increase("avgQueryLatency", avgQueryLatency);
        return queryMetrics;
    }

    public MetricsResponse getJobMetrics(String projectName, String startTime, String endTime) {
        MetricsResponse jobMetrics = new MetricsResponse();
        JobStatisticsResponse jobStats = this.jobService.getJobStats(projectName, this.convertToTimestamp(startTime), this.convertToTimestamp(endTime));
        Float jobCount = Float.valueOf(jobStats.getCount());
        Float jobTotalByteSize = Float.valueOf(jobStats.getTotalByteSize());
        Float jobTotalLatency = Float.valueOf(jobStats.getTotalDuration());
        jobMetrics.increase("jobCount", jobCount);
        jobMetrics.increase("jobTotalByteSize", jobTotalByteSize);
        jobMetrics.increase("jobTotalLatency", jobTotalLatency);
        return jobMetrics;
    }

    public MetricsResponse getChartData(String category, String projectName, String startTime, String endTime, String dimension, String metric) {
        long _startTime = this.convertToTimestamp(startTime);
        long _endTime = this.convertToTimestamp(endTime);
        switch (category) {
            case "QUERY": {
                switch (metric) {
                    case "QUERY_COUNT": {
                        Map<String, Object> queryCounts = this.queryHistoryService.getQueryCountByRealization(projectName, _startTime, _endTime, StringUtils.lowerCase((String)dimension));
                        return this.transformChartData(queryCounts);
                    }
                    case "AVG_QUERY_LATENCY": {
                        Map<String, Object> avgDurations = this.queryHistoryService.getAvgDurationByRealization(projectName, _startTime, _endTime, StringUtils.lowerCase((String)dimension));
                        return this.transformChartData(avgDurations);
                    }
                }
                throw new UnsupportedQueryException("Metric should be COUNT or AVG_QUERY_LATENCY");
            }
            case "JOB": {
                switch (metric) {
                    case "JOB_COUNT": {
                        Map jobCounts = this.jobService.getJobCount(projectName, _startTime, _endTime, StringUtils.lowerCase((String)dimension));
                        MetricsResponse counts = new MetricsResponse();
                        jobCounts.forEach((k, v) -> counts.increase(k, Float.valueOf(v.intValue())));
                        return counts;
                    }
                    case "AVG_JOB_BUILD_TIME": {
                        Map jobDurationPerByte = this.jobService.getJobDurationPerByte(projectName, _startTime, _endTime, StringUtils.lowerCase((String)dimension));
                        MetricsResponse avgBuild = new MetricsResponse();
                        jobDurationPerByte.forEach((k, v) -> avgBuild.increase(k, Float.valueOf(Float.parseFloat(String.valueOf(v)))));
                        return avgBuild;
                    }
                }
                throw new UnsupportedQueryException("Metric should be JOB_COUNT or AVG_JOB_BUILD_TIME");
            }
        }
        throw new UnsupportedQueryException("Category should either be QUERY or JOB");
    }

    private MetricsResponse transformChartData(Map<String, Object> responses) {
        MetricsResponse metrics = new MetricsResponse();
        for (Map.Entry<String, Object> entry : responses.entrySet()) {
            String metric = entry.getKey();
            float value = Float.parseFloat(entry.getValue().toString());
            metrics.increase(metric, Float.valueOf(value));
        }
        return metrics;
    }

    private long convertToTimestamp(String time) {
        Date date;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT)).parse(time);
        }
        catch (ParseException e) {
            logger.error("parse time to timestamp error!");
            return 0L;
        }
        return date.getTime();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    private void checkAuthorization(ProjectInstance project) throws AccessDeniedException {
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    private void checkAuthorization() throws AccessDeniedException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkAuthorization(String projectName) {
        if (projectName != null && !projectName.isEmpty()) {
            ProjectInstance project = this.getProjectManager().getProject(projectName);
            try {
                this.checkAuthorization(project);
                return;
            }
            catch (AccessDeniedException e) {
                List models = this.modelService.getCubes0(null, projectName);
                if (!models.isEmpty()) return;
                throw new AccessDeniedException("Access is denied");
            }
        } else {
            this.checkAuthorization();
        }
    }
}

