/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.extension.KylinInfoExtension;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.DefaultSparkBuildJobHandler;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.SparkAppDescription;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.util.DumpInfo;
import org.apache.kylin.util.MetadataDumpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryJob
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(AsyncQueryJob.class);
    private static final MetadataType[] META_DUMP_LIST = new MetadataType[]{MetadataType.DATAFLOW, MetadataType.LAYOUT, MetadataType.INDEX_PLAN, MetadataType.MODEL, MetadataType.TABLE_INFO, MetadataType.TABLE_EXD, MetadataType.USER_GLOBAL_ACL, MetadataType.ACL, MetadataType.OBJECT_ACL, MetadataType.PROJECT, MetadataType.COMPUTE_COLUMN, MetadataType.SEGMENT, MetadataType.USER_GROUP, MetadataType.SQL_BLACKLIST, MetadataType.FUSION_MODEL, MetadataType.RESOURCE_GROUP};

    public AsyncQueryJob() {
    }

    public AsyncQueryJob(Object notSetId) {
        super(notSetId);
    }

    protected void initHandler() {
        this.sparkJobHandler = new DefaultSparkBuildJobHandler();
    }

    protected ExecuteResult runSparkSubmit(String hadoopConf, String kylinJobJar, String appArgs) {
        BufferedLogger patternedLogger = new BufferedLogger(logger);
        try {
            this.killOrphanApplicationIfExists(this.getId());
            SparkAppDescription desc = this.getSparkAppDesc();
            desc.setHadoopConfDir(hadoopConf);
            desc.setKylinJobJar(kylinJobJar);
            desc.setAppArgs(appArgs);
            String cmd = (String)this.sparkJobHandler.generateSparkCmd(KylinConfig.getInstanceFromEnv(), desc);
            CliCommandExecutor exec = this.getCliCommandExecutor();
            CliCommandExecutor.CliCmdExecResult r = exec.execute(cmd, (org.apache.kylin.common.util.Logger)patternedLogger, this.getId());
            return ExecuteResult.createSucceed((String)r.getCmd());
        }
        catch (Exception e) {
            return ExecuteResult.createError((Throwable)e);
        }
    }

    @VisibleForTesting
    public CliCommandExecutor getCliCommandExecutor() {
        return new CliCommandExecutor();
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map overrides = config.getAsyncQuerySparkConfigOverride();
        if (StringUtils.isNotEmpty((CharSequence)this.getParam("queryQueue"))) {
            overrides.put("spark.yarn.queue", this.getParam("queryQueue"));
        }
        if (!overrides.containsKey("spark.driver.memory")) {
            overrides.put("spark.driver.memory", "1024m");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            overrides.put("spark.hadoop.hive.metastore.sasl.enabled", "true");
        }
        return ExecutableUtil.removeGultenParams((Map)overrides);
    }

    protected String getJobNamePrefix() {
        return "";
    }

    protected String getExtJar() {
        return this.getConfig().getKylinExtJarsPath(Boolean.valueOf(this.getConfig().uniqueAsyncQueryUseGlutenEnabled()));
    }

    public String getId() {
        return "ASYNC-QUERY-" + super.getId();
    }

    public ExecuteResult submit(QueryParams queryParams) throws ExecuteException, JsonProcessingException {
        KylinConfigExt config;
        String kylinJobJar;
        this.setLogPath(this.getSparkDriverLogHdfsPath(this.getConfig()));
        KylinConfig originConfig = this.getConfig();
        HashMap overrideCopy = Maps.newHashMap((Map)((KylinConfigExt)originConfig).getExtendedOverrides());
        if (StringUtils.isNotEmpty((CharSequence)queryParams.getSparkQueue())) {
            overrideCopy.put("kylin.query.async-query.spark-conf.spark.yarn.queue", queryParams.getSparkQueue());
        }
        if (StringUtils.isEmpty((CharSequence)(kylinJobJar = (config = KylinConfigExt.createInstance((KylinConfig)originConfig, (Map)overrideCopy)).getKylinJobJarPath())) && !config.isUTEnv()) {
            throw new KylinRuntimeException("Missing kylin job jar");
        }
        ObjectMapper fieldOnlyMapper = new ObjectMapper();
        fieldOnlyMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.setParam("queryParams", fieldOnlyMapper.writeValueAsString((Object)queryParams));
        this.setParam("queryContext", JsonUtil.writeValueAsString((Object)QueryContext.current()));
        this.setParam("project", this.getProject());
        this.setParam("queryId", QueryContext.current().getQueryId());
        this.setParam("jobId", this.getId());
        this.setParam("jobType", JobTypeEnum.ASYNC_QUERY.toString());
        this.setParam("queryQueue", queryParams.getSparkQueue());
        this.setDistMetaUrl(config.getJobTmpMetaStoreUrl(this.getProject(), this.getId()));
        try {
            config.setQueryHistoryUrl(config.getQueryHistoryUrl().toString());
            this.dumpKylinProps((KylinConfig)config);
            DumpInfo dumpInfo = this.generateDumpInfo((KylinConfig)config, DumpInfo.DumpType.ASYNC_QUERY);
            MetadataDumpUtil.dumpMetadata((DumpInfo)dumpInfo);
        }
        catch (Exception e) {
            throw new ExecuteException("kylin properties or meta dump failed", (Throwable)e);
        }
        return this.runSparkSubmit(this.getHadoopConfDir(), kylinJobJar, "-className org.apache.kylin.query.engine.AsyncQueryApplication " + this.createArgsFileOnHDFS((KylinConfig)config, this.getId()));
    }

    protected Set<String> getMetadataDumpList(KylinConfig config) {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        HashSet<String> metadataDumpSet = new HashSet<String>();
        for (MetadataType mata : META_DUMP_LIST) {
            NavigableSet metadata = MetadataType.NON_GLOBAL_METADATA_TYPE.contains(mata) ? resourceStore.listResourcesRecursively(mata.name(), RawResourceFilter.equalFilter((String)"project", (String)this.getProject())) : resourceStore.listResourcesRecursively(mata.name());
            if (metadata == null) continue;
            metadataDumpSet.addAll(metadata);
        }
        return metadataDumpSet;
    }

    private String getHadoopConfDir() {
        KylinConfig kylinconfig = KylinConfig.getInstanceFromEnv();
        if (StringUtils.isNotEmpty((CharSequence)kylinconfig.getAsyncQueryHadoopConfDir())) {
            return kylinconfig.getAsyncQueryHadoopConfDir();
        }
        return HadoopUtil.getHadoopConfDir();
    }

    public void modifyDump(Properties props) {
        super.modifyDump(props);
        if (!KylinInfoExtension.getFactory().checkKylinInfo()) {
            props.setProperty("kylin.streaming.enabled", "false");
        }
        props.put("kylin.internal-table-enabled", "false");
        props.remove("kylin.storage.columnar.spark-conf.spark.sql.catalog.INTERNAL_CATALOG");
    }

    public boolean needRemoveGlutenParams(KylinConfig config) {
        return config.buildUseGlutenEnabled();
    }
}

